/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.coloc.maxTKendallTau;

import java.util.function.BiFunction;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.image.AbstractColocalisationTest;
import org.scijava.ops.image.coloc.ShuffledView;
import org.scijava.ops.image.coloc.maxTKendallTau.MTKT;
import org.scijava.ops.image.coloc.pValue.PValueResult;
import org.scijava.types.Nil;

public class MTKTTest
extends AbstractColocalisationTest {
    @Test
    public void testRankTransformationNoTie() {
        double[][] values = new double[4][2];
        double[] values1 = new double[]{2.1, 1.2, 3.3, 4.6};
        double[] values2 = new double[]{2.1, 1.2, 3.3, 4.6};
        for (int i = 0; i < 4; ++i) {
            values[i][0] = values1[i];
            values[i][1] = values2[i];
        }
        ArrayImg vImage1 = ArrayImgs.doubles((double[])values1, (long[])new long[]{values1.length});
        ArrayImg vImage2 = ArrayImgs.doubles((double[])values2, (long[])new long[]{values2.length});
        long seed = -1993333951L;
        double[][] rank = MTKT.rankTransformation((RandomAccessibleInterval)vImage1, (RandomAccessibleInterval)vImage2, (double)0.0, (double)0.0, (int)4, (long)seed);
        double[] expectedRankOrder = new double[]{1.0, 0.0, 2.0, 3.0};
        for (int i = 0; i < 4; ++i) {
            Assertions.assertEquals((double)expectedRankOrder[i], (double)rank[i][0], (double)0.0);
            Assertions.assertEquals((double)expectedRankOrder[i], (double)rank[i][1], (double)0.0);
        }
    }

    @Test
    public void testRankTransformationTie() {
        double[][] values = new double[4][2];
        double[] values1 = new double[]{2.1, 3.0, 3.0, 4.2};
        double[] values2 = new double[]{2.1, 3.0, 3.0, 4.2};
        for (int i = 0; i < 4; ++i) {
            values[i][0] = values1[i];
            values[i][1] = values2[i];
        }
        ArrayImg vImage1 = ArrayImgs.doubles((double[])values1, (long[])new long[]{values1.length});
        ArrayImg vImage2 = ArrayImgs.doubles((double[])values2, (long[])new long[]{values2.length});
        long seed = -1993333951L;
        double[][] rank = MTKT.rankTransformation((RandomAccessibleInterval)vImage1, (RandomAccessibleInterval)vImage2, (double)0.0, (double)0.0, (int)4, (long)seed);
        double[] expectedRankOrder1 = new double[]{0.0, 1.0, 2.0, 3.0};
        double[] expectedRankOrder2 = new double[]{0.0, 2.0, 1.0, 3.0};
        for (int i = 0; i < 4; ++i) {
            Assertions.assertEquals((double)expectedRankOrder1[0], (double)rank[0][0], (double)0.0);
            Assertions.assertEquals((double)expectedRankOrder1[0], (double)rank[0][1], (double)0.0);
            if (rank[1][0] == 1.0) {
                Assertions.assertEquals((double)expectedRankOrder1[1], (double)rank[1][0], (double)0.0);
            } else if (rank[1][0] == 2.0) {
                Assertions.assertEquals((double)expectedRankOrder2[1], (double)rank[1][0], (double)0.0);
            }
            if (rank[1][1] == 1.0) {
                Assertions.assertEquals((double)expectedRankOrder1[1], (double)rank[1][1], (double)0.0);
            } else if (rank[1][1] == 2.0) {
                Assertions.assertEquals((double)expectedRankOrder2[1], (double)rank[1][1], (double)0.0);
            }
            if (rank[2][0] == 2.0) {
                Assertions.assertEquals((double)expectedRankOrder1[2], (double)rank[2][0], (double)0.0);
            } else if (rank[2][0] == 1.0) {
                Assertions.assertEquals((double)expectedRankOrder2[2], (double)rank[2][0], (double)0.0);
            }
            if (rank[2][1] == 2.0) {
                Assertions.assertEquals((double)expectedRankOrder1[2], (double)rank[2][1], (double)0.0);
            } else if (rank[2][1] == 1.0) {
                Assertions.assertEquals((double)expectedRankOrder2[2], (double)rank[2][1], (double)0.0);
            }
            Assertions.assertEquals((double)expectedRankOrder1[3], (double)rank[3][0], (double)0.0);
            Assertions.assertEquals((double)expectedRankOrder1[3], (double)rank[3][1], (double)0.0);
        }
    }

    @Test
    public void testMTKTnone() {
        double[][] values = new double[10][2];
        double[] values1 = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        double[] values2 = new double[]{10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0};
        for (int i = 0; i < 4; ++i) {
            values[i][0] = values1[i];
            values[i][1] = values2[i];
        }
        ArrayImg vImage1 = ArrayImgs.doubles((double[])values1, (long[])new long[]{values1.length});
        ArrayImg vImage2 = ArrayImgs.doubles((double[])values2, (long[])new long[]{values2.length});
        double result = (Double)ops.op("coloc.maxTKendallTau").input((Object)vImage1, (Object)vImage2).outType(Double.class).apply();
        Assertions.assertEquals((double)Double.MIN_VALUE, (double)result, (double)0.0);
    }

    @Test
    public void testMTKTall() {
        double[][] values = new double[10][2];
        double[] values1 = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0};
        double[] values2 = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0};
        for (int i = 0; i < 4; ++i) {
            values[i][0] = values1[i];
            values[i][1] = values2[i];
        }
        ArrayImg vImage1 = ArrayImgs.doubles((double[])values1, (long[])new long[]{values1.length});
        ArrayImg vImage2 = ArrayImgs.doubles((double[])values2, (long[])new long[]{values2.length});
        double result = (Double)ops.op("coloc.maxTKendallTau").input((Object)vImage1, (Object)vImage2).apply();
        Assertions.assertEquals((double)1.0, (double)result, (double)0.0);
    }

    @Test
    public void testMTKTrandom() {
        double mean = 0.2;
        double spread = 0.1;
        double[] sigma = new double[]{3.0, 3.0};
        Img<FloatType> ch1 = AbstractColocalisationTest.produceMeanBasedNoiseImage(new FloatType(), 24, 24, 0.2, 0.1, sigma, 19088743L);
        Img<FloatType> ch2 = AbstractColocalisationTest.produceMeanBasedNoiseImage(new FloatType(), 24, 24, 0.2, 0.1, sigma, -1737075662L);
        double result = (Double)ops.op("coloc.maxTKendallTau").input(ch1, ch2).apply();
        Assertions.assertEquals((double)2.710687382741972, (double)result, (double)0.0);
    }

    @Test
    public void testMTKTimage() {
        IntervalView cropCh1 = Views.interval(MTKTTest.getZeroCorrelationImageCh1(), (long[])new long[]{0L, 0L, 0L}, (long[])new long[]{20L, 20L, 0L});
        IntervalView cropCh2 = Views.interval(MTKTTest.getZeroCorrelationImageCh2(), (long[])new long[]{0L, 0L, 0L}, (long[])new long[]{20L, 20L, 0L});
        double result = (Double)ops.op("coloc.maxTKendallTau").input((Object)cropCh1, (Object)cropCh2).apply();
        Assertions.assertEquals((double)2.562373279563565, (double)result, (double)0.0);
    }

    @Test
    public void testMTKTpValueNone() {
        double[][] values = new double[10][2];
        double[] values1 = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        double[] values2 = new double[]{10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0};
        for (int i = 0; i < 4; ++i) {
            values[i][0] = values1[i];
            values[i][1] = values2[i];
        }
        ArrayImg vImage1 = ArrayImgs.doubles((double[])values1, (long[])new long[]{values1.length});
        ArrayImg vImage2 = ArrayImgs.doubles((double[])values2, (long[])new long[]{values2.length});
        BiFunction op = OpBuilder.matchFunction((OpEnvironment)ops, (String)"coloc.maxTKendallTau", (Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){}, (Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){}, (Nil)new Nil<Double>(){});
        PValueResult value = new PValueResult();
        ops.op("coloc.pValue").input((Object)vImage1, (Object)vImage2, (Object)op, (Object)5).output((Object)value).compute();
        Assertions.assertEquals((double)0.0, (double)value.getPValue(), (double)0.0);
    }

    @Test
    public void testMTKTpValueAll() {
        double[][] values = new double[10][2];
        double[] values1 = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0};
        double[] values2 = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0};
        for (int i = 0; i < 4; ++i) {
            values[i][0] = values1[i];
            values[i][1] = values2[i];
        }
        ArrayImg vImage1 = ArrayImgs.doubles((double[])values1, (long[])new long[]{values1.length});
        ArrayImg vImage2 = ArrayImgs.doubles((double[])values2, (long[])new long[]{values2.length});
        BiFunction op = OpBuilder.matchFunction((OpEnvironment)ops, (String)"coloc.maxTKendallTau", (Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){}, (Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){}, (Nil)new Nil<Double>(){});
        PValueResult value = new PValueResult();
        ops.op("coloc.pValue").input((Object)vImage1, (Object)vImage2, (Object)op, (Object)5).output((Object)value).compute();
        Assertions.assertEquals((double)0.0, (double)value.getPValue(), (double)0.0);
    }

    @Test
    public void testMTKTpValueRandom() {
        double mean = 0.2;
        double spread = 0.1;
        double[] sigma = new double[]{3.0, 3.0};
        Img<FloatType> ch1 = AbstractColocalisationTest.produceMeanBasedNoiseImage(new FloatType(), 24, 24, 0.2, 0.1, sigma, 19088743L);
        Img<FloatType> ch2 = AbstractColocalisationTest.produceMeanBasedNoiseImage(new FloatType(), 24, 24, 0.2, 0.1, sigma, -1737075662L);
        BiFunction op = OpBuilder.matchFunction((OpEnvironment)ops, (String)"coloc.maxTKendallTau", (Nil)new Nil<RandomAccessibleInterval<FloatType>>(){}, (Nil)new Nil<RandomAccessibleInterval<FloatType>>(){}, (Nil)new Nil<Double>(){});
        PValueResult value = new PValueResult();
        ops.op("coloc.pValue").input(ch1, ch2, (Object)op, (Object)10).output((Object)value).compute();
        Assertions.assertEquals((double)0.2, (double)value.getPValue(), (double)0.0);
    }

    @Test
    public void testMTKTpValueImage() {
        IntervalView cropCh1 = Views.interval(MTKTTest.getZeroCorrelationImageCh1(), (long[])new long[]{0L, 0L, 0L}, (long[])new long[]{20L, 20L, 0L});
        IntervalView cropCh2 = Views.interval(MTKTTest.getZeroCorrelationImageCh2(), (long[])new long[]{0L, 0L, 0L}, (long[])new long[]{20L, 20L, 0L});
        BiFunction op = OpBuilder.matchFunction((OpEnvironment)ops, (String)"coloc.maxTKendallTau", (Nil)new Nil<RandomAccessibleInterval<UnsignedByteType>>(){}, (Nil)new Nil<RandomAccessibleInterval<UnsignedByteType>>(){}, (Nil)new Nil<Double>(){});
        int[] blockSize = new int[cropCh1.numDimensions()];
        for (int d = 0; d < blockSize.length; ++d) {
            long size = (long)Math.floor(Math.sqrt(cropCh1.dimension(d)));
            blockSize[d] = (int)size;
        }
        RandomAccessibleInterval ch1 = ShuffledView.cropAtMin((RandomAccessibleInterval)cropCh1, (int[])blockSize);
        RandomAccessibleInterval ch2 = ShuffledView.cropAtMin((RandomAccessibleInterval)cropCh2, (int[])blockSize);
        PValueResult value = new PValueResult();
        ops.op("coloc.pValue").input((Object)ch1, (Object)ch2, (Object)op, (Object)5).output((Object)value).compute();
        Assertions.assertEquals((double)0.2, (double)value.getPValue(), (double)0.0);
    }
}

