/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.coloc.pValue;

import java.util.Arrays;
import java.util.function.BiFunction;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.numeric.real.FloatType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractColocalisationTest;
import org.scijava.ops.image.coloc.pValue.PValueResult;
import org.scijava.types.Nil;

public class DefaultPValueTest
extends AbstractColocalisationTest {
    @Test
    public void testPValuePerfectColoc() {
        double[] array = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.assertColoc(0.0, 1.0, array, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    @Test
    public void testPValueNoColoc() {
        double[] array = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        this.assertColoc(1.0, 0.0, array, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0);
    }

    @Test
    public void testPValueSomeColoc() {
        double[] array = new double[]{0.25, 0.25, 0.75, 0.75, 0.75};
        this.assertColoc(0.6, 0.25, array, 0.25, 0.25, 0.25, 0.75, 0.75, 0.75);
    }

    private void assertColoc(double expectedPValue, double expectedColocValue, double[] expectedColocValuesArray, double ... result) {
        ArrayImg ch1 = ArrayImgs.floats((long[])new long[]{1L});
        int[] count = new int[]{0};
        BiFunction op = (BiFunction)ops.typeLambda((Nil)new Nil<BiFunction<RandomAccessibleInterval<FloatType>, RandomAccessibleInterval<FloatType>, Double>>(){}, (input1, input2) -> {
            double r;
            DefaultPValueTest defaultPValueTest = this;
            synchronized (defaultPValueTest) {
                int n = count[0];
                count[0] = n + 1;
                r = result[n];
            }
            return r;
        });
        PValueResult output = new PValueResult();
        ops.op("coloc.pValue").input((Object)ch1, (Object)ch1, (Object)op, (Object)(result.length - 1)).output((Object)output).compute();
        Double actualPValue = output.getPValue();
        Double actualColocValue = output.getColocValue();
        double[] actualColocValuesArray = output.getColocValuesArray();
        Assertions.assertEquals((double)expectedPValue, (double)actualPValue, (double)0.0);
        Assertions.assertEquals((double)expectedColocValue, (double)actualColocValue, (double)0.0);
        Arrays.sort(actualColocValuesArray);
        for (int i = 0; i < expectedColocValuesArray.length; ++i) {
            Assertions.assertEquals((double)expectedColocValuesArray[i], (double)actualColocValuesArray[i], (double)0.0);
        }
    }
}

