/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.coloc.pearsons;

import java.util.function.BiFunction;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.real.FloatType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.image.AbstractColocalisationTest;
import org.scijava.ops.image.coloc.pValue.PValueResult;
import org.scijava.types.Nil;

public class DefaultPearsonsTest
extends AbstractColocalisationTest {
    @Test
    public void testFastPearsonsZeroCorr() {
        double result = (Double)ops.op("coloc.pearsons").input(DefaultPearsonsTest.getZeroCorrelationImageCh1(), DefaultPearsonsTest.getZeroCorrelationImageCh2()).outType(Double.class).apply();
        Assertions.assertEquals((double)0.0, (double)result, (double)0.05);
    }

    @Test
    public void testFastPearsonsPositiveCorr() {
        double result = (Double)ops.op("coloc.pearsons").input(DefaultPearsonsTest.getPositiveCorrelationImageCh1(), DefaultPearsonsTest.getPositiveCorrelationImageCh2()).outType(Double.class).apply();
        Assertions.assertEquals((double)0.75, (double)result, (double)0.01);
    }

    @Test
    public void testDifferentMeans() {
        double initialMean = 0.2;
        double spread = 0.1;
        double[] sigma = new double[]{3.0, 3.0};
        for (double mean = 0.2; mean < 1.0; mean += 0.1) {
            Img<FloatType> ch1 = DefaultPearsonsTest.produceMeanBasedNoiseImage(new FloatType(), 512, 512, mean, 0.1, sigma, 19088743L);
            Img<FloatType> ch2 = DefaultPearsonsTest.produceMeanBasedNoiseImage(new FloatType(), 512, 512, mean, 0.1, sigma, -1737075662L);
            double resultFast = (Double)ops.op("coloc.pearsons").input(ch1, ch2).outType(Double.class).apply();
            Assertions.assertEquals((double)0.0, (double)resultFast, (double)0.1);
        }
    }

    @Test
    public void testPValue() {
        double mean = 0.2;
        double spread = 0.1;
        double[] sigma = new double[]{3.0, 3.0};
        Img<FloatType> ch1 = AbstractColocalisationTest.produceMeanBasedNoiseImage(new FloatType(), 24, 24, 0.2, 0.1, sigma, 19088743L);
        Img<FloatType> ch2 = AbstractColocalisationTest.produceMeanBasedNoiseImage(new FloatType(), 24, 24, 0.2, 0.1, sigma, -1737075662L);
        BiFunction op = OpBuilder.matchFunction((OpEnvironment)ops, (String)"coloc.pearsons", (Nil)new Nil<RandomAccessibleInterval<FloatType>>(){}, (Nil)new Nil<RandomAccessibleInterval<FloatType>>(){}, (Nil)new Nil<Double>(){});
        PValueResult value = new PValueResult();
        ops.op("coloc.pValue").input(ch1, ch2, (Object)op).output((Object)value).compute();
        Assertions.assertEquals((double)0.66, (double)value.getPValue(), (double)0.0);
    }
}

