/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.convert;

import net.imglib2.Cursor;
import net.imglib2.FinalDimensions;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.ShortType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;

public class ConvertIIsTest
extends AbstractOpTest {
    private IterableInterval<ShortType> in;
    private Img<ByteType> out;

    @BeforeEach
    public void createImages() {
        FinalDimensions dims = FinalDimensions.wrap((long[])new long[]{10L, 10L});
        this.in = (IterableInterval)ops.op("create.img").input((Object)dims, (Object)new ShortType()).outType((Nil)new Nil<IterableInterval<ShortType>>(){}).apply();
        this.addNoise(this.in);
        this.out = (Img)ops.op("create.img").input((Object)dims, (Object)new ByteType()).outType((Nil)new Nil<Img<ByteType>>(){}).apply();
    }

    @Test
    public void testClip() {
        ops.op("convert.clip").input(this.in).output(this.out).compute();
        Cursor c = this.in.localizingCursor();
        RandomAccess ra = this.out.randomAccess();
        while (c.hasNext()) {
            short value = ((ShortType)c.next()).get();
            ra.setPosition((Localizable)c);
            Assertions.assertEquals((byte)this.clip(value), (byte)((ByteType)ra.get()).get());
        }
    }

    @Test
    public void testCopy() {
        ops.op("convert.copy").input(this.in).output(this.out).compute();
        Cursor c = this.in.localizingCursor();
        RandomAccess ra = this.out.randomAccess();
        while (c.hasNext()) {
            short value = ((ShortType)c.next()).get();
            ra.setPosition((Localizable)c);
            Assertions.assertEquals((byte)this.copy(value), (byte)((ByteType)ra.get()).get());
        }
    }

    private void addNoise(IterableInterval<ShortType> image) {
        IterableInterval copy = (IterableInterval)ops.op("copy.img").input(image).outType((Nil)new Nil<IterableInterval<ShortType>>(){}).apply();
        ops.op("filter.addNoise").input((Object)copy, (Object)-32768.0, (Object)32767.0, (Object)10000.0).output(image).compute();
    }

    private byte clip(short value) {
        if (value < -128) {
            return -128;
        }
        if (value > 127) {
            return 127;
        }
        return (byte)value;
    }

    private byte copy(short value) {
        return (byte)value;
    }
}

