/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.convert;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.Unsigned128BitType;
import net.imglib2.type.numeric.integer.Unsigned12BitType;
import net.imglib2.type.numeric.integer.Unsigned2BitType;
import net.imglib2.type.numeric.integer.Unsigned4BitType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedLongType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;

public class RAIConvertersTest
extends AbstractOpTest {
    public static void computeBitType(RandomAccessibleInterval<BitType> out) {
        LoopBuilder.setImages(out).forEachPixel(o -> o.setReal(1.0));
    }

    @Test
    public void testConvertBitTypeImage() {
        ArrayImg out = ArrayImgs.doubles((long[])new long[]{1L, 1L});
        ((DoubleType)out.firstElement()).set(0.0);
        ops.op("test.convert.image.BitType").output((Object)out).compute();
        double expected = 1.0;
        double actual = ((DoubleType)out.firstElement()).get();
        Assertions.assertEquals((double)expected, (double)actual);
    }

    public static void computeUnsigned2BitType(RandomAccessibleInterval<Unsigned2BitType> out) {
        LoopBuilder.setImages(out).forEachPixel(o -> o.setReal(1.0));
    }

    @Test
    public void testConvertUnsigned2BitTypeImage() {
        ArrayImg out = ArrayImgs.doubles((long[])new long[]{1L, 1L});
        ((DoubleType)out.firstElement()).set(0.0);
        ops.op("test.convert.image.Unsigned2BitType").output((Object)out).compute();
        double expected = 1.0;
        double actual = ((DoubleType)out.firstElement()).get();
        Assertions.assertEquals((double)expected, (double)actual);
    }

    public static void computeUnsigned4BitType(RandomAccessibleInterval<Unsigned4BitType> out) {
        LoopBuilder.setImages(out).forEachPixel(o -> o.setReal(1.0));
    }

    @Test
    public void testConvertUnsigned4BitTypeImage() {
        ArrayImg out = ArrayImgs.doubles((long[])new long[]{1L, 1L});
        ((DoubleType)out.firstElement()).set(0.0);
        ops.op("test.convert.image.Unsigned4BitType").output((Object)out).compute();
        double expected = 1.0;
        double actual = ((DoubleType)out.firstElement()).get();
        Assertions.assertEquals((double)expected, (double)actual);
    }

    public static void computeUnsignedByteType(RandomAccessibleInterval<UnsignedByteType> out) {
        LoopBuilder.setImages(out).forEachPixel(o -> o.setReal(1.0));
    }

    @Test
    public void testConvertUnsignedByteTypeImage() {
        ArrayImg out = ArrayImgs.doubles((long[])new long[]{1L, 1L});
        ((DoubleType)out.firstElement()).set(0.0);
        ops.op("test.convert.image.UnsignedByteType").output((Object)out).compute();
        double expected = 1.0;
        double actual = ((DoubleType)out.firstElement()).get();
        Assertions.assertEquals((double)expected, (double)actual);
    }

    public static void computeByteType(RandomAccessibleInterval<ByteType> out) {
        LoopBuilder.setImages(out).forEachPixel(o -> o.setReal(1.0));
    }

    @Test
    public void testConvertByteTypeImage() {
        ArrayImg out = ArrayImgs.doubles((long[])new long[]{1L, 1L});
        ((DoubleType)out.firstElement()).set(0.0);
        ops.op("test.convert.image.ByteType").output((Object)out).compute();
        double expected = 1.0;
        double actual = ((DoubleType)out.firstElement()).get();
        Assertions.assertEquals((double)expected, (double)actual);
    }

    public static void computeUnsignedShortType(RandomAccessibleInterval<UnsignedShortType> out) {
        LoopBuilder.setImages(out).forEachPixel(o -> o.setReal(1.0));
    }

    @Test
    public void testConvertUnsignedShortTypeImage() {
        ArrayImg out = ArrayImgs.doubles((long[])new long[]{1L, 1L});
        ((DoubleType)out.firstElement()).set(0.0);
        ops.op("test.convert.image.UnsignedShortType").output((Object)out).compute();
        double expected = 1.0;
        double actual = ((DoubleType)out.firstElement()).get();
        Assertions.assertEquals((double)expected, (double)actual);
    }

    public static void computeShortType(RandomAccessibleInterval<ShortType> out) {
        LoopBuilder.setImages(out).forEachPixel(o -> o.setReal(1.0));
    }

    @Test
    public void testConvertShortTypeImage() {
        ArrayImg out = ArrayImgs.doubles((long[])new long[]{1L, 1L});
        ((DoubleType)out.firstElement()).set(0.0);
        ops.op("test.convert.image.ShortType").output((Object)out).compute();
        double expected = 1.0;
        double actual = ((DoubleType)out.firstElement()).get();
        Assertions.assertEquals((double)expected, (double)actual);
    }

    public static void computeUnsigned12BitType(RandomAccessibleInterval<Unsigned12BitType> out) {
        LoopBuilder.setImages(out).forEachPixel(o -> o.setReal(1.0));
    }

    @Test
    public void testConvertUnsigned12BitTypeImage() {
        ArrayImg out = ArrayImgs.doubles((long[])new long[]{1L, 1L});
        ((DoubleType)out.firstElement()).set(0.0);
        ops.op("test.convert.image.Unsigned12BitType").output((Object)out).compute();
        double expected = 1.0;
        double actual = ((DoubleType)out.firstElement()).get();
        Assertions.assertEquals((double)expected, (double)actual);
    }

    public static void computeUnsignedIntType(RandomAccessibleInterval<UnsignedIntType> out) {
        LoopBuilder.setImages(out).forEachPixel(o -> o.setReal(1.0));
    }

    @Test
    public void testConvertUnsignedIntTypeImage() {
        ArrayImg out = ArrayImgs.doubles((long[])new long[]{1L, 1L});
        ((DoubleType)out.firstElement()).set(0.0);
        ops.op("test.convert.image.UnsignedIntType").output((Object)out).compute();
        double expected = 1.0;
        double actual = ((DoubleType)out.firstElement()).get();
        Assertions.assertEquals((double)expected, (double)actual);
    }

    public static void computeIntType(RandomAccessibleInterval<IntType> out) {
        LoopBuilder.setImages(out).forEachPixel(o -> o.setReal(1.0));
    }

    @Test
    public void testConvertIntTypeImage() {
        ArrayImg out = ArrayImgs.doubles((long[])new long[]{1L, 1L});
        ((DoubleType)out.firstElement()).set(0.0);
        ops.op("test.convert.image.IntType").output((Object)out).compute();
        double expected = 1.0;
        double actual = ((DoubleType)out.firstElement()).get();
        Assertions.assertEquals((double)expected, (double)actual);
    }

    public static void computeUnsignedLongType(RandomAccessibleInterval<UnsignedLongType> out) {
        LoopBuilder.setImages(out).forEachPixel(o -> o.setReal(1.0));
    }

    @Test
    public void testConvertUnsignedLongTypeImage() {
        ArrayImg out = ArrayImgs.doubles((long[])new long[]{1L, 1L});
        ((DoubleType)out.firstElement()).set(0.0);
        ops.op("test.convert.image.UnsignedLongType").output((Object)out).compute();
        double expected = 1.0;
        double actual = ((DoubleType)out.firstElement()).get();
        Assertions.assertEquals((double)expected, (double)actual);
    }

    public static void computeLongType(RandomAccessibleInterval<LongType> out) {
        LoopBuilder.setImages(out).forEachPixel(o -> o.setReal(1.0));
    }

    @Test
    public void testConvertLongTypeImage() {
        ArrayImg out = ArrayImgs.doubles((long[])new long[]{1L, 1L});
        ((DoubleType)out.firstElement()).set(0.0);
        ops.op("test.convert.image.LongType").output((Object)out).compute();
        double expected = 1.0;
        double actual = ((DoubleType)out.firstElement()).get();
        Assertions.assertEquals((double)expected, (double)actual);
    }

    public static void computeUnsigned128BitType(RandomAccessibleInterval<Unsigned128BitType> out) {
        LoopBuilder.setImages(out).forEachPixel(o -> o.setReal(1.0));
    }

    @Test
    public void testConvertUnsigned128BitTypeImage() {
        ArrayImg out = ArrayImgs.doubles((long[])new long[]{1L, 1L});
        ((DoubleType)out.firstElement()).set(0.0);
        ops.op("test.convert.image.Unsigned128BitType").output((Object)out).compute();
        double expected = 1.0;
        double actual = ((DoubleType)out.firstElement()).get();
        Assertions.assertEquals((double)expected, (double)actual);
    }

    public static void computeFloatType(RandomAccessibleInterval<FloatType> out) {
        LoopBuilder.setImages(out).forEachPixel(o -> o.setReal(1.0));
    }

    @Test
    public void testConvertFloatTypeImage() {
        ArrayImg out = ArrayImgs.doubles((long[])new long[]{1L, 1L});
        ((DoubleType)out.firstElement()).set(0.0);
        ops.op("test.convert.image.FloatType").output((Object)out).compute();
        double expected = 1.0;
        double actual = ((DoubleType)out.firstElement()).get();
        Assertions.assertEquals((double)expected, (double)actual);
    }

    public static void computeDoubleType(RandomAccessibleInterval<DoubleType> out) {
        LoopBuilder.setImages(out).forEachPixel(o -> o.setReal(1.0));
    }

    @Test
    public void testConvertDoubleTypeImage() {
        ArrayImg out = ArrayImgs.doubles((long[])new long[]{1L, 1L});
        ((DoubleType)out.firstElement()).set(0.0);
        ops.op("test.convert.image.DoubleType").output((Object)out).compute();
        double expected = 1.0;
        double actual = ((DoubleType)out.firstElement()).get();
        Assertions.assertEquals((double)expected, (double)actual);
    }
}

