/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.convert;

import java.math.BigInteger;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.complex.ComplexDoubleType;
import net.imglib2.type.numeric.complex.ComplexFloatType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.Unsigned128BitType;
import net.imglib2.type.numeric.integer.Unsigned12BitType;
import net.imglib2.type.numeric.integer.Unsigned2BitType;
import net.imglib2.type.numeric.integer.Unsigned4BitType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedLongType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.ops.image.convert.Types;

public class TestConvertType
extends AbstractOpTest {
    private final BigInteger p64 = new BigInteger("AEF234567ABCD123", 16);
    private final BigInteger n64 = new BigInteger("-1399890AB", 16);
    private final BigInteger beef = BigInteger.valueOf(48879L);
    private final BigInteger biZero = BigInteger.ZERO;
    private final BigInteger p128 = new BigInteger("2CAFE0321BEEF0717BABE0929DEAD0311", 16);
    private final BigInteger n128 = new BigInteger("-482301498A285BFD0982EE7DE02398BC9080459284CCDE90E9F0D00C043981210481AAADEF2", 16);

    @Test
    public void testBitToBit() {
        BitType b = new BitType(true);
        BitType result = (BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply();
        Assertions.assertEquals((Object)Types.bit((long)1L), (Object)result.get());
        b.set(false);
        Assertions.assertEquals((Object)Types.bit((long)0L), (Object)((BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply()).get());
    }

    @Test
    public void testUint2ToBit() {
        Unsigned2BitType b = new Unsigned2BitType(2L);
        BitType result = (BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply();
        Assertions.assertEquals((Object)Types.bit((long)2L), (Object)result.get());
        b.set(0L);
        Assertions.assertEquals((Object)Types.bit((long)0L), (Object)((BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply()).get());
    }

    @Test
    public void testUint4ToBit() {
        Unsigned4BitType b = new Unsigned4BitType(15L);
        BitType result = (BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply();
        Assertions.assertEquals((Object)Types.bit((long)15L), (Object)result.get());
        b.set(0L);
        Assertions.assertEquals((Object)Types.bit((long)0L), (Object)((BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply()).get());
    }

    @Test
    public void testInt8ToBit() {
        ByteType b = new ByteType(8);
        BitType result = (BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply();
        Assertions.assertEquals((Object)Types.bit((long)8L), (Object)result.get());
        b.set((byte)0);
        Assertions.assertEquals((Object)Types.bit((long)0L), (Object)((BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply()).get());
        b.set((byte)-12);
        Assertions.assertEquals((Object)Types.bit((long)-12L), (Object)((BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply()).get());
    }

    @Test
    public void testUint8ToBit() {
        UnsignedByteType b = new UnsignedByteType(100);
        BitType result = (BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply();
        Assertions.assertEquals((Object)Types.bit((long)100L), (Object)result.get());
        b.set(0);
        Assertions.assertEquals((Object)Types.bit((long)0L), (Object)((BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply()).get());
    }

    @Test
    public void testUint12ToBit() {
        Unsigned12BitType b = new Unsigned12BitType(212L);
        BitType result = (BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply();
        Assertions.assertEquals((Object)Types.bit((long)212L), (Object)result.get());
        b.set(0L);
        Assertions.assertEquals((Object)Types.bit((long)0L), (Object)((BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply()).get());
    }

    @Test
    public void testInt16ToBit() {
        ShortType b = new ShortType(52);
        BitType result = (BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply();
        Assertions.assertEquals((Object)Types.bit((long)52L), (Object)result.get());
        b.set((short)0);
        Assertions.assertEquals((Object)Types.bit((long)0L), (Object)((BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply()).get());
        b.set((short)-154);
        Assertions.assertEquals((Object)Types.bit((long)-154L), (Object)((BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply()).get());
    }

    @Test
    public void testUint16ToBit() {
        UnsignedShortType b = new UnsignedShortType(480);
        BitType result = (BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply();
        Assertions.assertEquals((Object)Types.bit((long)480L), (Object)result.get());
        b.set(0);
        Assertions.assertEquals((Object)Types.bit((long)0L), (Object)((BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply()).get());
    }

    @Test
    public void testInt32ToBit() {
        IntType b = new IntType(301);
        BitType result = (BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply();
        Assertions.assertEquals((Object)Types.bit((long)301L), (Object)result.get());
        b.set(0);
        Assertions.assertEquals((Object)Types.bit((long)0L), (Object)((BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply()).get());
        b.set(-89);
        Assertions.assertEquals((Object)Types.bit((long)-89L), (Object)((BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply()).get());
    }

    @Test
    public void testUint32ToBit() {
        UnsignedIntType b = new UnsignedIntType(20L);
        BitType result = (BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply();
        Assertions.assertEquals((Object)Types.bit((long)20L), (Object)result.get());
        b.set(0L);
        Assertions.assertEquals((Object)Types.bit((long)0L), (Object)((BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply()).get());
    }

    @Test
    public void testInt64ToBit() {
        LongType b = new LongType(891L);
        BitType result = (BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply();
        Assertions.assertEquals((Object)Types.bit((long)891L), (Object)result.get());
        b.set(0L);
        Assertions.assertEquals((Object)Types.bit((long)0L), (Object)((BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply()).get());
        b.set(-1024L);
        Assertions.assertEquals((Object)Types.bit((long)-1024L), (Object)((BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply()).get());
    }

    @Test
    public void testUint64ToBit() {
        UnsignedLongType b = new UnsignedLongType(1049L);
        BitType result = (BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply();
        Assertions.assertEquals((Object)Types.bit((long)1049L), (Object)result.get());
        b.set(0L);
        Assertions.assertEquals((Object)Types.bit((long)0L), (Object)((BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply()).get());
        b.set(this.p64);
        Assertions.assertEquals((Object)Types.bit((BigInteger)this.p64), (Object)((BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply()).get());
    }

    @Test
    public void testUint128ToBit() {
        Unsigned128BitType b = new Unsigned128BitType(this.beef);
        BitType result = (BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply();
        Assertions.assertEquals((Object)Types.bit((BigInteger)this.beef), (Object)result.get());
        b.set(this.biZero);
        Assertions.assertEquals((Object)Types.bit((BigInteger)this.biZero), (Object)((BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply()).get());
        b.set(this.p128);
        Assertions.assertEquals((Object)Types.bit((BigInteger)this.p128), (Object)((BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply()).get());
    }

    @Test
    public void testFloat32ToBit() {
        FloatType b = new FloatType(123453.125f);
        BitType result = (BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply();
        Assertions.assertEquals((Object)Types.bit((double)123453.125), (Object)result.get());
        b.set(0.0f);
        Assertions.assertEquals((Object)Types.bit((double)0.0), (Object)((BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply()).get());
        b.set(-2.5234854E12f);
        Assertions.assertEquals((Object)Types.bit((double)-2.523485437952E12), (Object)((BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply()).get());
    }

    @Test
    public void testCfloat32ToBit() {
        ComplexFloatType b = new ComplexFloatType(5839.25f, 120.0f);
        BitType result = (BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply();
        Assertions.assertEquals((Object)Types.bit((double)5839.25), (Object)result.get());
        b.set(0.0f, 0.0f);
        Assertions.assertEquals((Object)Types.bit((double)0.0), (Object)((BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply()).get());
        b.set(-4.25f, -123.0625f);
        Assertions.assertEquals((Object)Types.bit((double)-4.25), (Object)((BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply()).get());
    }

    @Test
    public void testFloat64ToBit() {
        DoubleType b = new DoubleType(4098.0);
        BitType result = (BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply();
        Assertions.assertEquals((Object)Types.bit((double)4098.0), (Object)result.get());
        b.set(0.0);
        Assertions.assertEquals((Object)Types.bit((double)0.0), (Object)((BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply()).get());
        b.set(-10948.015625);
        Assertions.assertEquals((Object)Types.bit((double)-10948.015625), (Object)((BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply()).get());
        b.set(1.0000152587890626E20);
        Assertions.assertEquals((Object)Types.bit((double)1.0000152587890626E20), (Object)((BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply()).get());
    }

    @Test
    public void testCfloat64ToBit() {
        ComplexDoubleType b = new ComplexDoubleType(9087.0, 879542.125);
        BitType result = (BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply();
        Assertions.assertEquals((Object)Types.bit((double)9087.0), (Object)result.get());
        b.set(0.0, 0.0);
        Assertions.assertEquals((Object)Types.bit((double)0.0), (Object)((BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply()).get());
        b.set(-234.25, -9.0);
        Assertions.assertEquals((Object)Types.bit((double)-234.25), (Object)((BitType)ops.op("convert.bit").input((Object)b).outType(BitType.class).apply()).get());
    }

    @Test
    public void testBitToUint2() {
        BitType b = new BitType(true);
        Unsigned2BitType result = (Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply();
        Assertions.assertEquals((long)Types.uint2((long)1L), (long)result.get());
        b.set(false);
        Assertions.assertEquals((long)Types.uint2((long)0L), (long)((Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply()).get());
    }

    @Test
    public void testUint2ToUint2() {
        Unsigned2BitType b = new Unsigned2BitType(2L);
        Unsigned2BitType result = (Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply();
        Assertions.assertEquals((long)Types.uint2((long)2L), (long)result.get());
        b.set(0L);
        Assertions.assertEquals((long)Types.uint2((long)0L), (long)((Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply()).get());
    }

    @Test
    public void testUint4ToUint2() {
        Unsigned4BitType b = new Unsigned4BitType(15L);
        Unsigned2BitType result = (Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply();
        Assertions.assertEquals((long)Types.uint2((long)15L), (long)result.get());
        b.set(0L);
        Assertions.assertEquals((long)Types.uint2((long)0L), (long)((Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply()).get());
    }

    @Test
    public void testInt8ToUint2() {
        ByteType b = new ByteType(8);
        Unsigned2BitType result = (Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply();
        Assertions.assertEquals((long)Types.uint2((long)8L), (long)result.get());
        b.set((byte)0);
        Assertions.assertEquals((long)Types.uint2((long)0L), (long)((Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply()).get());
        b.set((byte)-12);
        Assertions.assertEquals((long)Types.uint2((long)-12L), (long)((Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply()).get());
    }

    @Test
    public void testUint8ToUint2() {
        UnsignedByteType b = new UnsignedByteType(100);
        Unsigned2BitType result = (Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply();
        Assertions.assertEquals((long)Types.uint2((long)100L), (long)result.get());
        b.set(0);
        Assertions.assertEquals((long)Types.uint2((long)0L), (long)((Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply()).get());
    }

    @Test
    public void testUint12ToUint2() {
        Unsigned12BitType b = new Unsigned12BitType(212L);
        Unsigned2BitType result = (Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply();
        Assertions.assertEquals((long)Types.uint2((long)212L), (long)result.get());
        b.set(0L);
        Assertions.assertEquals((long)Types.uint2((long)0L), (long)((Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply()).get());
    }

    @Test
    public void testInt16ToUint2() {
        ShortType b = new ShortType(52);
        Unsigned2BitType result = (Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply();
        Assertions.assertEquals((long)Types.uint2((long)52L), (long)result.get());
        b.set((short)0);
        Assertions.assertEquals((long)Types.uint2((long)0L), (long)((Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply()).get());
        b.set((short)-154);
        Assertions.assertEquals((long)Types.uint2((long)-154L), (long)((Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply()).get());
    }

    @Test
    public void testUint16ToUint2() {
        UnsignedShortType b = new UnsignedShortType(480);
        Unsigned2BitType result = (Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply();
        Assertions.assertEquals((long)Types.uint2((long)480L), (long)result.get());
        b.set(0);
        Assertions.assertEquals((long)Types.uint2((long)0L), (long)((Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply()).get());
    }

    @Test
    public void testInt32ToUint2() {
        IntType b = new IntType(301);
        Unsigned2BitType result = (Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply();
        Assertions.assertEquals((long)Types.uint2((long)301L), (long)result.get());
        b.set(0);
        Assertions.assertEquals((long)Types.uint2((long)0L), (long)((Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply()).get());
        b.set(-89);
        Assertions.assertEquals((long)Types.uint2((long)-89L), (long)((Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply()).get());
    }

    @Test
    public void testUint32ToUint2() {
        UnsignedIntType b = new UnsignedIntType(20L);
        Unsigned2BitType result = (Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply();
        Assertions.assertEquals((long)Types.uint2((long)20L), (long)result.get());
        b.set(0L);
        Assertions.assertEquals((long)Types.uint2((long)0L), (long)((Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply()).get());
    }

    @Test
    public void testInt64ToUint2() {
        LongType b = new LongType(891L);
        Unsigned2BitType result = (Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply();
        Assertions.assertEquals((long)Types.uint2((long)891L), (long)result.get());
        b.set(0L);
        Assertions.assertEquals((long)Types.uint2((long)0L), (long)((Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply()).get());
        b.set(-1024L);
        Assertions.assertEquals((long)Types.uint2((long)-1024L), (long)((Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply()).get());
    }

    @Test
    public void testUint64ToUint2() {
        UnsignedLongType b = new UnsignedLongType(1049L);
        Unsigned2BitType result = (Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply();
        Assertions.assertEquals((long)Types.uint2((long)1049L), (long)result.get());
        b.set(0L);
        Assertions.assertEquals((long)Types.uint2((long)0L), (long)((Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply()).get());
        b.set(this.p64);
        Assertions.assertEquals((long)Types.uint2((Number)this.p64), (long)((Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply()).get());
    }

    @Test
    public void testUint128ToUint2() {
        Unsigned128BitType b = new Unsigned128BitType(this.beef);
        Unsigned2BitType result = (Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply();
        Assertions.assertEquals((long)Types.uint2((Number)this.beef), (long)result.get());
        b.set(this.biZero);
        Assertions.assertEquals((long)Types.uint2((Number)this.biZero), (long)((Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply()).get());
        b.set(this.p128);
        Assertions.assertEquals((long)Types.uint2((Number)this.p128), (long)((Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply()).get());
    }

    @Test
    public void testFloat32ToUint2() {
        FloatType b = new FloatType(123453.125f);
        Unsigned2BitType result = (Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply();
        Assertions.assertEquals((long)Types.uint2((double)123453.125), (long)result.get());
        b.set(0.0f);
        Assertions.assertEquals((long)Types.uint2((double)0.0), (long)((Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply()).get());
        b.set(-2.5234854E12f);
        Assertions.assertEquals((long)Types.uint2((double)-2.523485437952E12), (long)((Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply()).get());
    }

    @Test
    public void testCfloat32ToUint2() {
        ComplexFloatType b = new ComplexFloatType(5839.25f, 120.0f);
        Unsigned2BitType result = (Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply();
        Assertions.assertEquals((long)Types.uint2((double)5839.25), (long)result.get());
        b.set(0.0f, 0.0f);
        Assertions.assertEquals((long)Types.uint2((double)0.0), (long)((Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply()).get());
        b.set(-4.25f, -123.0625f);
        Assertions.assertEquals((long)Types.uint2((double)-4.25), (long)((Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply()).get());
    }

    @Test
    public void testFloat64ToUint2() {
        DoubleType b = new DoubleType(4098.0);
        Unsigned2BitType result = (Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply();
        Assertions.assertEquals((long)Types.uint2((double)4098.0), (long)result.get());
        b.set(0.0);
        Assertions.assertEquals((long)Types.uint2((double)0.0), (long)((Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply()).get());
        b.set(-10948.015625);
        Assertions.assertEquals((long)Types.uint2((double)-10948.015625), (long)((Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply()).get());
        b.set(1.0000152587890626E20);
        Assertions.assertEquals((long)Types.uint2((double)1.0000152587890626E20), (long)((Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply()).get());
    }

    @Test
    public void testCfloat64ToUint2() {
        ComplexDoubleType b = new ComplexDoubleType(9087.0, 879542.125);
        Unsigned2BitType result = (Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply();
        Assertions.assertEquals((long)Types.uint2((double)9087.0), (long)result.get());
        b.set(0.0, 0.0);
        Assertions.assertEquals((long)Types.uint2((double)0.0), (long)((Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply()).get());
        b.set(-234.25, -9.0);
        Assertions.assertEquals((long)Types.uint2((double)-234.25), (long)((Unsigned2BitType)ops.op("convert.uint2").input((Object)b).outType(Unsigned2BitType.class).apply()).get());
    }

    @Test
    public void testBitToUint4() {
        BitType b = new BitType(true);
        Unsigned4BitType result = (Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply();
        Assertions.assertEquals((long)Types.uint4((long)1L), (long)result.get());
        b.set(false);
        Assertions.assertEquals((long)Types.uint4((long)0L), (long)((Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply()).get());
    }

    @Test
    public void testUint2ToUint4() {
        Unsigned2BitType b = new Unsigned2BitType(2L);
        Unsigned4BitType result = (Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply();
        Assertions.assertEquals((long)Types.uint4((long)2L), (long)result.get());
        b.set(0L);
        Assertions.assertEquals((long)Types.uint4((long)0L), (long)((Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply()).get());
    }

    @Test
    public void testUint4ToUint4() {
        Unsigned4BitType b = new Unsigned4BitType(15L);
        Unsigned4BitType result = (Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply();
        Assertions.assertEquals((long)Types.uint4((long)15L), (long)result.get());
        b.set(0L);
        Assertions.assertEquals((long)Types.uint4((long)0L), (long)((Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply()).get());
    }

    @Test
    public void testInt8ToUint4() {
        ByteType b = new ByteType(8);
        Unsigned4BitType result = (Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply();
        Assertions.assertEquals((long)Types.uint4((long)8L), (long)result.get());
        b.set((byte)0);
        Assertions.assertEquals((long)Types.uint4((long)0L), (long)((Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply()).get());
        b.set((byte)-12);
        Assertions.assertEquals((long)Types.uint4((long)-12L), (long)((Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply()).get());
    }

    @Test
    public void testUint8ToUint4() {
        UnsignedByteType b = new UnsignedByteType(100);
        Unsigned4BitType result = (Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply();
        Assertions.assertEquals((long)Types.uint4((long)100L), (long)result.get());
        b.set(0);
        Assertions.assertEquals((long)Types.uint4((long)0L), (long)((Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply()).get());
    }

    @Test
    public void testUint12ToUint4() {
        Unsigned12BitType b = new Unsigned12BitType(212L);
        Unsigned4BitType result = (Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply();
        Assertions.assertEquals((long)Types.uint4((long)212L), (long)result.get());
        b.set(0L);
        Assertions.assertEquals((long)Types.uint4((long)0L), (long)((Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply()).get());
    }

    @Test
    public void testInt16ToUint4() {
        ShortType b = new ShortType(52);
        Unsigned4BitType result = (Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply();
        Assertions.assertEquals((long)Types.uint4((long)52L), (long)result.get());
        b.set((short)0);
        Assertions.assertEquals((long)Types.uint4((long)0L), (long)((Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply()).get());
        b.set((short)-154);
        Assertions.assertEquals((long)Types.uint4((long)-154L), (long)((Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply()).get());
    }

    @Test
    public void testUint16ToUint4() {
        UnsignedShortType b = new UnsignedShortType(480);
        Unsigned4BitType result = (Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply();
        Assertions.assertEquals((long)Types.uint4((long)480L), (long)result.get());
        b.set(0);
        Assertions.assertEquals((long)Types.uint4((long)0L), (long)((Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply()).get());
    }

    @Test
    public void testInt32ToUint4() {
        IntType b = new IntType(301);
        Unsigned4BitType result = (Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply();
        Assertions.assertEquals((long)Types.uint4((long)301L), (long)result.get());
        b.set(0);
        Assertions.assertEquals((long)Types.uint4((long)0L), (long)((Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply()).get());
        b.set(-89);
        Assertions.assertEquals((long)Types.uint4((long)-89L), (long)((Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply()).get());
    }

    @Test
    public void testUint32ToUint4() {
        UnsignedIntType b = new UnsignedIntType(20L);
        Unsigned4BitType result = (Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply();
        Assertions.assertEquals((long)Types.uint4((long)20L), (long)result.get());
        b.set(0L);
        Assertions.assertEquals((long)Types.uint4((long)0L), (long)((Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply()).get());
    }

    @Test
    public void testInt64ToUint4() {
        LongType b = new LongType(891L);
        Unsigned4BitType result = (Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply();
        Assertions.assertEquals((long)Types.uint4((long)891L), (long)result.get());
        b.set(0L);
        Assertions.assertEquals((long)Types.uint4((long)0L), (long)((Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply()).get());
        b.set(-1024L);
        Assertions.assertEquals((long)Types.uint4((long)-1024L), (long)((Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply()).get());
    }

    @Test
    public void testUint64ToUint4() {
        UnsignedLongType b = new UnsignedLongType(1049L);
        Unsigned4BitType result = (Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply();
        Assertions.assertEquals((long)Types.uint4((long)1049L), (long)result.get());
        b.set(0L);
        Assertions.assertEquals((long)Types.uint4((long)0L), (long)((Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply()).get());
        b.set(this.p64);
        Assertions.assertEquals((long)Types.uint4((Number)this.p64), (long)((Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply()).get());
    }

    @Test
    public void testUint128ToUint4() {
        Unsigned128BitType b = new Unsigned128BitType(this.beef);
        Unsigned4BitType result = (Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply();
        Assertions.assertEquals((long)Types.uint4((Number)this.beef), (long)result.get());
        b.set(this.biZero);
        Assertions.assertEquals((long)Types.uint4((Number)this.biZero), (long)((Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply()).get());
        b.set(this.p128);
        Assertions.assertEquals((long)Types.uint4((Number)this.p128), (long)((Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply()).get());
    }

    @Test
    public void testFloat32ToUint4() {
        FloatType b = new FloatType(123453.125f);
        Unsigned4BitType result = (Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply();
        Assertions.assertEquals((long)Types.uint4((double)123453.125), (long)result.get());
        b.set(0.0f);
        Assertions.assertEquals((long)Types.uint4((double)0.0), (long)((Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply()).get());
        b.set(-2.5234854E12f);
        Assertions.assertEquals((long)Types.uint4((double)-2.523485437952E12), (long)((Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply()).get());
    }

    @Test
    public void testCfloat32ToUint4() {
        ComplexFloatType b = new ComplexFloatType(5839.25f, 120.0f);
        Unsigned4BitType result = (Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply();
        Assertions.assertEquals((long)Types.uint4((double)5839.25), (long)result.get());
        b.set(0.0f, 0.0f);
        Assertions.assertEquals((long)Types.uint4((double)0.0), (long)((Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply()).get());
        b.set(-4.25f, -123.0625f);
        Assertions.assertEquals((long)Types.uint4((double)-4.25), (long)((Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply()).get());
    }

    @Test
    public void testFloat64ToUint4() {
        DoubleType b = new DoubleType(4098.0);
        Unsigned4BitType result = (Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply();
        Assertions.assertEquals((long)Types.uint4((double)4098.0), (long)result.get());
        b.set(0.0);
        Assertions.assertEquals((long)Types.uint4((double)0.0), (long)((Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply()).get());
        b.set(-10948.015625);
        Assertions.assertEquals((long)Types.uint4((double)-10948.015625), (long)((Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply()).get());
        b.set(1.0000152587890626E20);
        Assertions.assertEquals((long)Types.uint4((double)1.0000152587890626E20), (long)((Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply()).get());
    }

    @Test
    public void testCfloat64ToUint4() {
        ComplexDoubleType b = new ComplexDoubleType(9087.0, 879542.125);
        Unsigned4BitType result = (Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply();
        Assertions.assertEquals((long)Types.uint4((double)9087.0), (long)result.get());
        b.set(0.0, 0.0);
        Assertions.assertEquals((long)Types.uint4((double)0.0), (long)((Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply()).get());
        b.set(-234.25, -9.0);
        Assertions.assertEquals((long)Types.uint4((double)-234.25), (long)((Unsigned4BitType)ops.op("convert.uint4").input((Object)b).outType(Unsigned4BitType.class).apply()).get());
    }

    @Test
    public void testBitToInt8() {
        BitType b = new BitType(true);
        ByteType result = (ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply();
        Assertions.assertEquals((byte)Types.int8((long)1L), (byte)result.get());
        b.set(false);
        Assertions.assertEquals((byte)Types.int8((long)0L), (byte)((ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply()).get());
    }

    @Test
    public void testUint2ToInt8() {
        Unsigned2BitType b = new Unsigned2BitType(2L);
        ByteType result = (ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply();
        Assertions.assertEquals((byte)Types.int8((long)2L), (byte)result.get());
        b.set(0L);
        Assertions.assertEquals((byte)Types.int8((long)0L), (byte)((ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply()).get());
    }

    @Test
    public void testUint4ToInt8() {
        Unsigned4BitType b = new Unsigned4BitType(15L);
        ByteType result = (ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply();
        Assertions.assertEquals((byte)Types.int8((long)15L), (byte)result.get());
        b.set(0L);
        Assertions.assertEquals((byte)Types.int8((long)0L), (byte)((ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply()).get());
    }

    @Test
    public void testInt8ToInt8() {
        ByteType b = new ByteType(8);
        ByteType result = (ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply();
        Assertions.assertEquals((byte)Types.int8((long)8L), (byte)result.get());
        b.set((byte)0);
        Assertions.assertEquals((byte)Types.int8((long)0L), (byte)((ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply()).get());
        b.set((byte)-12);
        Assertions.assertEquals((byte)Types.int8((long)-12L), (byte)((ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply()).get());
    }

    @Test
    public void testUint8ToInt8() {
        UnsignedByteType b = new UnsignedByteType(100);
        ByteType result = (ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply();
        Assertions.assertEquals((byte)Types.int8((long)100L), (byte)result.get());
        b.set(0);
        Assertions.assertEquals((byte)Types.int8((long)0L), (byte)((ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply()).get());
    }

    @Test
    public void testUint12ToInt8() {
        Unsigned12BitType b = new Unsigned12BitType(212L);
        ByteType result = (ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply();
        Assertions.assertEquals((byte)Types.int8((long)212L), (byte)result.get());
        b.set(0L);
        Assertions.assertEquals((byte)Types.int8((long)0L), (byte)((ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply()).get());
    }

    @Test
    public void testInt16ToInt8() {
        ShortType b = new ShortType(52);
        ByteType result = (ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply();
        Assertions.assertEquals((byte)Types.int8((long)52L), (byte)result.get());
        b.set((short)0);
        Assertions.assertEquals((byte)Types.int8((long)0L), (byte)((ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply()).get());
        b.set((short)-154);
        Assertions.assertEquals((byte)Types.int8((long)-154L), (byte)((ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply()).get());
    }

    @Test
    public void testUint16ToInt8() {
        UnsignedShortType b = new UnsignedShortType(480);
        ByteType result = (ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply();
        Assertions.assertEquals((byte)Types.int8((long)480L), (byte)result.get());
        b.set(0);
        Assertions.assertEquals((byte)Types.int8((long)0L), (byte)((ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply()).get());
    }

    @Test
    public void testInt32ToInt8() {
        IntType b = new IntType(301);
        ByteType result = (ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply();
        Assertions.assertEquals((byte)Types.int8((long)301L), (byte)result.get());
        b.set(0);
        Assertions.assertEquals((byte)Types.int8((long)0L), (byte)((ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply()).get());
        b.set(-89);
        Assertions.assertEquals((byte)Types.int8((long)-89L), (byte)((ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply()).get());
    }

    @Test
    public void testUint32ToInt8() {
        UnsignedIntType b = new UnsignedIntType(20L);
        ByteType result = (ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply();
        Assertions.assertEquals((byte)Types.int8((long)20L), (byte)result.get());
        b.set(0L);
        Assertions.assertEquals((byte)Types.int8((long)0L), (byte)((ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply()).get());
    }

    @Test
    public void testInt64ToInt8() {
        LongType b = new LongType(891L);
        ByteType result = (ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply();
        Assertions.assertEquals((byte)Types.int8((long)891L), (byte)result.get());
        b.set(0L);
        Assertions.assertEquals((byte)Types.int8((long)0L), (byte)((ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply()).get());
        b.set(-1024L);
        Assertions.assertEquals((byte)Types.int8((long)-1024L), (byte)((ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply()).get());
    }

    @Test
    public void testUint64ToInt8() {
        UnsignedLongType b = new UnsignedLongType(1049L);
        ByteType result = (ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply();
        Assertions.assertEquals((byte)Types.int8((long)1049L), (byte)result.get());
        b.set(0L);
        Assertions.assertEquals((byte)Types.int8((long)0L), (byte)((ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply()).get());
        b.set(this.p64);
        Assertions.assertEquals((byte)Types.int8((BigInteger)this.p64), (byte)((ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply()).get());
    }

    @Test
    public void testUint128ToInt8() {
        Unsigned128BitType b = new Unsigned128BitType(this.beef);
        ByteType result = (ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply();
        Assertions.assertEquals((byte)Types.int8((BigInteger)this.beef), (byte)result.get());
        b.set(this.biZero);
        Assertions.assertEquals((byte)Types.int8((BigInteger)this.biZero), (byte)((ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply()).get());
        b.set(this.p128);
        Assertions.assertEquals((byte)Types.int8((BigInteger)this.p128), (byte)((ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply()).get());
    }

    @Test
    public void testFloat32ToInt8() {
        FloatType b = new FloatType(123453.125f);
        ByteType result = (ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply();
        Assertions.assertEquals((byte)Types.int8((double)123453.125), (byte)result.get());
        b.set(0.0f);
        Assertions.assertEquals((byte)Types.int8((double)0.0), (byte)((ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply()).get());
        b.set(-2.5234854E12f);
        Assertions.assertEquals((byte)Types.int8((double)-2.523485437952E12), (byte)((ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply()).get());
    }

    @Test
    public void testCfloat32ToInt8() {
        ComplexFloatType b = new ComplexFloatType(5839.25f, 120.0f);
        ByteType result = (ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply();
        Assertions.assertEquals((byte)Types.int8((double)5839.25), (byte)result.get());
        b.set(0.0f, 0.0f);
        Assertions.assertEquals((byte)Types.int8((double)0.0), (byte)((ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply()).get());
        b.set(-4.25f, -123.0625f);
        Assertions.assertEquals((byte)Types.int8((double)-4.25), (byte)((ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply()).get());
    }

    @Test
    public void testFloat64ToInt8() {
        DoubleType b = new DoubleType(4098.0);
        ByteType result = (ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply();
        Assertions.assertEquals((byte)Types.int8((double)4098.0), (byte)result.get());
        b.set(0.0);
        Assertions.assertEquals((byte)Types.int8((double)0.0), (byte)((ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply()).get());
        b.set(-10948.015625);
        Assertions.assertEquals((byte)Types.int8((double)-10948.015625), (byte)((ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply()).get());
        b.set(1.0000152587890626E20);
        Assertions.assertEquals((byte)Types.int8((double)1.0000152587890626E20), (byte)((ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply()).get());
    }

    @Test
    public void testCfloat64ToInt8() {
        ComplexDoubleType b = new ComplexDoubleType(9087.0, 879542.125);
        ByteType result = (ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply();
        Assertions.assertEquals((byte)Types.int8((double)9087.0), (byte)result.get());
        b.set(0.0, 0.0);
        Assertions.assertEquals((byte)Types.int8((double)0.0), (byte)((ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply()).get());
        b.set(-234.25, -9.0);
        Assertions.assertEquals((byte)Types.int8((double)-234.25), (byte)((ByteType)ops.op("convert.int8").input((Object)b).outType(ByteType.class).apply()).get());
    }

    @Test
    public void testBitToUint8() {
        BitType b = new BitType(true);
        UnsignedByteType result = (UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply();
        Assertions.assertEquals((int)Types.uint8((long)1L), (int)result.get());
        b.set(false);
        Assertions.assertEquals((int)Types.uint8((long)0L), (int)((UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply()).get());
    }

    @Test
    public void testUint2ToUint8() {
        Unsigned2BitType b = new Unsigned2BitType(2L);
        UnsignedByteType result = (UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply();
        Assertions.assertEquals((int)Types.uint8((long)2L), (int)result.get());
        b.set(0L);
        Assertions.assertEquals((int)Types.uint8((long)0L), (int)((UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply()).get());
    }

    @Test
    public void testUint4ToUint8() {
        Unsigned4BitType b = new Unsigned4BitType(15L);
        UnsignedByteType result = (UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply();
        Assertions.assertEquals((int)Types.uint8((long)15L), (int)result.get());
        b.set(0L);
        Assertions.assertEquals((int)Types.uint8((long)0L), (int)((UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply()).get());
    }

    @Test
    public void testInt8ToUint8() {
        ByteType b = new ByteType(8);
        UnsignedByteType result = (UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply();
        Assertions.assertEquals((int)Types.uint8((long)8L), (int)result.get());
        b.set((byte)0);
        Assertions.assertEquals((int)Types.uint8((long)0L), (int)((UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply()).get());
        b.set((byte)-12);
        Assertions.assertEquals((int)Types.uint8((long)-12L), (int)((UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply()).get());
    }

    @Test
    public void testUint8ToUint8() {
        UnsignedByteType b = new UnsignedByteType(100);
        UnsignedByteType result = (UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply();
        Assertions.assertEquals((int)Types.uint8((long)100L), (int)result.get());
        b.set(0);
        Assertions.assertEquals((int)Types.uint8((long)0L), (int)((UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply()).get());
    }

    @Test
    public void testUint12ToUint8() {
        Unsigned12BitType b = new Unsigned12BitType(212L);
        UnsignedByteType result = (UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply();
        Assertions.assertEquals((int)Types.uint8((long)212L), (int)result.get());
        b.set(0L);
        Assertions.assertEquals((int)Types.uint8((long)0L), (int)((UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply()).get());
    }

    @Test
    public void testInt16ToUint8() {
        ShortType b = new ShortType(52);
        UnsignedByteType result = (UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply();
        Assertions.assertEquals((int)Types.uint8((long)52L), (int)result.get());
        b.set((short)0);
        Assertions.assertEquals((int)Types.uint8((long)0L), (int)((UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply()).get());
        b.set((short)-154);
        Assertions.assertEquals((int)Types.uint8((long)-154L), (int)((UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply()).get());
    }

    @Test
    public void testUint16ToUint8() {
        UnsignedShortType b = new UnsignedShortType(480);
        UnsignedByteType result = (UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply();
        Assertions.assertEquals((int)Types.uint8((long)480L), (int)result.get());
        b.set(0);
        Assertions.assertEquals((int)Types.uint8((long)0L), (int)((UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply()).get());
    }

    @Test
    public void testInt32ToUint8() {
        IntType b = new IntType(301);
        UnsignedByteType result = (UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply();
        Assertions.assertEquals((int)Types.uint8((long)301L), (int)result.get());
        b.set(0);
        Assertions.assertEquals((int)Types.uint8((long)0L), (int)((UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply()).get());
        b.set(-89);
        Assertions.assertEquals((int)Types.uint8((long)-89L), (int)((UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply()).get());
    }

    @Test
    public void testUint32ToUint8() {
        UnsignedIntType b = new UnsignedIntType(20L);
        UnsignedByteType result = (UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply();
        Assertions.assertEquals((int)Types.uint8((long)20L), (int)result.get());
        b.set(0L);
        Assertions.assertEquals((int)Types.uint8((long)0L), (int)((UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply()).get());
    }

    @Test
    public void testInt64ToUint8() {
        LongType b = new LongType(891L);
        UnsignedByteType result = (UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply();
        Assertions.assertEquals((int)Types.uint8((long)891L), (int)result.get());
        b.set(0L);
        Assertions.assertEquals((int)Types.uint8((long)0L), (int)((UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply()).get());
        b.set(-1024L);
        Assertions.assertEquals((int)Types.uint8((long)-1024L), (int)((UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply()).get());
    }

    @Test
    public void testUint64ToUint8() {
        UnsignedLongType b = new UnsignedLongType(1049L);
        UnsignedByteType result = (UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply();
        Assertions.assertEquals((int)Types.uint8((long)1049L), (int)result.get());
        b.set(0L);
        Assertions.assertEquals((int)Types.uint8((long)0L), (int)((UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply()).get());
        b.set(this.p64);
        Assertions.assertEquals((int)Types.uint8((Number)this.p64), (int)((UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply()).get());
    }

    @Test
    public void testUint128ToUint8() {
        Unsigned128BitType b = new Unsigned128BitType(this.beef);
        UnsignedByteType result = (UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply();
        Assertions.assertEquals((int)Types.uint8((Number)this.beef), (int)result.get());
        b.set(this.biZero);
        Assertions.assertEquals((int)Types.uint8((Number)this.biZero), (int)((UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply()).get());
        b.set(this.p128);
        Assertions.assertEquals((int)Types.uint8((Number)this.p128), (int)((UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply()).get());
    }

    @Test
    public void testFloat32ToUint8() {
        FloatType b = new FloatType(123453.125f);
        UnsignedByteType result = (UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply();
        Assertions.assertEquals((int)Types.uint8((double)123453.125), (int)result.get());
        b.set(0.0f);
        Assertions.assertEquals((int)Types.uint8((double)0.0), (int)((UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply()).get());
        b.set(-2.5234854E12f);
        Assertions.assertEquals((int)Types.uint8((double)-2.523485437952E12), (int)((UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply()).get());
    }

    @Test
    public void testCfloat32ToUint8() {
        ComplexFloatType b = new ComplexFloatType(5839.25f, 120.0f);
        UnsignedByteType result = (UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply();
        Assertions.assertEquals((int)Types.uint8((double)5839.25), (int)result.get());
        b.set(0.0f, 0.0f);
        Assertions.assertEquals((int)Types.uint8((double)0.0), (int)((UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply()).get());
        b.set(-4.25f, -123.0625f);
        Assertions.assertEquals((int)Types.uint8((double)-4.25), (int)((UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply()).get());
    }

    @Test
    public void testFloat64ToUint8() {
        DoubleType b = new DoubleType(4098.0);
        UnsignedByteType result = (UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply();
        Assertions.assertEquals((int)Types.uint8((double)4098.0), (int)result.get());
        b.set(0.0);
        Assertions.assertEquals((int)Types.uint8((double)0.0), (int)((UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply()).get());
        b.set(-10948.015625);
        Assertions.assertEquals((int)Types.uint8((double)-10948.015625), (int)((UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply()).get());
        b.set(1.0000152587890626E20);
        Assertions.assertEquals((int)Types.uint8((double)1.0000152587890626E20), (int)((UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply()).get());
    }

    @Test
    public void testCfloat64ToUint8() {
        ComplexDoubleType b = new ComplexDoubleType(9087.0, 879542.125);
        UnsignedByteType result = (UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply();
        Assertions.assertEquals((int)Types.uint8((double)9087.0), (int)result.get());
        b.set(0.0, 0.0);
        Assertions.assertEquals((int)Types.uint8((double)0.0), (int)((UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply()).get());
        b.set(-234.25, -9.0);
        Assertions.assertEquals((int)Types.uint8((double)-234.25), (int)((UnsignedByteType)ops.op("convert.uint8").input((Object)b).outType(UnsignedByteType.class).apply()).get());
    }

    @Test
    public void testBitToUint12() {
        BitType b = new BitType(true);
        Unsigned12BitType result = (Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply();
        Assertions.assertEquals((long)Types.uint12((long)1L), (long)result.get());
        b.set(false);
        Assertions.assertEquals((long)Types.uint12((long)0L), (long)((Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply()).get());
    }

    @Test
    public void testUint2ToUint12() {
        Unsigned2BitType b = new Unsigned2BitType(2L);
        Unsigned12BitType result = (Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply();
        Assertions.assertEquals((long)Types.uint12((long)2L), (long)result.get());
        b.set(0L);
        Assertions.assertEquals((long)Types.uint12((long)0L), (long)((Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply()).get());
    }

    @Test
    public void testUint4ToUint12() {
        Unsigned4BitType b = new Unsigned4BitType(15L);
        Unsigned12BitType result = (Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply();
        Assertions.assertEquals((long)Types.uint12((long)15L), (long)result.get());
        b.set(0L);
        Assertions.assertEquals((long)Types.uint12((long)0L), (long)((Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply()).get());
    }

    @Test
    public void testInt8ToUint12() {
        ByteType b = new ByteType(8);
        Unsigned12BitType result = (Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply();
        Assertions.assertEquals((long)Types.uint12((long)8L), (long)result.get());
        b.set((byte)0);
        Assertions.assertEquals((long)Types.uint12((long)0L), (long)((Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply()).get());
        b.set((byte)-12);
        Assertions.assertEquals((long)Types.uint12((long)-12L), (long)((Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply()).get());
    }

    @Test
    public void testUint8ToUint12() {
        UnsignedByteType b = new UnsignedByteType(100);
        Unsigned12BitType result = (Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply();
        Assertions.assertEquals((long)Types.uint12((long)100L), (long)result.get());
        b.set(0);
        Assertions.assertEquals((long)Types.uint12((long)0L), (long)((Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply()).get());
    }

    @Test
    public void testUint12ToUint12() {
        Unsigned12BitType b = new Unsigned12BitType(212L);
        Unsigned12BitType result = (Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply();
        Assertions.assertEquals((long)Types.uint12((long)212L), (long)result.get());
        b.set(0L);
        Assertions.assertEquals((long)Types.uint12((long)0L), (long)((Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply()).get());
    }

    @Test
    public void testInt16ToUint12() {
        ShortType b = new ShortType(52);
        Unsigned12BitType result = (Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply();
        Assertions.assertEquals((long)Types.uint12((long)52L), (long)result.get());
        b.set((short)0);
        Assertions.assertEquals((long)Types.uint12((long)0L), (long)((Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply()).get());
        b.set((short)-154);
        Assertions.assertEquals((long)Types.uint12((long)-154L), (long)((Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply()).get());
    }

    @Test
    public void testUint16ToUint12() {
        UnsignedShortType b = new UnsignedShortType(480);
        Unsigned12BitType result = (Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply();
        Assertions.assertEquals((long)Types.uint12((long)480L), (long)result.get());
        b.set(0);
        Assertions.assertEquals((long)Types.uint12((long)0L), (long)((Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply()).get());
    }

    @Test
    public void testInt32ToUint12() {
        IntType b = new IntType(301);
        Unsigned12BitType result = (Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply();
        Assertions.assertEquals((long)Types.uint12((long)301L), (long)result.get());
        b.set(0);
        Assertions.assertEquals((long)Types.uint12((long)0L), (long)((Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply()).get());
        b.set(-89);
        Assertions.assertEquals((long)Types.uint12((long)-89L), (long)((Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply()).get());
    }

    @Test
    public void testUint32ToUint12() {
        UnsignedIntType b = new UnsignedIntType(20L);
        Unsigned12BitType result = (Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply();
        Assertions.assertEquals((long)Types.uint12((long)20L), (long)result.get());
        b.set(0L);
        Assertions.assertEquals((long)Types.uint12((long)0L), (long)((Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply()).get());
    }

    @Test
    public void testInt64ToUint12() {
        LongType b = new LongType(891L);
        Unsigned12BitType result = (Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply();
        Assertions.assertEquals((long)Types.uint12((long)891L), (long)result.get());
        b.set(0L);
        Assertions.assertEquals((long)Types.uint12((long)0L), (long)((Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply()).get());
        b.set(-1024L);
        Assertions.assertEquals((long)Types.uint12((long)-1024L), (long)((Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply()).get());
    }

    @Test
    public void testUint64ToUint12() {
        UnsignedLongType b = new UnsignedLongType(1049L);
        Unsigned12BitType result = (Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply();
        Assertions.assertEquals((long)Types.uint12((long)1049L), (long)result.get());
        b.set(0L);
        Assertions.assertEquals((long)Types.uint12((long)0L), (long)((Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply()).get());
        b.set(this.p64);
        Assertions.assertEquals((long)Types.uint12((Number)this.p64), (long)((Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply()).get());
    }

    @Test
    public void testUint128ToUint12() {
        Unsigned128BitType b = new Unsigned128BitType(this.beef);
        Unsigned12BitType result = (Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply();
        Assertions.assertEquals((long)Types.uint12((Number)this.beef), (long)result.get());
        b.set(this.biZero);
        Assertions.assertEquals((long)Types.uint12((Number)this.biZero), (long)((Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply()).get());
        b.set(this.p128);
        Assertions.assertEquals((long)Types.uint12((Number)this.p128), (long)((Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply()).get());
    }

    @Test
    public void testFloat32ToUint12() {
        FloatType b = new FloatType(123453.125f);
        Unsigned12BitType result = (Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply();
        Assertions.assertEquals((long)Types.uint12((double)123453.125), (long)result.get());
        b.set(0.0f);
        Assertions.assertEquals((long)Types.uint12((double)0.0), (long)((Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply()).get());
        b.set(-2.5234854E12f);
        Assertions.assertEquals((long)Types.uint12((double)-2.523485437952E12), (long)((Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply()).get());
    }

    @Test
    public void testCfloat32ToUint12() {
        ComplexFloatType b = new ComplexFloatType(5839.25f, 120.0f);
        Unsigned12BitType result = (Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply();
        Assertions.assertEquals((long)Types.uint12((double)5839.25), (long)result.get());
        b.set(0.0f, 0.0f);
        Assertions.assertEquals((long)Types.uint12((double)0.0), (long)((Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply()).get());
        b.set(-4.25f, -123.0625f);
        Assertions.assertEquals((long)Types.uint12((double)-4.25), (long)((Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply()).get());
    }

    @Test
    public void testFloat64ToUint12() {
        DoubleType b = new DoubleType(4098.0);
        Unsigned12BitType result = (Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply();
        Assertions.assertEquals((long)Types.uint12((double)4098.0), (long)result.get());
        b.set(0.0);
        Assertions.assertEquals((long)Types.uint12((double)0.0), (long)((Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply()).get());
        b.set(-10948.015625);
        Assertions.assertEquals((long)Types.uint12((double)-10948.015625), (long)((Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply()).get());
        b.set(1.0000152587890626E20);
        Assertions.assertEquals((long)Types.uint12((double)1.0000152587890626E20), (long)((Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply()).get());
    }

    @Test
    public void testCfloat64ToUint12() {
        ComplexDoubleType b = new ComplexDoubleType(9087.0, 879542.125);
        Unsigned12BitType result = (Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply();
        Assertions.assertEquals((long)Types.uint12((double)9087.0), (long)result.get());
        b.set(0.0, 0.0);
        Assertions.assertEquals((long)Types.uint12((double)0.0), (long)((Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply()).get());
        b.set(-234.25, -9.0);
        Assertions.assertEquals((long)Types.uint12((double)-234.25), (long)((Unsigned12BitType)ops.op("convert.uint12").input((Object)b).outType(Unsigned12BitType.class).apply()).get());
    }

    @Test
    public void testBitToInt16() {
        BitType b = new BitType(true);
        ShortType result = (ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply();
        Assertions.assertEquals((short)Types.int16((long)1L), (short)result.get());
        b.set(false);
        Assertions.assertEquals((short)Types.int16((long)0L), (short)((ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply()).get());
    }

    @Test
    public void testUint2ToInt16() {
        Unsigned2BitType b = new Unsigned2BitType(2L);
        ShortType result = (ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply();
        Assertions.assertEquals((short)Types.int16((long)2L), (short)result.get());
        b.set(0L);
        Assertions.assertEquals((short)Types.int16((long)0L), (short)((ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply()).get());
    }

    @Test
    public void testUint4ToInt16() {
        Unsigned4BitType b = new Unsigned4BitType(15L);
        ShortType result = (ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply();
        Assertions.assertEquals((short)Types.int16((long)15L), (short)result.get());
        b.set(0L);
        Assertions.assertEquals((short)Types.int16((long)0L), (short)((ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply()).get());
    }

    @Test
    public void testInt8ToInt16() {
        ByteType b = new ByteType(8);
        ShortType result = (ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply();
        Assertions.assertEquals((short)Types.int16((long)8L), (short)result.get());
        b.set((byte)0);
        Assertions.assertEquals((short)Types.int16((long)0L), (short)((ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply()).get());
        b.set((byte)-12);
        Assertions.assertEquals((short)Types.int16((long)-12L), (short)((ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply()).get());
    }

    @Test
    public void testUint8ToInt16() {
        UnsignedByteType b = new UnsignedByteType(100);
        ShortType result = (ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply();
        Assertions.assertEquals((short)Types.int16((long)100L), (short)result.get());
        b.set(0);
        Assertions.assertEquals((short)Types.int16((long)0L), (short)((ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply()).get());
    }

    @Test
    public void testUint12ToInt16() {
        Unsigned12BitType b = new Unsigned12BitType(212L);
        ShortType result = (ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply();
        Assertions.assertEquals((short)Types.int16((long)212L), (short)result.get());
        b.set(0L);
        Assertions.assertEquals((short)Types.int16((long)0L), (short)((ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply()).get());
    }

    @Test
    public void testInt16ToInt16() {
        ShortType b = new ShortType(52);
        ShortType result = (ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply();
        Assertions.assertEquals((short)Types.int16((long)52L), (short)result.get());
        b.set((short)0);
        Assertions.assertEquals((short)Types.int16((long)0L), (short)((ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply()).get());
        b.set((short)-154);
        Assertions.assertEquals((short)Types.int16((long)-154L), (short)((ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply()).get());
    }

    @Test
    public void testUint16ToInt16() {
        UnsignedShortType b = new UnsignedShortType(480);
        ShortType result = (ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply();
        Assertions.assertEquals((short)Types.int16((long)480L), (short)result.get());
        b.set(0);
        Assertions.assertEquals((short)Types.int16((long)0L), (short)((ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply()).get());
    }

    @Test
    public void testInt32ToInt16() {
        IntType b = new IntType(301);
        ShortType result = (ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply();
        Assertions.assertEquals((short)Types.int16((long)301L), (short)result.get());
        b.set(0);
        Assertions.assertEquals((short)Types.int16((long)0L), (short)((ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply()).get());
        b.set(-89);
        Assertions.assertEquals((short)Types.int16((long)-89L), (short)((ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply()).get());
    }

    @Test
    public void testUint32ToInt16() {
        UnsignedIntType b = new UnsignedIntType(20L);
        ShortType result = (ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply();
        Assertions.assertEquals((short)Types.int16((long)20L), (short)result.get());
        b.set(0L);
        Assertions.assertEquals((short)Types.int16((long)0L), (short)((ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply()).get());
    }

    @Test
    public void testInt64ToInt16() {
        LongType b = new LongType(891L);
        ShortType result = (ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply();
        Assertions.assertEquals((short)Types.int16((long)891L), (short)result.get());
        b.set(0L);
        Assertions.assertEquals((short)Types.int16((long)0L), (short)((ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply()).get());
        b.set(-1024L);
        Assertions.assertEquals((short)Types.int16((long)-1024L), (short)((ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply()).get());
    }

    @Test
    public void testUint64ToInt16() {
        UnsignedLongType b = new UnsignedLongType(1049L);
        ShortType result = (ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply();
        Assertions.assertEquals((short)Types.int16((long)1049L), (short)result.get());
        b.set(0L);
        Assertions.assertEquals((short)Types.int16((long)0L), (short)((ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply()).get());
        b.set(this.p64);
        Assertions.assertEquals((short)Types.int16((BigInteger)this.p64), (short)((ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply()).get());
    }

    @Test
    public void testUint128ToInt16() {
        Unsigned128BitType b = new Unsigned128BitType(this.beef);
        ShortType result = (ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply();
        Assertions.assertEquals((short)Types.int16((BigInteger)this.beef), (short)result.get());
        b.set(this.biZero);
        Assertions.assertEquals((short)Types.int16((BigInteger)this.biZero), (short)((ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply()).get());
        b.set(this.p128);
        Assertions.assertEquals((short)Types.int16((BigInteger)this.p128), (short)((ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply()).get());
    }

    @Test
    public void testFloat32ToInt16() {
        FloatType b = new FloatType(123453.125f);
        ShortType result = (ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply();
        Assertions.assertEquals((short)Types.int16((double)123453.125), (short)result.get());
        b.set(0.0f);
        Assertions.assertEquals((short)Types.int16((double)0.0), (short)((ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply()).get());
        b.set(-2.5234854E12f);
        Assertions.assertEquals((short)Types.int16((double)-2.523485437952E12), (short)((ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply()).get());
    }

    @Test
    public void testCfloat32ToInt16() {
        ComplexFloatType b = new ComplexFloatType(5839.25f, 120.0f);
        ShortType result = (ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply();
        Assertions.assertEquals((short)Types.int16((double)5839.25), (short)result.get());
        b.set(0.0f, 0.0f);
        Assertions.assertEquals((short)Types.int16((double)0.0), (short)((ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply()).get());
        b.set(-4.25f, -123.0625f);
        Assertions.assertEquals((short)Types.int16((double)-4.25), (short)((ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply()).get());
    }

    @Test
    public void testFloat64ToInt16() {
        DoubleType b = new DoubleType(4098.0);
        ShortType result = (ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply();
        Assertions.assertEquals((short)Types.int16((double)4098.0), (short)result.get());
        b.set(0.0);
        Assertions.assertEquals((short)Types.int16((double)0.0), (short)((ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply()).get());
        b.set(-10948.015625);
        Assertions.assertEquals((short)Types.int16((double)-10948.015625), (short)((ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply()).get());
        b.set(1.0000152587890626E20);
        Assertions.assertEquals((short)Types.int16((double)1.0000152587890626E20), (short)((ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply()).get());
    }

    @Test
    public void testCfloat64ToInt16() {
        ComplexDoubleType b = new ComplexDoubleType(9087.0, 879542.125);
        ShortType result = (ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply();
        Assertions.assertEquals((short)Types.int16((double)9087.0), (short)result.get());
        b.set(0.0, 0.0);
        Assertions.assertEquals((short)Types.int16((double)0.0), (short)((ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply()).get());
        b.set(-234.25, -9.0);
        Assertions.assertEquals((short)Types.int16((double)-234.25), (short)((ShortType)ops.op("convert.int16").input((Object)b).outType(ShortType.class).apply()).get());
    }

    @Test
    public void testBitToUint16() {
        BitType b = new BitType(true);
        UnsignedShortType result = (UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply();
        Assertions.assertEquals((int)Types.uint16((long)1L), (int)result.get());
        b.set(false);
        Assertions.assertEquals((int)Types.uint16((long)0L), (int)((UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply()).get());
    }

    @Test
    public void testUint2ToUint16() {
        Unsigned2BitType b = new Unsigned2BitType(2L);
        UnsignedShortType result = (UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply();
        Assertions.assertEquals((int)Types.uint16((long)2L), (int)result.get());
        b.set(0L);
        Assertions.assertEquals((int)Types.uint16((long)0L), (int)((UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply()).get());
    }

    @Test
    public void testUint4ToUint16() {
        Unsigned4BitType b = new Unsigned4BitType(15L);
        UnsignedShortType result = (UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply();
        Assertions.assertEquals((int)Types.uint16((long)15L), (int)result.get());
        b.set(0L);
        Assertions.assertEquals((int)Types.uint16((long)0L), (int)((UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply()).get());
    }

    @Test
    public void testInt8ToUint16() {
        ByteType b = new ByteType(8);
        UnsignedShortType result = (UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply();
        Assertions.assertEquals((int)Types.uint16((long)8L), (int)result.get());
        b.set((byte)0);
        Assertions.assertEquals((int)Types.uint16((long)0L), (int)((UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply()).get());
        b.set((byte)-12);
        Assertions.assertEquals((int)Types.uint16((long)-12L), (int)((UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply()).get());
    }

    @Test
    public void testUint8ToUint16() {
        UnsignedByteType b = new UnsignedByteType(100);
        UnsignedShortType result = (UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply();
        Assertions.assertEquals((int)Types.uint16((long)100L), (int)result.get());
        b.set(0);
        Assertions.assertEquals((int)Types.uint16((long)0L), (int)((UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply()).get());
    }

    @Test
    public void testUint12ToUint16() {
        Unsigned12BitType b = new Unsigned12BitType(212L);
        UnsignedShortType result = (UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply();
        Assertions.assertEquals((int)Types.uint16((long)212L), (int)result.get());
        b.set(0L);
        Assertions.assertEquals((int)Types.uint16((long)0L), (int)((UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply()).get());
    }

    @Test
    public void testInt16ToUint16() {
        ShortType b = new ShortType(52);
        UnsignedShortType result = (UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply();
        Assertions.assertEquals((int)Types.uint16((long)52L), (int)result.get());
        b.set((short)0);
        Assertions.assertEquals((int)Types.uint16((long)0L), (int)((UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply()).get());
        b.set((short)-154);
        Assertions.assertEquals((int)Types.uint16((long)-154L), (int)((UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply()).get());
    }

    @Test
    public void testUint16ToUint16() {
        UnsignedShortType b = new UnsignedShortType(480);
        UnsignedShortType result = (UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply();
        Assertions.assertEquals((int)Types.uint16((long)480L), (int)result.get());
        b.set(0);
        Assertions.assertEquals((int)Types.uint16((long)0L), (int)((UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply()).get());
    }

    @Test
    public void testInt32ToUint16() {
        IntType b = new IntType(301);
        UnsignedShortType result = (UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply();
        Assertions.assertEquals((int)Types.uint16((long)301L), (int)result.get());
        b.set(0);
        Assertions.assertEquals((int)Types.uint16((long)0L), (int)((UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply()).get());
        b.set(-89);
        Assertions.assertEquals((int)Types.uint16((long)-89L), (int)((UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply()).get());
    }

    @Test
    public void testUint32ToUint16() {
        UnsignedIntType b = new UnsignedIntType(20L);
        UnsignedShortType result = (UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply();
        Assertions.assertEquals((int)Types.uint16((long)20L), (int)result.get());
        b.set(0L);
        Assertions.assertEquals((int)Types.uint16((long)0L), (int)((UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply()).get());
    }

    @Test
    public void testInt64ToUint16() {
        LongType b = new LongType(891L);
        UnsignedShortType result = (UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply();
        Assertions.assertEquals((int)Types.uint16((long)891L), (int)result.get());
        b.set(0L);
        Assertions.assertEquals((int)Types.uint16((long)0L), (int)((UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply()).get());
        b.set(-1024L);
        Assertions.assertEquals((int)Types.uint16((long)-1024L), (int)((UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply()).get());
    }

    @Test
    public void testUint64ToUint16() {
        UnsignedLongType b = new UnsignedLongType(1049L);
        UnsignedShortType result = (UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply();
        Assertions.assertEquals((int)Types.uint16((long)1049L), (int)result.get());
        b.set(0L);
        Assertions.assertEquals((int)Types.uint16((long)0L), (int)((UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply()).get());
        b.set(this.p64);
        Assertions.assertEquals((int)Types.uint16((Number)this.p64), (int)((UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply()).get());
    }

    @Test
    public void testUint128ToUint16() {
        Unsigned128BitType b = new Unsigned128BitType(this.beef);
        UnsignedShortType result = (UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply();
        Assertions.assertEquals((int)Types.uint16((Number)this.beef), (int)result.get());
        b.set(this.biZero);
        Assertions.assertEquals((int)Types.uint16((Number)this.biZero), (int)((UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply()).get());
        b.set(this.p128);
        Assertions.assertEquals((int)Types.uint16((Number)this.p128), (int)((UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply()).get());
    }

    @Test
    public void testFloat32ToUint16() {
        FloatType b = new FloatType(123453.125f);
        UnsignedShortType result = (UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply();
        Assertions.assertEquals((int)Types.uint16((double)123453.125), (int)result.get());
        b.set(0.0f);
        Assertions.assertEquals((int)Types.uint16((double)0.0), (int)((UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply()).get());
        b.set(-2.5234854E12f);
        Assertions.assertEquals((int)Types.uint16((double)-2.523485437952E12), (int)((UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply()).get());
    }

    @Test
    public void testCfloat32ToUint16() {
        ComplexFloatType b = new ComplexFloatType(5839.25f, 120.0f);
        UnsignedShortType result = (UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply();
        Assertions.assertEquals((int)Types.uint16((double)5839.25), (int)result.get());
        b.set(0.0f, 0.0f);
        Assertions.assertEquals((int)Types.uint16((double)0.0), (int)((UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply()).get());
        b.set(-4.25f, -123.0625f);
        Assertions.assertEquals((int)Types.uint16((double)-4.25), (int)((UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply()).get());
    }

    @Test
    public void testFloat64ToUint16() {
        DoubleType b = new DoubleType(4098.0);
        UnsignedShortType result = (UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply();
        Assertions.assertEquals((int)Types.uint16((double)4098.0), (int)result.get());
        b.set(0.0);
        Assertions.assertEquals((int)Types.uint16((double)0.0), (int)((UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply()).get());
        b.set(-10948.015625);
        Assertions.assertEquals((int)Types.uint16((double)-10948.015625), (int)((UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply()).get());
        b.set(1.0000152587890626E20);
        Assertions.assertEquals((int)Types.uint16((double)1.0000152587890626E20), (int)((UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply()).get());
    }

    @Test
    public void testCfloat64ToUint16() {
        ComplexDoubleType b = new ComplexDoubleType(9087.0, 879542.125);
        UnsignedShortType result = (UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply();
        Assertions.assertEquals((int)Types.uint16((double)9087.0), (int)result.get());
        b.set(0.0, 0.0);
        Assertions.assertEquals((int)Types.uint16((double)0.0), (int)((UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply()).get());
        b.set(-234.25, -9.0);
        Assertions.assertEquals((int)Types.uint16((double)-234.25), (int)((UnsignedShortType)ops.op("convert.uint16").input((Object)b).outType(UnsignedShortType.class).apply()).get());
    }

    @Test
    public void testBitToInt32() {
        BitType b = new BitType(true);
        IntType result = (IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply();
        Assertions.assertEquals((int)Types.int32((long)1L), (int)result.get());
        b.set(false);
        Assertions.assertEquals((int)Types.int32((long)0L), (int)((IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply()).get());
    }

    @Test
    public void testUint2ToInt32() {
        Unsigned2BitType b = new Unsigned2BitType(2L);
        IntType result = (IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply();
        Assertions.assertEquals((int)Types.int32((long)2L), (int)result.get());
        b.set(0L);
        Assertions.assertEquals((int)Types.int32((long)0L), (int)((IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply()).get());
    }

    @Test
    public void testUint4ToInt32() {
        Unsigned4BitType b = new Unsigned4BitType(15L);
        IntType result = (IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply();
        Assertions.assertEquals((int)Types.int32((long)15L), (int)result.get());
        b.set(0L);
        Assertions.assertEquals((int)Types.int32((long)0L), (int)((IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply()).get());
    }

    @Test
    public void testInt8ToInt32() {
        ByteType b = new ByteType(8);
        IntType result = (IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply();
        Assertions.assertEquals((int)Types.int32((long)8L), (int)result.get());
        b.set((byte)0);
        Assertions.assertEquals((int)Types.int32((long)0L), (int)((IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply()).get());
        b.set((byte)-12);
        Assertions.assertEquals((int)Types.int32((long)-12L), (int)((IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply()).get());
    }

    @Test
    public void testUint8ToInt32() {
        UnsignedByteType b = new UnsignedByteType(100);
        IntType result = (IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply();
        Assertions.assertEquals((int)Types.int32((long)100L), (int)result.get());
        b.set(0);
        Assertions.assertEquals((int)Types.int32((long)0L), (int)((IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply()).get());
    }

    @Test
    public void testUint12ToInt32() {
        Unsigned12BitType b = new Unsigned12BitType(212L);
        IntType result = (IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply();
        Assertions.assertEquals((int)Types.int32((long)212L), (int)result.get());
        b.set(0L);
        Assertions.assertEquals((int)Types.int32((long)0L), (int)((IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply()).get());
    }

    @Test
    public void testInt16ToInt32() {
        ShortType b = new ShortType(52);
        IntType result = (IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply();
        Assertions.assertEquals((int)Types.int32((long)52L), (int)result.get());
        b.set((short)0);
        Assertions.assertEquals((int)Types.int32((long)0L), (int)((IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply()).get());
        b.set((short)-154);
        Assertions.assertEquals((int)Types.int32((long)-154L), (int)((IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply()).get());
    }

    @Test
    public void testUint16ToInt32() {
        UnsignedShortType b = new UnsignedShortType(480);
        IntType result = (IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply();
        Assertions.assertEquals((int)Types.int32((long)480L), (int)result.get());
        b.set(0);
        Assertions.assertEquals((int)Types.int32((long)0L), (int)((IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply()).get());
    }

    @Test
    public void testInt32ToInt32() {
        IntType b = new IntType(301);
        IntType result = (IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply();
        Assertions.assertEquals((int)Types.int32((long)301L), (int)result.get());
        b.set(0);
        Assertions.assertEquals((int)Types.int32((long)0L), (int)((IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply()).get());
        b.set(-89);
        Assertions.assertEquals((int)Types.int32((long)-89L), (int)((IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply()).get());
    }

    @Test
    public void testUint32ToInt32() {
        UnsignedIntType b = new UnsignedIntType(20L);
        IntType result = (IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply();
        Assertions.assertEquals((int)Types.int32((long)20L), (int)result.get());
        b.set(0L);
        Assertions.assertEquals((int)Types.int32((long)0L), (int)((IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply()).get());
    }

    @Test
    public void testInt64ToInt32() {
        LongType b = new LongType(891L);
        IntType result = (IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply();
        Assertions.assertEquals((int)Types.int32((long)891L), (int)result.get());
        b.set(0L);
        Assertions.assertEquals((int)Types.int32((long)0L), (int)((IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply()).get());
        b.set(-1024L);
        Assertions.assertEquals((int)Types.int32((long)-1024L), (int)((IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply()).get());
    }

    @Test
    public void testUint64ToInt32() {
        UnsignedLongType b = new UnsignedLongType(1049L);
        IntType result = (IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply();
        Assertions.assertEquals((int)Types.int32((long)1049L), (int)result.get());
        b.set(0L);
        Assertions.assertEquals((int)Types.int32((long)0L), (int)((IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply()).get());
        b.set(this.p64);
        Assertions.assertEquals((int)Types.int32((Number)this.p64), (int)((IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply()).get());
    }

    @Test
    public void testUint128ToInt32() {
        Unsigned128BitType b = new Unsigned128BitType(this.beef);
        IntType result = (IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply();
        Assertions.assertEquals((int)Types.int32((Number)this.beef), (int)result.get());
        b.set(this.biZero);
        Assertions.assertEquals((int)Types.int32((Number)this.biZero), (int)((IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply()).get());
        b.set(this.p128);
        Assertions.assertEquals((int)Types.int32((Number)this.p128), (int)((IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply()).get());
    }

    @Test
    public void testFloat32ToInt32() {
        FloatType b = new FloatType(123453.125f);
        IntType result = (IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply();
        Assertions.assertEquals((int)Types.int32((double)123453.125), (int)result.get());
        b.set(0.0f);
        Assertions.assertEquals((int)Types.int32((double)0.0), (int)((IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply()).get());
        b.set(-2.5234854E12f);
        Assertions.assertEquals((int)Types.int32((double)-2.523485437952E12), (int)((IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply()).get());
    }

    @Test
    public void testCfloat32ToInt32() {
        ComplexFloatType b = new ComplexFloatType(5839.25f, 120.0f);
        IntType result = (IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply();
        Assertions.assertEquals((int)Types.int32((double)5839.25), (int)result.get());
        b.set(0.0f, 0.0f);
        Assertions.assertEquals((int)Types.int32((double)0.0), (int)((IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply()).get());
        b.set(-4.25f, -123.0625f);
        Assertions.assertEquals((int)Types.int32((double)-4.25), (int)((IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply()).get());
    }

    @Test
    public void testFloat64ToInt32() {
        DoubleType b = new DoubleType(4098.0);
        IntType result = (IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply();
        Assertions.assertEquals((int)Types.int32((double)4098.0), (int)result.get());
        b.set(0.0);
        Assertions.assertEquals((int)Types.int32((double)0.0), (int)((IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply()).get());
        b.set(-10948.015625);
        Assertions.assertEquals((int)Types.int32((double)-10948.015625), (int)((IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply()).get());
        b.set(1.0000152587890626E20);
        Assertions.assertEquals((int)Types.int32((double)1.0000152587890626E20), (int)((IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply()).get());
    }

    @Test
    public void testCfloat64ToInt32() {
        ComplexDoubleType b = new ComplexDoubleType(9087.0, 879542.125);
        IntType result = (IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply();
        Assertions.assertEquals((int)Types.int32((double)9087.0), (int)result.get());
        b.set(0.0, 0.0);
        Assertions.assertEquals((int)Types.int32((double)0.0), (int)((IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply()).get());
        b.set(-234.25, -9.0);
        Assertions.assertEquals((int)Types.int32((double)-234.25), (int)((IntType)ops.op("convert.int32").input((Object)b).outType(IntType.class).apply()).get());
    }

    @Test
    public void testBitToUint32() {
        BitType b = new BitType(true);
        UnsignedIntType result = (UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply();
        Assertions.assertEquals((long)Types.uint32((long)1L), (long)result.get());
        b.set(false);
        Assertions.assertEquals((long)Types.uint32((long)0L), (long)((UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply()).get());
    }

    @Test
    public void testUint2ToUint32() {
        Unsigned2BitType b = new Unsigned2BitType(2L);
        UnsignedIntType result = (UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply();
        Assertions.assertEquals((long)Types.uint32((long)2L), (long)result.get());
        b.set(0L);
        Assertions.assertEquals((long)Types.uint32((long)0L), (long)((UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply()).get());
    }

    @Test
    public void testUint4ToUint32() {
        Unsigned4BitType b = new Unsigned4BitType(15L);
        UnsignedIntType result = (UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply();
        Assertions.assertEquals((long)Types.uint32((long)15L), (long)result.get());
        b.set(0L);
        Assertions.assertEquals((long)Types.uint32((long)0L), (long)((UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply()).get());
    }

    @Test
    public void testInt8ToUint32() {
        ByteType b = new ByteType(8);
        UnsignedIntType result = (UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply();
        Assertions.assertEquals((long)Types.uint32((long)8L), (long)result.get());
        b.set((byte)0);
        Assertions.assertEquals((long)Types.uint32((long)0L), (long)((UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply()).get());
        b.set((byte)-12);
        Assertions.assertEquals((long)Types.uint32((long)-12L), (long)((UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply()).get());
    }

    @Test
    public void testUint8ToUint32() {
        UnsignedByteType b = new UnsignedByteType(100);
        UnsignedIntType result = (UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply();
        Assertions.assertEquals((long)Types.uint32((long)100L), (long)result.get());
        b.set(0);
        Assertions.assertEquals((long)Types.uint32((long)0L), (long)((UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply()).get());
    }

    @Test
    public void testUint12ToUint32() {
        Unsigned12BitType b = new Unsigned12BitType(212L);
        UnsignedIntType result = (UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply();
        Assertions.assertEquals((long)Types.uint32((long)212L), (long)result.get());
        b.set(0L);
        Assertions.assertEquals((long)Types.uint32((long)0L), (long)((UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply()).get());
    }

    @Test
    public void testInt16ToUint32() {
        ShortType b = new ShortType(52);
        UnsignedIntType result = (UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply();
        Assertions.assertEquals((long)Types.uint32((long)52L), (long)result.get());
        b.set((short)0);
        Assertions.assertEquals((long)Types.uint32((long)0L), (long)((UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply()).get());
        b.set((short)-154);
        Assertions.assertEquals((long)Types.uint32((long)-154L), (long)((UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply()).get());
    }

    @Test
    public void testUint16ToUint32() {
        UnsignedShortType b = new UnsignedShortType(480);
        UnsignedIntType result = (UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply();
        Assertions.assertEquals((long)Types.uint32((long)480L), (long)result.get());
        b.set(0);
        Assertions.assertEquals((long)Types.uint32((long)0L), (long)((UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply()).get());
    }

    @Test
    public void testInt32ToUint32() {
        IntType b = new IntType(301);
        UnsignedIntType result = (UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply();
        Assertions.assertEquals((long)Types.uint32((long)301L), (long)result.get());
        b.set(0);
        Assertions.assertEquals((long)Types.uint32((long)0L), (long)((UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply()).get());
        b.set(-89);
        Assertions.assertEquals((long)Types.uint32((long)-89L), (long)((UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply()).get());
    }

    @Test
    public void testUint32ToUint32() {
        UnsignedIntType b = new UnsignedIntType(20L);
        UnsignedIntType result = (UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply();
        Assertions.assertEquals((long)Types.uint32((long)20L), (long)result.get());
        b.set(0L);
        Assertions.assertEquals((long)Types.uint32((long)0L), (long)((UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply()).get());
    }

    @Test
    public void testInt64ToUint32() {
        LongType b = new LongType(891L);
        UnsignedIntType result = (UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply();
        Assertions.assertEquals((long)Types.uint32((long)891L), (long)result.get());
        b.set(0L);
        Assertions.assertEquals((long)Types.uint32((long)0L), (long)((UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply()).get());
        b.set(-1024L);
        Assertions.assertEquals((long)Types.uint32((long)-1024L), (long)((UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply()).get());
    }

    @Test
    public void testUint64ToUint32() {
        UnsignedLongType b = new UnsignedLongType(1049L);
        UnsignedIntType result = (UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply();
        Assertions.assertEquals((long)Types.uint32((long)1049L), (long)result.get());
        b.set(0L);
        Assertions.assertEquals((long)Types.uint32((long)0L), (long)((UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply()).get());
        b.set(this.p64);
        Assertions.assertEquals((long)Types.uint32((Number)this.p64), (long)((UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply()).get());
    }

    @Test
    public void testUint128ToUint32() {
        Unsigned128BitType b = new Unsigned128BitType(this.beef);
        UnsignedIntType result = (UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply();
        Assertions.assertEquals((long)Types.uint32((Number)this.beef), (long)result.get());
        b.set(this.biZero);
        Assertions.assertEquals((long)Types.uint32((Number)this.biZero), (long)((UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply()).get());
        b.set(this.p128);
        Assertions.assertEquals((long)Types.uint32((Number)this.p128), (long)((UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply()).get());
    }

    @Test
    public void testFloat32ToUint32() {
        FloatType b = new FloatType(123453.125f);
        UnsignedIntType result = (UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply();
        Assertions.assertEquals((long)Types.uint32((double)123453.125), (long)result.get());
        b.set(0.0f);
        Assertions.assertEquals((long)Types.uint32((double)0.0), (long)((UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply()).get());
        b.set(-2.5234854E12f);
        Assertions.assertEquals((long)Types.uint32((double)-2.523485437952E12), (long)((UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply()).get());
    }

    @Test
    public void testCfloat32ToUint32() {
        ComplexFloatType b = new ComplexFloatType(5839.25f, 120.0f);
        UnsignedIntType result = (UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply();
        Assertions.assertEquals((long)Types.uint32((double)5839.25), (long)result.get());
        b.set(0.0f, 0.0f);
        Assertions.assertEquals((long)Types.uint32((double)0.0), (long)((UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply()).get());
        b.set(-4.25f, -123.0625f);
        Assertions.assertEquals((long)Types.uint32((double)-4.25), (long)((UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply()).get());
    }

    @Test
    public void testFloat64ToUint32() {
        DoubleType b = new DoubleType(4098.0);
        UnsignedIntType result = (UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply();
        Assertions.assertEquals((long)Types.uint32((double)4098.0), (long)result.get());
        b.set(0.0);
        Assertions.assertEquals((long)Types.uint32((double)0.0), (long)((UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply()).get());
        b.set(-10948.015625);
        Assertions.assertEquals((long)Types.uint32((double)-10948.015625), (long)((UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply()).get());
        b.set(1.0000152587890626E20);
        Assertions.assertEquals((long)Types.uint32((double)1.0000152587890626E20), (long)((UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply()).get());
    }

    @Test
    public void testCfloat64ToUint32() {
        ComplexDoubleType b = new ComplexDoubleType(9087.0, 879542.125);
        UnsignedIntType result = (UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply();
        Assertions.assertEquals((long)Types.uint32((double)9087.0), (long)result.get());
        b.set(0.0, 0.0);
        Assertions.assertEquals((long)Types.uint32((double)0.0), (long)((UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply()).get());
        b.set(-234.25, -9.0);
        Assertions.assertEquals((long)Types.uint32((double)-234.25), (long)((UnsignedIntType)ops.op("convert.uint32").input((Object)b).outType(UnsignedIntType.class).apply()).get());
    }

    @Test
    public void testBitToInt64() {
        BitType b = new BitType(true);
        LongType result = (LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply();
        Assertions.assertEquals((long)Types.int64((long)1L), (long)result.get());
        b.set(false);
        Assertions.assertEquals((long)Types.int64((long)0L), (long)((LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply()).get());
    }

    @Test
    public void testUint2ToInt64() {
        Unsigned2BitType b = new Unsigned2BitType(2L);
        LongType result = (LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply();
        Assertions.assertEquals((long)Types.int64((long)2L), (long)result.get());
        b.set(0L);
        Assertions.assertEquals((long)Types.int64((long)0L), (long)((LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply()).get());
    }

    @Test
    public void testUint4ToInt64() {
        Unsigned4BitType b = new Unsigned4BitType(15L);
        LongType result = (LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply();
        Assertions.assertEquals((long)Types.int64((long)15L), (long)result.get());
        b.set(0L);
        Assertions.assertEquals((long)Types.int64((long)0L), (long)((LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply()).get());
    }

    @Test
    public void testInt8ToInt64() {
        ByteType b = new ByteType(8);
        LongType result = (LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply();
        Assertions.assertEquals((long)Types.int64((long)8L), (long)result.get());
        b.set((byte)0);
        Assertions.assertEquals((long)Types.int64((long)0L), (long)((LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply()).get());
        b.set((byte)-12);
        Assertions.assertEquals((long)Types.int64((long)-12L), (long)((LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply()).get());
    }

    @Test
    public void testUint8ToInt64() {
        UnsignedByteType b = new UnsignedByteType(100);
        LongType result = (LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply();
        Assertions.assertEquals((long)Types.int64((long)100L), (long)result.get());
        b.set(0);
        Assertions.assertEquals((long)Types.int64((long)0L), (long)((LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply()).get());
    }

    @Test
    public void testUint12ToInt64() {
        Unsigned12BitType b = new Unsigned12BitType(212L);
        LongType result = (LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply();
        Assertions.assertEquals((long)Types.int64((long)212L), (long)result.get());
        b.set(0L);
        Assertions.assertEquals((long)Types.int64((long)0L), (long)((LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply()).get());
    }

    @Test
    public void testInt16ToInt64() {
        ShortType b = new ShortType(52);
        LongType result = (LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply();
        Assertions.assertEquals((long)Types.int64((long)52L), (long)result.get());
        b.set((short)0);
        Assertions.assertEquals((long)Types.int64((long)0L), (long)((LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply()).get());
        b.set((short)-154);
        Assertions.assertEquals((long)Types.int64((long)-154L), (long)((LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply()).get());
    }

    @Test
    public void testUint16ToInt64() {
        UnsignedShortType b = new UnsignedShortType(480);
        LongType result = (LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply();
        Assertions.assertEquals((long)Types.int64((long)480L), (long)result.get());
        b.set(0);
        Assertions.assertEquals((long)Types.int64((long)0L), (long)((LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply()).get());
    }

    @Test
    public void testInt32ToInt64() {
        IntType b = new IntType(301);
        LongType result = (LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply();
        Assertions.assertEquals((long)Types.int64((long)301L), (long)result.get());
        b.set(0);
        Assertions.assertEquals((long)Types.int64((long)0L), (long)((LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply()).get());
        b.set(-89);
        Assertions.assertEquals((long)Types.int64((long)-89L), (long)((LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply()).get());
    }

    @Test
    public void testUint32ToInt64() {
        UnsignedIntType b = new UnsignedIntType(20L);
        LongType result = (LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply();
        Assertions.assertEquals((long)Types.int64((long)20L), (long)result.get());
        b.set(0L);
        Assertions.assertEquals((long)Types.int64((long)0L), (long)((LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply()).get());
    }

    @Test
    public void testInt64ToInt64() {
        LongType b = new LongType(891L);
        LongType result = (LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply();
        Assertions.assertEquals((long)Types.int64((long)891L), (long)result.get());
        b.set(0L);
        Assertions.assertEquals((long)Types.int64((long)0L), (long)((LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply()).get());
        b.set(-1024L);
        Assertions.assertEquals((long)Types.int64((long)-1024L), (long)((LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply()).get());
    }

    @Test
    public void testUint64ToInt64() {
        UnsignedLongType b = new UnsignedLongType(1049L);
        LongType result = (LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply();
        Assertions.assertEquals((long)Types.int64((long)1049L), (long)result.get());
        b.set(0L);
        Assertions.assertEquals((long)Types.int64((long)0L), (long)((LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply()).get());
        b.set(this.p64);
        Assertions.assertEquals((long)Types.int64((BigInteger)this.p64), (long)((LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply()).get());
    }

    @Test
    public void testUint128ToInt64() {
        Unsigned128BitType b = new Unsigned128BitType(this.beef);
        LongType result = (LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply();
        Assertions.assertEquals((long)Types.int64((BigInteger)this.beef), (long)result.get());
        b.set(this.biZero);
        Assertions.assertEquals((long)Types.int64((BigInteger)this.biZero), (long)((LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply()).get());
        b.set(this.p128);
        Assertions.assertEquals((long)Types.int64((BigInteger)this.p128), (long)((LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply()).get());
    }

    @Test
    public void testFloat32ToInt64() {
        FloatType b = new FloatType(123453.125f);
        LongType result = (LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply();
        Assertions.assertEquals((long)Types.int64((double)123453.125), (long)result.get());
        b.set(0.0f);
        Assertions.assertEquals((long)Types.int64((double)0.0), (long)((LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply()).get());
        b.set(-2.5234854E12f);
        Assertions.assertEquals((long)Types.int64((double)-2.523485437952E12), (long)((LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply()).get());
    }

    @Test
    public void testCfloat32ToInt64() {
        ComplexFloatType b = new ComplexFloatType(5839.25f, 120.0f);
        LongType result = (LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply();
        Assertions.assertEquals((long)Types.int64((double)5839.25), (long)result.get());
        b.set(0.0f, 0.0f);
        Assertions.assertEquals((long)Types.int64((double)0.0), (long)((LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply()).get());
        b.set(-4.25f, -123.0625f);
        Assertions.assertEquals((long)Types.int64((double)-4.25), (long)((LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply()).get());
    }

    @Test
    public void testFloat64ToInt64() {
        DoubleType b = new DoubleType(4098.0);
        LongType result = (LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply();
        Assertions.assertEquals((long)Types.int64((double)4098.0), (long)result.get());
        b.set(0.0);
        Assertions.assertEquals((long)Types.int64((double)0.0), (long)((LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply()).get());
        b.set(-10948.015625);
        Assertions.assertEquals((long)Types.int64((double)-10948.015625), (long)((LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply()).get());
        b.set(1.0000152587890626E20);
        Assertions.assertEquals((long)Types.int64((double)1.0000152587890626E20), (long)((LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply()).get());
    }

    @Test
    public void testCfloat64ToInt64() {
        ComplexDoubleType b = new ComplexDoubleType(9087.0, 879542.125);
        LongType result = (LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply();
        Assertions.assertEquals((long)Types.int64((double)9087.0), (long)result.get());
        b.set(0.0, 0.0);
        Assertions.assertEquals((long)Types.int64((double)0.0), (long)((LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply()).get());
        b.set(-234.25, -9.0);
        Assertions.assertEquals((long)Types.int64((double)-234.25), (long)((LongType)ops.op("convert.int64").input((Object)b).outType(LongType.class).apply()).get());
    }

    @Test
    public void testBitToUint64() {
        BitType b = new BitType(true);
        UnsignedLongType result = (UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply();
        Assertions.assertEquals((Object)Types.uint64((long)1L), (Object)result.getBigInteger());
        b.set(false);
        Assertions.assertEquals((Object)Types.uint64((long)0L), (Object)((UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply()).getBigInteger());
    }

    @Test
    public void testUint2ToUint64() {
        Unsigned2BitType b = new Unsigned2BitType(2L);
        UnsignedLongType result = (UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply();
        Assertions.assertEquals((Object)Types.uint64((long)2L), (Object)result.getBigInteger());
        b.set(0L);
        Assertions.assertEquals((Object)Types.uint64((long)0L), (Object)((UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply()).getBigInteger());
    }

    @Test
    public void testUint4ToUint64() {
        Unsigned4BitType b = new Unsigned4BitType(15L);
        UnsignedLongType result = (UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply();
        Assertions.assertEquals((Object)Types.uint64((long)15L), (Object)result.getBigInteger());
        b.set(0L);
        Assertions.assertEquals((Object)Types.uint64((long)0L), (Object)((UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply()).getBigInteger());
    }

    @Test
    public void testInt8ToUint64() {
        ByteType b = new ByteType(8);
        UnsignedLongType result = (UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply();
        Assertions.assertEquals((Object)Types.uint64((long)8L), (Object)result.getBigInteger());
        b.set((byte)0);
        Assertions.assertEquals((Object)Types.uint64((long)0L), (Object)((UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply()).getBigInteger());
        b.set((byte)-12);
        Assertions.assertEquals((Object)Types.uint64((long)-12L), (Object)((UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply()).getBigInteger());
    }

    @Test
    public void testUint8ToUint64() {
        UnsignedByteType b = new UnsignedByteType(100);
        UnsignedLongType result = (UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply();
        Assertions.assertEquals((Object)Types.uint64((long)100L), (Object)result.getBigInteger());
        b.set(0);
        Assertions.assertEquals((Object)Types.uint64((long)0L), (Object)((UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply()).getBigInteger());
    }

    @Test
    public void testUint12ToUint64() {
        Unsigned12BitType b = new Unsigned12BitType(212L);
        UnsignedLongType result = (UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply();
        Assertions.assertEquals((Object)Types.uint64((long)212L), (Object)result.getBigInteger());
        b.set(0L);
        Assertions.assertEquals((Object)Types.uint64((long)0L), (Object)((UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply()).getBigInteger());
    }

    @Test
    public void testInt16ToUint64() {
        ShortType b = new ShortType(52);
        UnsignedLongType result = (UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply();
        Assertions.assertEquals((Object)Types.uint64((long)52L), (Object)result.getBigInteger());
        b.set((short)0);
        Assertions.assertEquals((Object)Types.uint64((long)0L), (Object)((UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply()).getBigInteger());
        b.set((short)-154);
        Assertions.assertEquals((Object)Types.uint64((long)-154L), (Object)((UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply()).getBigInteger());
    }

    @Test
    public void testUint16ToUint64() {
        UnsignedShortType b = new UnsignedShortType(480);
        UnsignedLongType result = (UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply();
        Assertions.assertEquals((Object)Types.uint64((long)480L), (Object)result.getBigInteger());
        b.set(0);
        Assertions.assertEquals((Object)Types.uint64((long)0L), (Object)((UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply()).getBigInteger());
    }

    @Test
    public void testInt32ToUint64() {
        IntType b = new IntType(301);
        UnsignedLongType result = (UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply();
        Assertions.assertEquals((Object)Types.uint64((long)301L), (Object)result.getBigInteger());
        b.set(0);
        Assertions.assertEquals((Object)Types.uint64((long)0L), (Object)((UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply()).getBigInteger());
        b.set(-89);
        Assertions.assertEquals((Object)Types.uint64((long)-89L), (Object)((UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply()).getBigInteger());
    }

    @Test
    public void testUint32ToUint64() {
        UnsignedIntType b = new UnsignedIntType(20L);
        UnsignedLongType result = (UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply();
        Assertions.assertEquals((Object)Types.uint64((long)20L), (Object)result.getBigInteger());
        b.set(0L);
        Assertions.assertEquals((Object)Types.uint64((long)0L), (Object)((UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply()).getBigInteger());
    }

    @Test
    public void testInt64ToUint64() {
        LongType b = new LongType(891L);
        UnsignedLongType result = (UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply();
        Assertions.assertEquals((Object)Types.uint64((long)891L), (Object)result.getBigInteger());
        b.set(0L);
        Assertions.assertEquals((Object)Types.uint64((long)0L), (Object)((UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply()).getBigInteger());
        b.set(-1024L);
        Assertions.assertEquals((Object)Types.uint64((long)-1024L), (Object)((UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply()).getBigInteger());
    }

    @Test
    public void testUint64ToUint64() {
        UnsignedLongType b = new UnsignedLongType(1049L);
        UnsignedLongType result = (UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply();
        Assertions.assertEquals((Object)Types.uint64((long)1049L), (Object)result.getBigInteger());
        b.set(0L);
        Assertions.assertEquals((Object)Types.uint64((long)0L), (Object)((UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply()).getBigInteger());
        b.set(this.p64);
        Assertions.assertEquals((Object)Types.uint64((Number)this.p64), (Object)((UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply()).getBigInteger());
    }

    @Test
    public void testUint128ToUint64() {
        Unsigned128BitType b = new Unsigned128BitType(this.beef);
        UnsignedLongType result = (UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply();
        Assertions.assertEquals((Object)Types.uint64((Number)this.beef), (Object)result.getBigInteger());
        b.set(this.biZero);
        Assertions.assertEquals((Object)Types.uint64((Number)this.biZero), (Object)((UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply()).getBigInteger());
        b.set(this.p128);
        Assertions.assertEquals((Object)Types.uint64((Number)this.p128), (Object)((UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply()).getBigInteger());
    }

    @Test
    public void testFloat32ToUint64() {
        FloatType b = new FloatType(123453.125f);
        UnsignedLongType result = (UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply();
        Assertions.assertEquals((Object)Types.uint64((double)123453.125), (Object)result.getBigInteger());
        b.set(0.0f);
        Assertions.assertEquals((Object)Types.uint64((double)0.0), (Object)((UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply()).getBigInteger());
        b.set(-2.5234854E12f);
        Assertions.assertEquals((Object)Types.uint64((double)-2.523485437952E12), (Object)((UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply()).getBigInteger());
    }

    @Test
    public void testCfloat32ToUint64() {
        ComplexFloatType b = new ComplexFloatType(5839.25f, 120.0f);
        UnsignedLongType result = (UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply();
        Assertions.assertEquals((Object)Types.uint64((double)5839.25), (Object)result.getBigInteger());
        b.set(0.0f, 0.0f);
        Assertions.assertEquals((Object)Types.uint64((double)0.0), (Object)((UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply()).getBigInteger());
        b.set(-4.25f, -123.0625f);
        Assertions.assertEquals((Object)Types.uint64((double)-4.25), (Object)((UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply()).getBigInteger());
    }

    @Test
    public void testFloat64ToUint64() {
        DoubleType b = new DoubleType(4098.0);
        UnsignedLongType result = (UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply();
        Assertions.assertEquals((Object)Types.uint64((double)4098.0), (Object)result.getBigInteger());
        b.set(0.0);
        Assertions.assertEquals((Object)Types.uint64((double)0.0), (Object)((UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply()).getBigInteger());
        b.set(-10948.015625);
        Assertions.assertEquals((Object)Types.uint64((double)-10948.015625), (Object)((UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply()).getBigInteger());
        b.set(1.0000152587890626E20);
        Assertions.assertEquals((Object)Types.uint64((double)1.0000152587890626E20), (Object)((UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply()).getBigInteger());
    }

    @Test
    public void testCfloat64ToUint64() {
        ComplexDoubleType b = new ComplexDoubleType(9087.0, 879542.125);
        UnsignedLongType result = (UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply();
        Assertions.assertEquals((Object)Types.uint64((double)9087.0), (Object)result.getBigInteger());
        b.set(0.0, 0.0);
        Assertions.assertEquals((Object)Types.uint64((double)0.0), (Object)((UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply()).getBigInteger());
        b.set(-234.25, -9.0);
        Assertions.assertEquals((Object)Types.uint64((double)-234.25), (Object)((UnsignedLongType)ops.op("convert.uint64").input((Object)b).outType(UnsignedLongType.class).apply()).getBigInteger());
    }

    @Test
    public void testBitToUint128() {
        BitType b = new BitType(true);
        Unsigned128BitType result = (Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply();
        Assertions.assertEquals((Object)Types.uint128((long)1L), (Object)result.get());
        b.set(false);
        Assertions.assertEquals((Object)Types.uint128((long)0L), (Object)((Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply()).get());
    }

    @Test
    public void testUint2ToUint128() {
        Unsigned2BitType b = new Unsigned2BitType(2L);
        Unsigned128BitType result = (Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply();
        Assertions.assertEquals((Object)Types.uint128((long)2L), (Object)result.get());
        b.set(0L);
        Assertions.assertEquals((Object)Types.uint128((long)0L), (Object)((Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply()).get());
    }

    @Test
    public void testUint4ToUint128() {
        Unsigned4BitType b = new Unsigned4BitType(15L);
        Unsigned128BitType result = (Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply();
        Assertions.assertEquals((Object)Types.uint128((long)15L), (Object)result.get());
        b.set(0L);
        Assertions.assertEquals((Object)Types.uint128((long)0L), (Object)((Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply()).get());
    }

    @Test
    public void testInt8ToUint128() {
        ByteType b = new ByteType(8);
        Unsigned128BitType result = (Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply();
        Assertions.assertEquals((Object)Types.uint128((long)8L), (Object)result.get());
        b.set((byte)0);
        Assertions.assertEquals((Object)Types.uint128((long)0L), (Object)((Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply()).get());
        b.set((byte)-12);
        Assertions.assertEquals((Object)Types.uint128((long)-12L), (Object)((Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply()).get());
    }

    @Test
    public void testUint8ToUint128() {
        UnsignedByteType b = new UnsignedByteType(100);
        Unsigned128BitType result = (Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply();
        Assertions.assertEquals((Object)Types.uint128((long)100L), (Object)result.get());
        b.set(0);
        Assertions.assertEquals((Object)Types.uint128((long)0L), (Object)((Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply()).get());
    }

    @Test
    public void testUint12ToUint128() {
        Unsigned12BitType b = new Unsigned12BitType(212L);
        Unsigned128BitType result = (Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply();
        Assertions.assertEquals((Object)Types.uint128((long)212L), (Object)result.get());
        b.set(0L);
        Assertions.assertEquals((Object)Types.uint128((long)0L), (Object)((Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply()).get());
    }

    @Test
    public void testInt16ToUint128() {
        ShortType b = new ShortType(52);
        Unsigned128BitType result = (Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply();
        Assertions.assertEquals((Object)Types.uint128((long)52L), (Object)result.get());
        b.set((short)0);
        Assertions.assertEquals((Object)Types.uint128((long)0L), (Object)((Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply()).get());
        b.set((short)-154);
        Assertions.assertEquals((Object)Types.uint128((long)-154L), (Object)((Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply()).get());
    }

    @Test
    public void testUint16ToUint128() {
        UnsignedShortType b = new UnsignedShortType(480);
        Unsigned128BitType result = (Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply();
        Assertions.assertEquals((Object)Types.uint128((long)480L), (Object)result.get());
        b.set(0);
        Assertions.assertEquals((Object)Types.uint128((long)0L), (Object)((Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply()).get());
    }

    @Test
    public void testInt32ToUint128() {
        IntType b = new IntType(301);
        Unsigned128BitType result = (Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply();
        Assertions.assertEquals((Object)Types.uint128((long)301L), (Object)result.get());
        b.set(0);
        Assertions.assertEquals((Object)Types.uint128((long)0L), (Object)((Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply()).get());
        b.set(-89);
        Assertions.assertEquals((Object)Types.uint128((long)-89L), (Object)((Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply()).get());
    }

    @Test
    public void testUint32ToUint128() {
        UnsignedIntType b = new UnsignedIntType(20L);
        Unsigned128BitType result = (Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply();
        Assertions.assertEquals((Object)Types.uint128((long)20L), (Object)result.get());
        b.set(0L);
        Assertions.assertEquals((Object)Types.uint128((long)0L), (Object)((Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply()).get());
    }

    @Test
    public void testInt64ToUint128() {
        LongType b = new LongType(891L);
        Unsigned128BitType result = (Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply();
        Assertions.assertEquals((Object)Types.uint128((long)891L), (Object)result.get());
        b.set(0L);
        Assertions.assertEquals((Object)Types.uint128((long)0L), (Object)((Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply()).get());
        b.set(-1024L);
        Assertions.assertEquals((Object)Types.uint128((long)-1024L), (Object)((Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply()).get());
    }

    @Test
    public void testUint64ToUint128() {
        UnsignedLongType b = new UnsignedLongType(1049L);
        Unsigned128BitType result = (Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply();
        Assertions.assertEquals((Object)Types.uint128((long)1049L), (Object)result.get());
        b.set(0L);
        Assertions.assertEquals((Object)Types.uint128((long)0L), (Object)((Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply()).get());
        b.set(this.p64);
        Assertions.assertEquals((Object)Types.uint64Uint128((BigInteger)this.p64), (Object)((Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply()).getBigInteger());
    }

    @Test
    public void testUint128ToUint128() {
        Unsigned128BitType b = new Unsigned128BitType(this.beef);
        Unsigned128BitType result = (Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply();
        Assertions.assertEquals((Object)Types.uint128((BigInteger)this.beef), (Object)result.get());
        b.set(this.biZero);
        Assertions.assertEquals((Object)Types.uint128((BigInteger)this.biZero), (Object)((Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply()).get());
        b.set(this.p128);
        Assertions.assertEquals((Object)Types.uint128((BigInteger)this.p128), (Object)((Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply()).get());
    }

    @Test
    public void testFloat32ToUint128() {
        FloatType b = new FloatType(123453.125f);
        Unsigned128BitType result = (Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply();
        Assertions.assertEquals((Object)Types.uint128((double)123453.125), (Object)result.get());
        b.set(0.0f);
        Assertions.assertEquals((Object)Types.uint128((double)0.0), (Object)((Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply()).get());
        b.set(-2.5234854E12f);
        Assertions.assertEquals((Object)Types.uint128((double)-2.523485437952E12), (Object)((Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply()).get());
    }

    @Test
    public void testCfloat32ToUint128() {
        ComplexFloatType b = new ComplexFloatType(5839.25f, 120.0f);
        Unsigned128BitType result = (Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply();
        Assertions.assertEquals((Object)Types.uint128((double)5839.25), (Object)result.get());
        b.set(0.0f, 0.0f);
        Assertions.assertEquals((Object)Types.uint128((double)0.0), (Object)((Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply()).get());
        b.set(-4.25f, -123.0625f);
        Assertions.assertEquals((Object)Types.uint128((double)-4.25), (Object)((Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply()).get());
    }

    @Test
    public void testFloat64ToUint128() {
        DoubleType b = new DoubleType(4098.0);
        Unsigned128BitType result = (Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply();
        Assertions.assertEquals((Object)Types.uint128((double)4098.0), (Object)result.get());
        b.set(0.0);
        Assertions.assertEquals((Object)Types.uint128((double)0.0), (Object)((Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply()).get());
        b.set(-10948.015625);
        Assertions.assertEquals((Object)Types.uint128((double)-10948.015625), (Object)((Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply()).get());
        b.set(1.0000152587890626E20);
        Assertions.assertEquals((Object)Types.uint128((double)1.0000152587890626E20), (Object)((Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply()).get());
    }

    @Test
    public void testCfloat64ToUint128() {
        ComplexDoubleType b = new ComplexDoubleType(9087.0, 879542.125);
        Unsigned128BitType result = (Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply();
        Assertions.assertEquals((Object)Types.uint128((double)9087.0), (Object)result.get());
        b.set(0.0, 0.0);
        Assertions.assertEquals((Object)Types.uint128((double)0.0), (Object)((Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply()).get());
        b.set(-234.25, -9.0);
        Assertions.assertEquals((Object)Types.uint128((double)-234.25), (Object)((Unsigned128BitType)ops.op("convert.uint128").input((Object)b).outType(Unsigned128BitType.class).apply()).get());
    }

    @Test
    public void testBitToFloat32() {
        BitType b = new BitType(true);
        FloatType result = (FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply();
        Assertions.assertEquals((float)Types.float32((long)1L), (float)result.get(), (float)0.0f);
        b.set(false);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply()).get(), (float)0.0f);
    }

    @Test
    public void testUint2ToFloat32() {
        Unsigned2BitType b = new Unsigned2BitType(2L);
        FloatType result = (FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply();
        Assertions.assertEquals((float)Types.float32((long)2L), (float)result.get(), (float)0.0f);
        b.set(0L);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply()).get(), (float)0.0f);
    }

    @Test
    public void testUint4ToFloat32() {
        Unsigned4BitType b = new Unsigned4BitType(15L);
        FloatType result = (FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply();
        Assertions.assertEquals((float)Types.float32((long)15L), (float)result.get(), (float)0.0f);
        b.set(0L);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply()).get(), (float)0.0f);
    }

    @Test
    public void testInt8ToFloat32() {
        ByteType b = new ByteType(8);
        FloatType result = (FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply();
        Assertions.assertEquals((float)Types.float32((long)8L), (float)result.get(), (float)0.0f);
        b.set((byte)0);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply()).get(), (float)0.0f);
        b.set((byte)-12);
        Assertions.assertEquals((float)Types.float32((long)-12L), (float)((FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply()).get(), (float)0.0f);
    }

    @Test
    public void testUint8ToFloat32() {
        UnsignedByteType b = new UnsignedByteType(100);
        FloatType result = (FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply();
        Assertions.assertEquals((float)Types.float32((long)100L), (float)result.get(), (float)0.0f);
        b.set(0);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply()).get(), (float)0.0f);
    }

    @Test
    public void testUint12ToFloat32() {
        Unsigned12BitType b = new Unsigned12BitType(212L);
        FloatType result = (FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply();
        Assertions.assertEquals((float)Types.float32((long)212L), (float)result.get(), (float)0.0f);
        b.set(0L);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply()).get(), (float)0.0f);
    }

    @Test
    public void testInt16ToFloat32() {
        ShortType b = new ShortType(52);
        FloatType result = (FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply();
        Assertions.assertEquals((float)Types.float32((long)52L), (float)result.get(), (float)0.0f);
        b.set((short)0);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply()).get(), (float)0.0f);
        b.set((short)-154);
        Assertions.assertEquals((float)Types.float32((long)-154L), (float)((FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply()).get(), (float)0.0f);
    }

    @Test
    public void testUint16ToFloat32() {
        UnsignedShortType b = new UnsignedShortType(480);
        FloatType result = (FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply();
        Assertions.assertEquals((float)Types.float32((long)480L), (float)result.get(), (float)0.0f);
        b.set(0);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply()).get(), (float)0.0f);
    }

    @Test
    public void testInt32ToFloat32() {
        IntType b = new IntType(301);
        FloatType result = (FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply();
        Assertions.assertEquals((float)Types.float32((long)301L), (float)result.get(), (float)0.0f);
        b.set(0);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply()).get(), (float)0.0f);
        b.set(-89);
        Assertions.assertEquals((float)Types.float32((long)-89L), (float)((FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply()).get(), (float)0.0f);
    }

    @Test
    public void testUint32ToFloat32() {
        UnsignedIntType b = new UnsignedIntType(20L);
        FloatType result = (FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply();
        Assertions.assertEquals((float)Types.float32((long)20L), (float)result.get(), (float)0.0f);
        b.set(0L);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply()).get(), (float)0.0f);
    }

    @Test
    public void testInt64ToFloat32() {
        LongType b = new LongType(891L);
        FloatType result = (FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply();
        Assertions.assertEquals((float)Types.float32((long)891L), (float)result.get(), (float)0.0f);
        b.set(0L);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply()).get(), (float)0.0f);
        b.set(-1024L);
        Assertions.assertEquals((float)Types.float32((long)-1024L), (float)((FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply()).get(), (float)0.0f);
    }

    @Test
    public void testUint64ToFloat32() {
        UnsignedLongType b = new UnsignedLongType(1049L);
        FloatType result = (FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply();
        Assertions.assertEquals((float)Types.float32((long)1049L), (float)result.get(), (float)0.0f);
        b.set(0L);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply()).get(), (float)0.0f);
        b.set(this.p64);
        Assertions.assertEquals((float)Types.float32((BigInteger)this.p64), (float)((FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply()).get(), (float)0.0f);
    }

    @Test
    public void testUint128ToFloat32() {
        Unsigned128BitType b = new Unsigned128BitType(this.beef);
        FloatType result = (FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply();
        Assertions.assertEquals((float)Types.float32((BigInteger)this.beef), (float)result.get(), (float)0.0f);
        b.set(this.biZero);
        Assertions.assertEquals((float)Types.float32((BigInteger)this.biZero), (float)((FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply()).get(), (float)0.0f);
        b.set(this.p128);
        Assertions.assertEquals((float)Types.float32((BigInteger)this.p128), (float)((FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply()).get(), (float)0.0f);
    }

    @Test
    public void testFloat32ToFloat32() {
        FloatType b = new FloatType(123453.125f);
        FloatType result = (FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply();
        Assertions.assertEquals((float)Types.float32((double)123453.125), (float)result.get(), (float)0.0f);
        b.set(0.0f);
        Assertions.assertEquals((float)Types.float32((double)0.0), (float)((FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply()).get(), (float)0.0f);
        b.set(-2.5234854E12f);
        Assertions.assertEquals((float)Types.float32((double)-2.523485437952E12), (float)((FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply()).get(), (float)0.0f);
    }

    @Test
    public void testCfloat32ToFloat32() {
        ComplexFloatType b = new ComplexFloatType(5839.25f, 120.0f);
        FloatType result = (FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply();
        Assertions.assertEquals((float)Types.float32((double)5839.25), (float)result.get(), (float)0.0f);
        b.set(0.0f, 0.0f);
        Assertions.assertEquals((float)Types.float32((double)0.0), (float)((FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply()).get(), (float)0.0f);
        b.set(-4.25f, -123.0625f);
        Assertions.assertEquals((float)Types.float32((double)-4.25), (float)((FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply()).get(), (float)0.0f);
    }

    @Test
    public void testFloat64ToFloat32() {
        DoubleType b = new DoubleType(4098.0);
        FloatType result = (FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply();
        Assertions.assertEquals((float)Types.float32((double)4098.0), (float)result.get(), (float)0.0f);
        b.set(0.0);
        Assertions.assertEquals((float)Types.float32((double)0.0), (float)((FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply()).get(), (float)0.0f);
        b.set(-10948.015625);
        Assertions.assertEquals((float)Types.float32((double)-10948.015625), (float)((FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply()).get(), (float)0.0f);
        b.set(1.0000152587890626E20);
        Assertions.assertEquals((float)Types.float32((double)1.0000152587890626E20), (float)((FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply()).get(), (float)0.0f);
    }

    @Test
    public void testCfloat64ToFloat32() {
        ComplexDoubleType b = new ComplexDoubleType(9087.0, 879542.125);
        FloatType result = (FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply();
        Assertions.assertEquals((float)Types.float32((double)9087.0), (float)result.get(), (float)0.0f);
        b.set(0.0, 0.0);
        Assertions.assertEquals((float)Types.float32((double)0.0), (float)((FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply()).get(), (float)0.0f);
        b.set(-234.25, -9.0);
        Assertions.assertEquals((float)Types.float32((double)-234.25), (float)((FloatType)ops.op("convert.float32").input((Object)b).outType(FloatType.class).apply()).get(), (float)0.0f);
    }

    @Test
    public void testBitToCfloat32() {
        BitType b = new BitType(true);
        ComplexFloatType result = (ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply();
        Assertions.assertEquals((float)Types.float32((long)1L), (float)result.getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)result.getImaginaryFloat(), (float)0.0f);
        b.set(false);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getImaginaryFloat(), (float)0.0f);
    }

    @Test
    public void testUint2ToCfloat32() {
        Unsigned2BitType b = new Unsigned2BitType(2L);
        ComplexFloatType result = (ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply();
        Assertions.assertEquals((float)Types.float32((long)2L), (float)result.getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)result.getImaginaryFloat(), (float)0.0f);
        b.set(0L);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getImaginaryFloat(), (float)0.0f);
    }

    @Test
    public void testUint4ToCfloat32() {
        Unsigned4BitType b = new Unsigned4BitType(15L);
        ComplexFloatType result = (ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply();
        Assertions.assertEquals((float)Types.float32((long)15L), (float)result.getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)result.getImaginaryFloat(), (float)0.0f);
        b.set(0L);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getImaginaryFloat(), (float)0.0f);
    }

    @Test
    public void testInt8ToCfloat32() {
        ByteType b = new ByteType(8);
        ComplexFloatType result = (ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply();
        Assertions.assertEquals((float)Types.float32((long)8L), (float)result.getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)result.getImaginaryFloat(), (float)0.0f);
        b.set((byte)0);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getImaginaryFloat(), (float)0.0f);
        b.set((byte)-12);
        Assertions.assertEquals((float)Types.float32((long)-12L), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getImaginaryFloat(), (float)0.0f);
    }

    @Test
    public void testUint8ToCfloat32() {
        UnsignedByteType b = new UnsignedByteType(100);
        ComplexFloatType result = (ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply();
        Assertions.assertEquals((float)Types.float32((long)100L), (float)result.getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)result.getImaginaryFloat(), (float)0.0f);
        b.set(0);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getImaginaryFloat(), (float)0.0f);
    }

    @Test
    public void testUint12ToCfloat32() {
        Unsigned12BitType b = new Unsigned12BitType(212L);
        ComplexFloatType result = (ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply();
        Assertions.assertEquals((float)Types.float32((long)212L), (float)result.getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)result.getImaginaryFloat(), (float)0.0f);
        b.set(0L);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getImaginaryFloat(), (float)0.0f);
    }

    @Test
    public void testInt16ToCfloat32() {
        ShortType b = new ShortType(52);
        ComplexFloatType result = (ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply();
        Assertions.assertEquals((float)Types.float32((long)52L), (float)result.getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)result.getImaginaryFloat(), (float)0.0f);
        b.set((short)0);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getImaginaryFloat(), (float)0.0f);
        b.set((short)-154);
        Assertions.assertEquals((float)Types.float32((long)-154L), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getImaginaryFloat(), (float)0.0f);
    }

    @Test
    public void testUint16ToCfloat32() {
        UnsignedShortType b = new UnsignedShortType(480);
        ComplexFloatType result = (ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply();
        Assertions.assertEquals((float)Types.float32((long)480L), (float)result.getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)result.getImaginaryFloat(), (float)0.0f);
        b.set(0);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getImaginaryFloat(), (float)0.0f);
    }

    @Test
    public void testInt32ToCfloat32() {
        IntType b = new IntType(301);
        ComplexFloatType result = (ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply();
        Assertions.assertEquals((float)Types.float32((long)301L), (float)result.getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)result.getImaginaryFloat(), (float)0.0f);
        b.set(0);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getImaginaryFloat(), (float)0.0f);
        b.set(-89);
        Assertions.assertEquals((float)Types.float32((long)-89L), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getImaginaryFloat(), (float)0.0f);
    }

    @Test
    public void testUint32ToCfloat32() {
        UnsignedIntType b = new UnsignedIntType(20L);
        ComplexFloatType result = (ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply();
        Assertions.assertEquals((float)Types.float32((long)20L), (float)result.getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)result.getImaginaryFloat(), (float)0.0f);
        b.set(0L);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getImaginaryFloat(), (float)0.0f);
    }

    @Test
    public void testInt64ToCfloat32() {
        LongType b = new LongType(891L);
        ComplexFloatType result = (ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply();
        Assertions.assertEquals((float)Types.float32((long)891L), (float)result.getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)result.getImaginaryFloat(), (float)0.0f);
        b.set(0L);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getImaginaryFloat(), (float)0.0f);
        b.set(-1024L);
        Assertions.assertEquals((float)Types.float32((long)-1024L), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getImaginaryFloat(), (float)0.0f);
    }

    @Test
    public void testUint64ToCfloat32() {
        UnsignedLongType b = new UnsignedLongType(1049L);
        ComplexFloatType result = (ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply();
        Assertions.assertEquals((float)Types.float32((long)1049L), (float)result.getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)result.getImaginaryFloat(), (float)0.0f);
        b.set(0L);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getImaginaryFloat(), (float)0.0f);
        b.set(this.p64);
        Assertions.assertEquals((float)Types.float32((BigInteger)this.p64), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getImaginaryFloat(), (float)0.0f);
    }

    @Test
    public void testUint128ToCfloat32() {
        Unsigned128BitType b = new Unsigned128BitType(this.beef);
        ComplexFloatType result = (ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply();
        Assertions.assertEquals((float)Types.float32((BigInteger)this.beef), (float)result.getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((BigInteger)this.biZero), (float)result.getImaginaryFloat(), (float)0.0f);
        b.set(this.biZero);
        Assertions.assertEquals((float)Types.float32((BigInteger)this.biZero), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((BigInteger)this.biZero), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getImaginaryFloat(), (float)0.0f);
        b.set(this.p128);
        Assertions.assertEquals((float)Types.float32((BigInteger)this.p128), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((BigInteger)this.biZero), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getImaginaryFloat(), (float)0.0f);
    }

    @Test
    public void testFloat32ToCfloat32() {
        FloatType b = new FloatType(123453.125f);
        ComplexFloatType result = (ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply();
        Assertions.assertEquals((float)Types.float32((double)123453.125), (float)result.getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((double)0.0), (float)result.getImaginaryFloat(), (float)0.0f);
        b.set(0.0f);
        Assertions.assertEquals((float)Types.float32((double)0.0), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((double)0.0), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getImaginaryFloat(), (float)0.0f);
        b.set(-2.5234854E12f);
        Assertions.assertEquals((float)Types.float32((double)-2.523485437952E12), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((double)0.0), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getImaginaryFloat(), (float)0.0f);
    }

    @Test
    public void testCfloat32ToCfloat32() {
        ComplexFloatType b = new ComplexFloatType(5839.25f, 120.0f);
        ComplexFloatType result = (ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply();
        Assertions.assertEquals((float)Types.float32((double)5839.25), (float)result.getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((double)120.0), (float)result.getImaginaryFloat(), (float)0.0f);
        b.set(0.0f, 0.0f);
        Assertions.assertEquals((float)Types.float32((double)0.0), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((double)0.0), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getImaginaryFloat(), (float)0.0f);
        b.set(-4.25f, -123.0625f);
        Assertions.assertEquals((float)Types.float32((double)-4.25), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((double)-123.0625), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getImaginaryFloat(), (float)0.0f);
    }

    @Test
    public void testFloat64ToCfloat32() {
        DoubleType b = new DoubleType(4098.0);
        ComplexFloatType result = (ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply();
        Assertions.assertEquals((float)Types.float32((double)4098.0), (float)result.getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((double)0.0), (float)result.getImaginaryFloat(), (float)0.0f);
        b.set(0.0);
        Assertions.assertEquals((float)Types.float32((double)0.0), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((double)0.0), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getImaginaryFloat(), (float)0.0f);
        b.set(-10948.015625);
        Assertions.assertEquals((float)Types.float32((double)-10948.015625), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((double)0.0), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getImaginaryFloat(), (float)0.0f);
        b.set(1.0000152587890626E20);
        Assertions.assertEquals((float)Types.float32((double)1.0000152587890626E20), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getImaginaryFloat(), (float)0.0f);
    }

    @Test
    public void testCfloat64ToCfloat32() {
        ComplexDoubleType b = new ComplexDoubleType(9087.0, 879542.125);
        ComplexFloatType result = (ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply();
        Assertions.assertEquals((float)Types.float32((double)9087.0), (float)result.getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((double)879542.125), (float)result.getImaginaryFloat(), (float)0.0f);
        b.set(0.0, 0.0);
        Assertions.assertEquals((float)Types.float32((double)0.0), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((double)0.0), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getImaginaryFloat(), (float)0.0f);
        b.set(-234.25, -9.0);
        Assertions.assertEquals((float)Types.float32((double)-234.25), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getRealFloat(), (float)0.0f);
        Assertions.assertEquals((float)Types.float32((double)-9.0), (float)((ComplexFloatType)ops.op("convert.cfloat32").input((Object)b).outType(ComplexFloatType.class).apply()).getImaginaryFloat(), (float)0.0f);
    }

    @Test
    public void testBitToFloat64() {
        BitType b = new BitType(true);
        DoubleType result = (DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply();
        Assertions.assertEquals((double)Types.float64((long)1L), (double)result.get(), (double)0.0);
        b.set(false);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply()).get(), (double)0.0);
    }

    @Test
    public void testUint2ToFloat64() {
        Unsigned2BitType b = new Unsigned2BitType(2L);
        DoubleType result = (DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply();
        Assertions.assertEquals((double)Types.float64((long)2L), (double)result.get(), (double)0.0);
        b.set(0L);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply()).get(), (double)0.0);
    }

    @Test
    public void testUint4ToFloat64() {
        Unsigned4BitType b = new Unsigned4BitType(15L);
        DoubleType result = (DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply();
        Assertions.assertEquals((double)Types.float64((long)15L), (double)result.get(), (double)0.0);
        b.set(0L);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply()).get(), (double)0.0);
    }

    @Test
    public void testInt8ToFloat64() {
        ByteType b = new ByteType(8);
        DoubleType result = (DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply();
        Assertions.assertEquals((double)Types.float64((long)8L), (double)result.get(), (double)0.0);
        b.set((byte)0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply()).get(), (double)0.0);
        b.set((byte)-12);
        Assertions.assertEquals((double)Types.float64((long)-12L), (double)((DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply()).get(), (double)0.0);
    }

    @Test
    public void testUint8ToFloat64() {
        UnsignedByteType b = new UnsignedByteType(100);
        DoubleType result = (DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply();
        Assertions.assertEquals((double)Types.float64((long)100L), (double)result.get(), (double)0.0);
        b.set(0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply()).get(), (double)0.0);
    }

    @Test
    public void testUint12ToFloat64() {
        Unsigned12BitType b = new Unsigned12BitType(212L);
        DoubleType result = (DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply();
        Assertions.assertEquals((double)Types.float64((long)212L), (double)result.get(), (double)0.0);
        b.set(0L);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply()).get(), (double)0.0);
    }

    @Test
    public void testInt16ToFloat64() {
        ShortType b = new ShortType(52);
        DoubleType result = (DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply();
        Assertions.assertEquals((double)Types.float64((long)52L), (double)result.get(), (double)0.0);
        b.set((short)0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply()).get(), (double)0.0);
        b.set((short)-154);
        Assertions.assertEquals((double)Types.float64((long)-154L), (double)((DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply()).get(), (double)0.0);
    }

    @Test
    public void testUint16ToFloat64() {
        UnsignedShortType b = new UnsignedShortType(480);
        DoubleType result = (DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply();
        Assertions.assertEquals((double)Types.float64((long)480L), (double)result.get(), (double)0.0);
        b.set(0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply()).get(), (double)0.0);
    }

    @Test
    public void testInt32ToFloat64() {
        IntType b = new IntType(301);
        DoubleType result = (DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply();
        Assertions.assertEquals((double)Types.float64((long)301L), (double)result.get(), (double)0.0);
        b.set(0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply()).get(), (double)0.0);
        b.set(-89);
        Assertions.assertEquals((double)Types.float64((long)-89L), (double)((DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply()).get(), (double)0.0);
    }

    @Test
    public void testUint32ToFloat64() {
        UnsignedIntType b = new UnsignedIntType(20L);
        DoubleType result = (DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply();
        Assertions.assertEquals((double)Types.float64((long)20L), (double)result.get(), (double)0.0);
        b.set(0L);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply()).get(), (double)0.0);
    }

    @Test
    public void testInt64ToFloat64() {
        LongType b = new LongType(891L);
        DoubleType result = (DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply();
        Assertions.assertEquals((double)Types.float64((long)891L), (double)result.get(), (double)0.0);
        b.set(0L);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply()).get(), (double)0.0);
        b.set(-1024L);
        Assertions.assertEquals((double)Types.float64((long)-1024L), (double)((DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply()).get(), (double)0.0);
    }

    @Test
    public void testUint64ToFloat64() {
        UnsignedLongType b = new UnsignedLongType(1049L);
        DoubleType result = (DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply();
        Assertions.assertEquals((double)Types.float64((long)1049L), (double)result.get(), (double)0.0);
        b.set(0L);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply()).get(), (double)0.0);
        b.set(this.p64);
        Assertions.assertEquals((double)Types.float64((BigInteger)this.p64), (double)((DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply()).get(), (double)0.0);
    }

    @Test
    public void testUint128ToFloat64() {
        Unsigned128BitType b = new Unsigned128BitType(this.beef);
        DoubleType result = (DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply();
        Assertions.assertEquals((double)Types.float64((BigInteger)this.beef), (double)result.get(), (double)0.0);
        b.set(this.biZero);
        Assertions.assertEquals((double)Types.float64((BigInteger)this.biZero), (double)((DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply()).get(), (double)0.0);
        b.set(this.p128);
        Assertions.assertEquals((double)Types.float64((BigInteger)this.p128), (double)((DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply()).get(), (double)0.0);
    }

    @Test
    public void testFloat32ToFloat64() {
        FloatType b = new FloatType(123453.125f);
        DoubleType result = (DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply();
        Assertions.assertEquals((double)Types.float64((double)123453.125), (double)result.get(), (double)0.0);
        b.set(0.0f);
        Assertions.assertEquals((double)Types.float64((double)0.0), (double)((DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply()).get(), (double)0.0);
        b.set(-2.5234854E12f);
        Assertions.assertEquals((double)Types.float64((double)-2.523485437952E12), (double)((DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply()).get(), (double)0.0);
    }

    @Test
    public void testCfloat32ToFloat64() {
        ComplexFloatType b = new ComplexFloatType(5839.25f, 120.0f);
        DoubleType result = (DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply();
        Assertions.assertEquals((double)Types.float64((double)5839.25), (double)result.get(), (double)0.0);
        b.set(0.0f, 0.0f);
        Assertions.assertEquals((double)Types.float64((double)0.0), (double)((DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply()).get(), (double)0.0);
        b.set(-4.25f, -123.0625f);
        Assertions.assertEquals((double)Types.float64((double)-4.25), (double)((DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply()).get(), (double)0.0);
    }

    @Test
    public void testFloat64ToFloat64() {
        DoubleType b = new DoubleType(4098.0);
        DoubleType result = (DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply();
        Assertions.assertEquals((double)Types.float64((double)4098.0), (double)result.get(), (double)0.0);
        b.set(0.0);
        Assertions.assertEquals((double)Types.float64((double)0.0), (double)((DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply()).get(), (double)0.0);
        b.set(-10948.015625);
        Assertions.assertEquals((double)Types.float64((double)-10948.015625), (double)((DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply()).get(), (double)0.0);
        b.set(1.0000152587890626E20);
        Assertions.assertEquals((double)Types.float64((double)1.0000152587890626E20), (double)((DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply()).get(), (double)0.0);
    }

    @Test
    public void testCfloat64ToFloat64() {
        ComplexDoubleType b = new ComplexDoubleType(9087.0, 879542.125);
        DoubleType result = (DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply();
        Assertions.assertEquals((double)Types.float64((double)9087.0), (double)result.get(), (double)0.0);
        b.set(0.0, 0.0);
        Assertions.assertEquals((double)Types.float64((double)0.0), (double)((DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply()).get(), (double)0.0);
        b.set(-234.25, -9.0);
        Assertions.assertEquals((double)Types.float64((double)-234.25), (double)((DoubleType)ops.op("convert.float64").input((Object)b).outType(DoubleType.class).apply()).get(), (double)0.0);
    }

    @Test
    public void testBitToCfloat64() {
        BitType b = new BitType(true);
        ComplexDoubleType result = (ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply();
        Assertions.assertEquals((double)Types.float64((long)1L), (double)result.getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)result.getImaginaryDouble(), (double)0.0);
        b.set(false);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getImaginaryDouble(), (double)0.0);
    }

    @Test
    public void testUint2ToCfloat64() {
        Unsigned2BitType b = new Unsigned2BitType(2L);
        ComplexDoubleType result = (ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply();
        Assertions.assertEquals((double)Types.float64((long)2L), (double)result.getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)result.getImaginaryDouble(), (double)0.0);
        b.set(0L);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getImaginaryDouble(), (double)0.0);
    }

    @Test
    public void testUint4ToCfloat64() {
        Unsigned4BitType b = new Unsigned4BitType(15L);
        ComplexDoubleType result = (ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply();
        Assertions.assertEquals((double)Types.float64((long)15L), (double)result.getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)result.getImaginaryDouble(), (double)0.0);
        b.set(0L);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getImaginaryDouble(), (double)0.0);
    }

    @Test
    public void testInt8ToCfloat64() {
        ByteType b = new ByteType(8);
        ComplexDoubleType result = (ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply();
        Assertions.assertEquals((double)Types.float64((long)8L), (double)result.getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)result.getImaginaryDouble(), (double)0.0);
        b.set((byte)0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getImaginaryDouble(), (double)0.0);
        b.set((byte)-12);
        Assertions.assertEquals((double)Types.float64((long)-12L), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getImaginaryDouble(), (double)0.0);
    }

    @Test
    public void testUint8ToCfloat64() {
        UnsignedByteType b = new UnsignedByteType(100);
        ComplexDoubleType result = (ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply();
        Assertions.assertEquals((double)Types.float64((long)100L), (double)result.getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)result.getImaginaryDouble(), (double)0.0);
        b.set(0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getImaginaryDouble(), (double)0.0);
    }

    @Test
    public void testUint12ToCfloat64() {
        Unsigned12BitType b = new Unsigned12BitType(212L);
        ComplexDoubleType result = (ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply();
        Assertions.assertEquals((double)Types.float64((long)212L), (double)result.getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)result.getImaginaryDouble(), (double)0.0);
        b.set(0L);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getImaginaryDouble(), (double)0.0);
    }

    @Test
    public void testInt16ToCfloat64() {
        ShortType b = new ShortType(52);
        ComplexDoubleType result = (ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply();
        Assertions.assertEquals((double)Types.float64((long)52L), (double)result.getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)result.getImaginaryDouble(), (double)0.0);
        b.set((short)0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getImaginaryDouble(), (double)0.0);
        b.set((short)-154);
        Assertions.assertEquals((double)Types.float64((long)-154L), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getImaginaryDouble(), (double)0.0);
    }

    @Test
    public void testUint16ToCfloat64() {
        UnsignedShortType b = new UnsignedShortType(480);
        ComplexDoubleType result = (ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply();
        Assertions.assertEquals((double)Types.float64((long)480L), (double)result.getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)result.getImaginaryDouble(), (double)0.0);
        b.set(0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getImaginaryDouble(), (double)0.0);
    }

    @Test
    public void testInt32ToCfloat64() {
        IntType b = new IntType(301);
        ComplexDoubleType result = (ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply();
        Assertions.assertEquals((double)Types.float64((long)301L), (double)result.getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)result.getImaginaryDouble(), (double)0.0);
        b.set(0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getImaginaryDouble(), (double)0.0);
        b.set(-89);
        Assertions.assertEquals((double)Types.float64((long)-89L), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getImaginaryDouble(), (double)0.0);
    }

    @Test
    public void testUint32ToCfloat64() {
        UnsignedIntType b = new UnsignedIntType(20L);
        ComplexDoubleType result = (ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply();
        Assertions.assertEquals((double)Types.float64((long)20L), (double)result.getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)result.getImaginaryDouble(), (double)0.0);
        b.set(0L);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getImaginaryDouble(), (double)0.0);
    }

    @Test
    public void testInt64ToCfloat64() {
        LongType b = new LongType(891L);
        ComplexDoubleType result = (ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply();
        Assertions.assertEquals((double)Types.float64((long)891L), (double)result.getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)result.getImaginaryDouble(), (double)0.0);
        b.set(0L);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getImaginaryDouble(), (double)0.0);
        b.set(-1024L);
        Assertions.assertEquals((double)Types.float64((long)-1024L), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getImaginaryDouble(), (double)0.0);
    }

    @Test
    public void testUint64ToCfloat64() {
        UnsignedLongType b = new UnsignedLongType(1049L);
        ComplexDoubleType result = (ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply();
        Assertions.assertEquals((double)Types.float64((long)1049L), (double)result.getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)result.getImaginaryDouble(), (double)0.0);
        b.set(0L);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getImaginaryDouble(), (double)0.0);
        b.set(this.p64);
        Assertions.assertEquals((double)Types.float64((BigInteger)this.p64), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getImaginaryDouble(), (double)0.0);
    }

    @Test
    public void testUint128ToCfloat64() {
        Unsigned128BitType b = new Unsigned128BitType(this.beef);
        ComplexDoubleType result = (ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply();
        Assertions.assertEquals((double)Types.float64((BigInteger)this.beef), (double)result.getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((BigInteger)this.biZero), (double)result.getImaginaryDouble(), (double)0.0);
        b.set(this.biZero);
        Assertions.assertEquals((double)Types.float64((BigInteger)this.biZero), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((BigInteger)this.biZero), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getImaginaryDouble(), (double)0.0);
        b.set(this.p128);
        Assertions.assertEquals((double)Types.float64((BigInteger)this.p128), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((BigInteger)this.biZero), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getImaginaryDouble(), (double)0.0);
    }

    @Test
    public void testFloat32ToCfloat64() {
        FloatType b = new FloatType(123453.125f);
        ComplexDoubleType result = (ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply();
        Assertions.assertEquals((double)Types.float64((double)123453.125), (double)result.getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((double)0.0), (double)result.getImaginaryDouble(), (double)0.0);
        b.set(0.0f);
        Assertions.assertEquals((double)Types.float64((double)0.0), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((double)0.0), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getImaginaryDouble(), (double)0.0);
        b.set(-2.5234854E12f);
        Assertions.assertEquals((double)Types.float64((double)-2.523485437952E12), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((double)0.0), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getImaginaryDouble(), (double)0.0);
    }

    @Test
    public void testCfloat32ToCfloat64() {
        ComplexFloatType b = new ComplexFloatType(5839.25f, 120.0f);
        ComplexDoubleType result = (ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply();
        Assertions.assertEquals((double)Types.float64((double)5839.25), (double)result.getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((double)120.0), (double)result.getImaginaryDouble(), (double)0.0);
        b.set(0.0f, 0.0f);
        Assertions.assertEquals((double)Types.float64((double)0.0), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((double)0.0), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getImaginaryDouble(), (double)0.0);
        b.set(-4.25f, -123.0625f);
        Assertions.assertEquals((double)Types.float64((double)-4.25), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((double)-123.0625), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getImaginaryDouble(), (double)0.0);
    }

    @Test
    public void testFloat64ToCfloat64() {
        DoubleType b = new DoubleType(4098.0);
        ComplexDoubleType result = (ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply();
        Assertions.assertEquals((double)Types.float64((double)4098.0), (double)result.getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((double)0.0), (double)result.getImaginaryDouble(), (double)0.0);
        b.set(0.0);
        Assertions.assertEquals((double)Types.float64((double)0.0), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((double)0.0), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getImaginaryDouble(), (double)0.0);
        b.set(-10948.015625);
        Assertions.assertEquals((double)Types.float64((double)-10948.015625), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((double)0.0), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getImaginaryDouble(), (double)0.0);
        b.set(1.0000152587890626E20);
        Assertions.assertEquals((double)Types.float64((double)1.0000152587890626E20), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getImaginaryDouble(), (double)0.0);
    }

    @Test
    public void testCfloat64ToCfloat64() {
        ComplexDoubleType b = new ComplexDoubleType(9087.0, 879542.125);
        ComplexDoubleType result = (ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply();
        Assertions.assertEquals((double)Types.float64((double)9087.0), (double)result.getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((double)879542.125), (double)result.getImaginaryDouble(), (double)0.0);
        b.set(0.0, 0.0);
        Assertions.assertEquals((double)Types.float64((double)0.0), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((double)0.0), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getImaginaryDouble(), (double)0.0);
        b.set(-234.25, -9.0);
        Assertions.assertEquals((double)Types.float64((double)-234.25), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)Types.float64((double)-9.0), (double)((ComplexDoubleType)ops.op("convert.cfloat64").input((Object)b).outType(ComplexDoubleType.class).apply()).getImaginaryDouble(), (double)0.0);
    }
}

