/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.copy;

import net.imglib2.Cursor;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.real.DoubleType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;
import org.scijava.util.MersenneTwisterFast;

public class CopyImgTest
extends AbstractOpTest {
    private Img<DoubleType> input;

    @BeforeEach
    public void createData() {
        this.input = new ArrayImgFactory((NativeType)new DoubleType()).create(new int[]{120, 100});
        MersenneTwisterFast r = new MersenneTwisterFast(System.currentTimeMillis());
        Cursor inc = this.input.cursor();
        while (inc.hasNext()) {
            ((DoubleType)inc.next()).set(r.nextDouble());
        }
    }

    @Test
    public void testCopyImgNoOutput() {
        Img inputCopy = this.input.factory().create(this.input, (Object)((DoubleType)this.input.firstElement()));
        this.copy(this.input, (Img<DoubleType>)inputCopy);
        RandomAccessibleInterval output = (RandomAccessibleInterval)ops.op("copy.img").input(this.input).outType((Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){}).apply();
        Cursor inc = this.input.localizingCursor();
        RandomAccess inCopyRA = inputCopy.randomAccess();
        RandomAccess outRA = output.randomAccess();
        while (inc.hasNext()) {
            inc.fwd();
            inCopyRA.setPosition((Localizable)inc);
            outRA.setPosition((Localizable)inc);
            Assertions.assertEquals((double)((DoubleType)inc.get()).get(), (double)((DoubleType)outRA.get()).get(), (double)0.0);
            Assertions.assertEquals((double)((DoubleType)inc.get()).get(), (double)((DoubleType)inCopyRA.get()).get(), (double)0.0);
        }
    }

    @Test
    public void testCopyImgWithOutput() {
        Img inputCopy = this.input.factory().create(this.input, (Object)((DoubleType)this.input.firstElement()));
        this.copy(this.input, (Img<DoubleType>)inputCopy);
        Img output = this.input.factory().create(this.input, (Object)((DoubleType)this.input.firstElement()));
        ops.op("copy.img").input(this.input).output((Object)output).compute();
        Cursor inc = this.input.cursor();
        Cursor inCopyc = inputCopy.cursor();
        Cursor outc = output.cursor();
        while (inc.hasNext()) {
            Assertions.assertEquals((double)((DoubleType)inc.next()).get(), (double)((DoubleType)outc.next()).get(), (double)0.0);
            Assertions.assertEquals((double)((DoubleType)inc.get()).get(), (double)((DoubleType)inCopyc.next()).get(), (double)0.0);
        }
    }

    private void copy(Img<DoubleType> from, Img<DoubleType> to) {
        Cursor fromc = from.cursor();
        Cursor toc = to.cursor();
        while (fromc.hasNext()) {
            ((DoubleType)toc.next()).set(((DoubleType)fromc.next()).get());
        }
    }
}

