/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.copy;

import net.imglib2.Cursor;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayCursor;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.array.ArrayLocalizingCursor;
import net.imglib2.img.cell.CellCursor;
import net.imglib2.img.cell.CellImg;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.img.cell.CellLocalizingCursor;
import net.imglib2.img.planar.PlanarCursor;
import net.imglib2.img.planar.PlanarImg;
import net.imglib2.img.planar.PlanarImgFactory;
import net.imglib2.img.planar.PlanarLocalizingCursor;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.util.MersenneTwisterFast;

public class CopyImgsTest
extends AbstractOpTest {
    private <T extends RealType<T>> void populateData(Img<T> data) {
        MersenneTwisterFast r = new MersenneTwisterFast(System.currentTimeMillis());
        Cursor inc = data.cursor();
        while (inc.hasNext()) {
            ((RealType)inc.next()).setReal(r.nextDouble() * 255.0);
        }
    }

    @Test
    public void testCopyArrayImgNoOutput() {
        ArrayImg data = new ArrayImgFactory((NativeType)new UnsignedByteType()).create(new long[]{10L, 10L});
        this.populateData((Img)data);
        RandomAccessibleInterval output = (RandomAccessibleInterval)ops.op("copy.img").input((Object)data).apply();
        ArrayLocalizingCursor inc = data.localizingCursor();
        RandomAccess outRA = output.randomAccess();
        while (inc.hasNext()) {
            inc.fwd();
            outRA.setPosition((Localizable)inc);
            Assertions.assertEquals((int)((UnsignedByteType)inc.get()).get(), (int)((UnsignedByteType)outRA.get()).get());
        }
    }

    @Test
    public void testCopyArrayImgWithOutput() {
        ArrayImg data = new ArrayImgFactory((NativeType)new UnsignedByteType()).create(new long[]{10L, 10L});
        this.populateData((Img)data);
        ArrayImg output = data.factory().create(data.dimensionsAsLongArray());
        ops.op("copy.img").input((Object)data).output((Object)output).compute();
        ArrayCursor inc = data.cursor();
        Cursor outc = output.cursor();
        while (inc.hasNext()) {
            Assertions.assertEquals((Object)outc.next(), (Object)inc.next());
        }
    }

    @Test
    public void testCopyPlanarImgNoOutput() {
        PlanarImg data = new PlanarImgFactory((NativeType)new UnsignedByteType()).create(new long[]{10L, 10L});
        this.populateData((Img)data);
        RandomAccessibleInterval output = (RandomAccessibleInterval)ops.op("copy.img").input((Object)data).apply();
        PlanarLocalizingCursor inc = data.localizingCursor();
        RandomAccess outRA = output.randomAccess();
        while (inc.hasNext()) {
            inc.fwd();
            outRA.setPosition((Localizable)inc);
            Assertions.assertEquals((int)((UnsignedByteType)inc.get()).get(), (int)((UnsignedByteType)outRA.get()).get());
        }
    }

    @Test
    public void testCopyPlanarImgWithOutput() {
        PlanarImg data = new PlanarImgFactory((NativeType)new UnsignedByteType()).create(new long[]{10L, 10L});
        this.populateData((Img)data);
        PlanarImg output = data.factory().create(data.dimensionsAsLongArray());
        ops.op("copy.img").input((Object)data).output((Object)output).compute();
        PlanarCursor inc = data.cursor();
        Cursor outc = output.cursor();
        while (inc.hasNext()) {
            Assertions.assertEquals((Object)outc.next(), (Object)inc.next());
        }
    }

    @Test
    public void testCopyCellImgNoOutput() {
        CellImg data = new CellImgFactory((NativeType)new UnsignedByteType()).create(new long[]{10L, 10L});
        this.populateData((Img)data);
        RandomAccessibleInterval output = (RandomAccessibleInterval)ops.op("copy.img").input((Object)data).apply();
        CellLocalizingCursor inc = data.localizingCursor();
        RandomAccess outRA = output.randomAccess();
        while (inc.hasNext()) {
            inc.fwd();
            outRA.setPosition((Localizable)inc);
            Assertions.assertEquals((int)((UnsignedByteType)inc.get()).get(), (int)((UnsignedByteType)outRA.get()).get());
        }
    }

    @Test
    public void testCopyCellImgWithOutput() {
        CellImg data = new CellImgFactory((NativeType)new UnsignedByteType()).create(new long[]{10L, 10L});
        this.populateData((Img)data);
        Img output = data.factory().create(data.dimensionsAsLongArray());
        ops.op("copy.img").input((Object)data).output((Object)output).compute();
        CellCursor inc = data.cursor();
        Cursor outc = output.cursor();
        while (inc.hasNext()) {
            Assertions.assertEquals((Object)outc.next(), (Object)inc.next());
        }
    }
}

