/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.deconvolve;

import java.util.List;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.region.hypersphere.HyperSphere;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.outofbounds.OutOfBoundsConstantValueFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.complex.ComplexFloatType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.function.Computers;
import org.scijava.function.Functions;
import org.scijava.function.Inplaces;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;

public class DeconvolveTest
extends AbstractOpTest {
    @Test
    public void testDeconvolve() {
        int[] size = new int[]{225, 167};
        ArrayImg in = new ArrayImgFactory((NativeType)new FloatType()).create(size);
        this.placeSphereInCenter((Img<FloatType>)in);
        IntervalView incropped = Views.interval((RandomAccessible)in, (long[])new long[]{size[0] / 2, size[1] / 2}, (long[])new long[]{size[0] - 1, size[1] - 1});
        incropped = Views.zeroMin((RandomAccessibleInterval)incropped);
        RandomAccessibleInterval kernel = (RandomAccessibleInterval)ops.op("create.kernelGauss").input((Object)new double[]{4.0, 4.0}, (Object)new FloatType()).outType((Nil)new Nil<RandomAccessibleInterval<FloatType>>(){}).apply();
        RandomAccessibleInterval convolved = (RandomAccessibleInterval)ops.op("filter.convolve").input((Object)incropped, (Object)kernel, (Object)new FloatType(), (Object)new ComplexFloatType(), null, (Object)new OutOfBoundsConstantValueFactory((Object)new FloatType(0.0f))).outType((Nil)new Nil<RandomAccessibleInterval<FloatType>>(){}).apply();
        Functions.Arity9 deconvolveOp = (Functions.Arity9)ops.op("deconvolve.richardsonLucy", (Nil)new Nil<Functions.Arity9<RandomAccessibleInterval<FloatType>, RandomAccessibleInterval<FloatType>, FloatType, ComplexFloatType, Integer, Boolean, Boolean, long[], OutOfBoundsFactory<FloatType, RandomAccessibleInterval<FloatType>>, RandomAccessibleInterval<FloatType>>>(){}, new Nil[]{new Nil<RandomAccessibleInterval<FloatType>>(){}, new Nil<RandomAccessibleInterval<FloatType>>(){}, new Nil<FloatType>(){}, new Nil<ComplexFloatType>(){}, new Nil<Integer>(){}, new Nil<Boolean>(){}, new Nil<Boolean>(){}, new Nil<long[]>(){}, new Nil<OutOfBoundsFactory<FloatType, RandomAccessibleInterval<FloatType>>>(){}}, (Nil)new Nil<RandomAccessibleInterval<FloatType>>(){});
        RandomAccessibleInterval deconvolved = (RandomAccessibleInterval)deconvolveOp.apply((Object)convolved, (Object)kernel, (Object)new FloatType(), (Object)new ComplexFloatType(), (Object)10, (Object)false, (Object)false, null, (Object)new OutOfBoundsConstantValueFactory((Object)((FloatType)Util.getTypeFromInterval((Interval)in)).createVariable()));
        RandomAccessibleInterval deconvolved2 = (RandomAccessibleInterval)deconvolveOp.apply((Object)convolved, (Object)kernel, (Object)new FloatType(), (Object)new ComplexFloatType(), (Object)10, (Object)true, (Object)true, null, (Object)new OutOfBoundsConstantValueFactory((Object)((FloatType)Util.getTypeFromInterval((Interval)in)).createVariable()));
        Assertions.assertEquals((long)incropped.dimension(0), (long)deconvolved.dimension(0));
        Assertions.assertEquals((long)incropped.dimension(1), (long)deconvolved.dimension(1));
        Assertions.assertEquals((long)incropped.dimension(0), (long)deconvolved2.dimension(0));
        Assertions.assertEquals((long)incropped.dimension(1), (long)deconvolved2.dimension(1));
        Cursor deconvolvedCursor = Views.iterable((RandomAccessibleInterval)deconvolved).cursor();
        Cursor deconvolvedCursor2 = Views.iterable((RandomAccessibleInterval)deconvolved2).cursor();
        float[] deconvolvedValues = new float[]{3.6045982E-4f, 0.0016963598f, 0.0053468645f, 0.011868152f, 0.019616995f, 0.025637051f, 0.028158935f, 0.027555753f, 0.025289025f, 0.02266813f, 0.020409783f, 0.018752098f, 0.017683199f, 0.016951872f, 0.016685976f};
        float[] deconvolvedValues2 = new float[]{0.2630328f, 0.3163978f, 0.37502986f, 0.436034f, 0.4950426f, 0.5468085f, 0.58636993f, 0.6105018f, 0.6186566f, 0.61295974f, 0.59725416f, 0.575831f, 0.5524411f, 0.5307535f, 0.5109127f};
        for (int i = 0; i < deconvolvedValues.length; ++i) {
            Assertions.assertEquals((float)deconvolvedValues[i], (float)((FloatType)deconvolvedCursor.next()).get(), (float)0.0f);
            Assertions.assertEquals((float)deconvolvedValues2[i], (float)((FloatType)deconvolvedCursor2.next()).get(), (float)0.0f);
        }
        Computers.Arity12 deconvolveOpC = (Computers.Arity12)ops.op("deconvolve.richardsonLucy", (Nil)new Nil<Computers.Arity12<RandomAccessibleInterval<FloatType>, RandomAccessibleInterval<FloatType>, RandomAccessibleInterval<ComplexFloatType>, RandomAccessibleInterval<ComplexFloatType>, Boolean, Boolean, ComplexFloatType, Integer, Boolean, Computers.Arity1<RandomAccessibleInterval<FloatType>, RandomAccessibleInterval<FloatType>>, List<Inplaces.Arity1<RandomAccessibleInterval<FloatType>>>, RandomAccessibleInterval<FloatType>, RandomAccessibleInterval<FloatType>>>(){}, new Nil[]{new Nil<RandomAccessibleInterval<FloatType>>(){}, new Nil<RandomAccessibleInterval<FloatType>>(){}, new Nil<RandomAccessibleInterval<ComplexFloatType>>(){}, new Nil<RandomAccessibleInterval<ComplexFloatType>>(){}, new Nil<Boolean>(){}, new Nil<Boolean>(){}, new Nil<ComplexFloatType>(){}, new Nil<Integer>(){}, new Nil<Boolean>(){}, new Nil<Computers.Arity1<RandomAccessibleInterval<FloatType>, RandomAccessibleInterval<FloatType>>>(){}, new Nil<List<Inplaces.Arity1<RandomAccessibleInterval<FloatType>>>>(){}, new Nil<RandomAccessibleInterval<FloatType>>(){}, new Nil<RandomAccessibleInterval<FloatType>>(){}}, (Nil)new Nil<RandomAccessibleInterval<FloatType>>(){});
    }

    private void placeSphereInCenter(Img<FloatType> img) {
        Point center = new Point(img.numDimensions());
        for (int d = 0; d < img.numDimensions(); ++d) {
            center.setPosition(img.dimension(d) / 2L, d);
        }
        HyperSphere hyperSphere = new HyperSphere(img, (Localizable)center, 30L);
        for (FloatType value : hyperSphere) {
            value.setReal(1.0f);
        }
    }
}

