/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.features.haralick;

import net.imglib2.img.Img;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.real.DoubleType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.ops.image.image.cooccurrenceMatrix.MatrixOrientation2D;

public class HaralickFeatureTest
extends AbstractOpTest {
    private static final double EPSILON = 1.0E-9;
    private Img<UnsignedByteType> img;

    @BeforeEach
    public void loadImage() {
        this.img = HaralickFeatureTest.openRelativeUnsignedByteImg(AbstractOpTest.class, "features/haralick_test_img.tif");
    }

    @Test
    public void testAsm() {
        DoubleType asm = (DoubleType)ops.op("features.haralick.asm").input(this.img, (Object)128, (Object)1, (Object)MatrixOrientation2D.HORIZONTAL).apply();
        Assertions.assertEquals((double)0.002728531855956, (double)asm.get(), (double)1.0E-9);
    }

    @Test
    public void testClusterProminence() {
        DoubleType clusterProminence = (DoubleType)ops.op("features.haralick.clusterProminence").input(this.img, (Object)128, (Object)1, (Object)MatrixOrientation2D.HORIZONTAL).apply();
        Assertions.assertEquals((double)1.913756322645621E7, (double)clusterProminence.get(), (double)1.0E-9);
    }

    @Test
    public void testClusterShade() {
        DoubleType clusterShade = (DoubleType)ops.op("features.haralick.clusterShade").input(this.img, (Object)128, (Object)1, (Object)MatrixOrientation2D.HORIZONTAL).apply();
        Assertions.assertEquals((double)7909.331564367658, (double)clusterShade.get(), (double)1.0E-9);
    }

    @Test
    public void testContrast() {
        DoubleType contrast = (DoubleType)ops.op("features.haralick.contrast").input(this.img, (Object)128, (Object)1, (Object)MatrixOrientation2D.HORIZONTAL).apply();
        Assertions.assertEquals((double)2829.684210526314, (double)contrast.get(), (double)1.0E-9);
    }

    @Test
    public void testCorrelation() {
        DoubleType correlation = (DoubleType)ops.op("features.haralick.correlation").input(this.img, (Object)128, (Object)1, (Object)MatrixOrientation2D.HORIZONTAL).apply();
        Assertions.assertEquals((double)-0.006957913328178969, (double)correlation.get(), (double)1.0E-9);
    }

    @Test
    public void testDifferenceEntropy() {
        DoubleType entropy = (DoubleType)ops.op("features.haralick.differenceEntropy").input(this.img, (Object)128, (Object)1, (Object)MatrixOrientation2D.HORIZONTAL).apply();
        Assertions.assertEquals((double)4.51788636250983, (double)entropy.get(), (double)1.0E-9);
    }

    @Test
    public void testDifferenceVariance() {
        DoubleType variance = (DoubleType)ops.op("features.haralick.differenceVariance").input(this.img, (Object)128, (Object)1, (Object)MatrixOrientation2D.HORIZONTAL).apply();
        Assertions.assertEquals((double)888.5861218836561, (double)variance.get(), (double)1.0E-9);
    }

    @Test
    public void testEntropy() {
        DoubleType entropy = (DoubleType)ops.op("features.haralick.entropy").input(this.img, (Object)128, (Object)1, (Object)MatrixOrientation2D.HORIZONTAL).apply();
        Assertions.assertEquals((double)5.914634251331289, (double)entropy.get(), (double)1.0E-9);
    }

    @Test
    public void testICM1() {
        DoubleType icm1 = (DoubleType)ops.op("features.haralick.icm1").input(this.img, (Object)128, (Object)1, (Object)MatrixOrientation2D.HORIZONTAL).apply();
        Assertions.assertEquals((double)-1.138457766487823, (double)icm1.get(), (double)1.0E-9);
    }

    @Test
    public void testICM2() {
        DoubleType icm2 = (DoubleType)ops.op("features.haralick.icm2").input(this.img, (Object)128, (Object)1, (Object)MatrixOrientation2D.HORIZONTAL).apply();
        Assertions.assertEquals((double)0.9995136931858095, (double)icm2.get(), (double)1.0E-9);
    }

    @Test
    public void testIFDM() {
        DoubleType ifdm = (DoubleType)ops.op("features.haralick.ifdm").input(this.img, (Object)128, (Object)1, (Object)MatrixOrientation2D.HORIZONTAL).apply();
        Assertions.assertEquals((double)0.02630092221760193, (double)ifdm.get(), (double)1.0E-9);
    }

    @Test
    public void testMaxProbability() {
        DoubleType maxProb = (DoubleType)ops.op("features.haralick.maxProbability").input(this.img, (Object)128, (Object)1, (Object)MatrixOrientation2D.HORIZONTAL).apply();
        Assertions.assertEquals((double)0.005263157894737, (double)maxProb.get(), (double)1.0E-9);
    }

    @Test
    public void testSumAverage() {
        DoubleType sumAvg = (DoubleType)ops.op("features.haralick.sumAverage").input(this.img, (Object)128, (Object)1, (Object)MatrixOrientation2D.HORIZONTAL).apply();
        Assertions.assertEquals((double)124.421052631579, (double)sumAvg.get(), (double)1.0E-9);
    }

    @Test
    public void testSumEntropy() {
        DoubleType sumEntropy = (DoubleType)ops.op("features.haralick.sumEntropy").input(this.img, (Object)128, (Object)1, (Object)MatrixOrientation2D.HORIZONTAL).apply();
        Assertions.assertEquals((double)5.007751063919794, (double)sumEntropy.get(), (double)1.0E-9);
    }

    @Test
    public void testSumVariance() {
        DoubleType sumVariance = (DoubleType)ops.op("features.haralick.sumVariance").input(this.img, (Object)128, (Object)1, (Object)MatrixOrientation2D.HORIZONTAL).apply();
        Assertions.assertEquals((double)17050.10667439121, (double)sumVariance.get(), (double)1.0E-9);
    }

    @Test
    public void testTextureHomogeneity() {
        DoubleType homogeneity = (DoubleType)ops.op("features.haralick.textureHomogeneity").input(this.img, (Object)128, (Object)1, (Object)MatrixOrientation2D.HORIZONTAL).apply();
        Assertions.assertEquals((double)0.06192918510695, (double)homogeneity.get(), (double)1.0E-9);
    }

    @Test
    public void testVariance() {
        DoubleType variance = (DoubleType)ops.op("features.haralick.variance").input(this.img, (Object)128, (Object)1, (Object)MatrixOrientation2D.HORIZONTAL).apply();
        Assertions.assertEquals((double)5176.653047585449, (double)variance.get(), (double)1.0E-9);
    }
}

