/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.features.hog;

import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.real.FloatType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;

public class HistogramOfOrientedGradients2DTest
extends AbstractOpTest {
    private static final double EPSILON = 1.0E-5;

    @Test
    public void test() {
        Img<FloatType> hogTestImg = this.openFloatImg("HoG2DResult.tif");
        Img<FloatType> hogInputImg = this.openFloatImg("HoG2DInput.png");
        RandomAccessibleInterval hogOp = (RandomAccessibleInterval)ops.op("features.hog").input(hogInputImg, (Object)9, (Object)2).outType((Nil)new Nil<RandomAccessibleInterval<FloatType>>(){}).apply();
        RandomAccess raOp = hogOp.randomAccess();
        RandomAccess raTest = hogTestImg.randomAccess();
        Assertions.assertEquals((int)hogTestImg.numDimensions(), (int)hogOp.numDimensions());
        Assertions.assertEquals((long)hogTestImg.dimension(0), (long)hogOp.dimension(0));
        Assertions.assertEquals((long)hogTestImg.dimension(1), (long)hogOp.dimension(1));
        Assertions.assertEquals((long)hogTestImg.dimension(2), (long)hogOp.dimension(2));
        int i = 0;
        while ((long)i < hogTestImg.dimension(0)) {
            int j = 0;
            while ((long)j < hogTestImg.dimension(1)) {
                int k = 0;
                while ((long)k < hogTestImg.dimension(2)) {
                    raTest.setPosition(new long[]{i, j, k});
                    raOp.setPosition(new long[]{i, j, k});
                    Assertions.assertEquals((double)((FloatType)raTest.get()).getRealFloat(), (double)((FloatType)raOp.get()).getRealFloat(), (double)1.0E-5, (String)("i=" + i + ", j=" + j + ", k=" + k));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }
}

