/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.image.integral;

import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhood;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.type.numeric.integer.ByteType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.image.integral.IntegralCursor;

public class IntegralCursorTest {
    protected ArrayImg<ByteType, ByteArray> img;

    @BeforeEach
    public void setUp() throws Exception {
        this.img = this.generateKnownByteArrayTestImg();
    }

    @Test
    public void testIntegralCursor() {
        RectangleShape rectangleShape = new RectangleShape(1, false);
        IterableInterval ii = rectangleShape.neighborhoodsSafe(this.img);
        Cursor cursor = ii.cursor();
        cursor.fwd();
        cursor.fwd();
        cursor.fwd();
        cursor.fwd();
        cursor.fwd();
        IntegralCursor integralCursor = new IntegralCursor((RectangleNeighborhood)cursor.get());
        Assertions.assertEquals((Object)integralCursor.next(), (Object)new ByteType(1));
        Assertions.assertEquals((Object)integralCursor.next(), (Object)new ByteType(2));
        Assertions.assertEquals((Object)integralCursor.next(), (Object)new ByteType(5));
        Assertions.assertEquals((Object)integralCursor.next(), (Object)new ByteType(4));
        Assertions.assertFalse((boolean)integralCursor.hasNext());
        integralCursor.reset();
        Assertions.assertEquals((Object)integralCursor.next(), (Object)new ByteType(1));
        Assertions.assertEquals((Object)integralCursor.next(), (Object)new ByteType(2));
        Assertions.assertEquals((Object)integralCursor.next(), (Object)new ByteType(5));
        Assertions.assertEquals((Object)integralCursor.next(), (Object)new ByteType(4));
        Assertions.assertFalse((boolean)integralCursor.hasNext());
    }

    @Test
    public void testIntegralCursorCopyConstructor() {
        RectangleShape rectangleShape = new RectangleShape(1, false);
        IterableInterval ii = rectangleShape.neighborhoodsSafe(this.img);
        Cursor cursor = ii.cursor();
        cursor.fwd();
        cursor.fwd();
        cursor.fwd();
        cursor.fwd();
        cursor.fwd();
        IntegralCursor integralCursor = new IntegralCursor((RectangleNeighborhood)cursor.get());
        Assertions.assertEquals((Object)integralCursor.next(), (Object)new ByteType(1));
        Assertions.assertEquals((Object)integralCursor.next(), (Object)new ByteType(2));
        IntegralCursor integralCursor2 = new IntegralCursor(integralCursor);
        Assertions.assertEquals((Object)integralCursor2.next(), (Object)new ByteType(5));
        Assertions.assertEquals((Object)integralCursor2.next(), (Object)new ByteType(4));
        Assertions.assertFalse((boolean)integralCursor2.hasNext());
    }

    public ArrayImg<ByteType, ByteArray> generateKnownByteArrayTestImg() {
        long[] dims = new long[]{3L, 3L};
        byte[] array = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        return ArrayImgs.bytes((byte[])array, (long[])dims);
    }
}

