/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.image.normalize;

import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.util.Pair;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.ops.image.util.TestImgGeneration;
import org.scijava.types.Nil;

public class NormalizeTest
extends AbstractOpTest {
    @Test
    public void testNormalize() {
        ArrayImg<ByteType, ByteArray> in = TestImgGeneration.byteArray(true, 5L, 5L);
        Img out = in.factory().create(in, (Object)new ByteType());
        ops.op("image.normalize").input(in).output((Object)out).compute();
        Pair minMax = (Pair)ops.op("stats.minMax").input(in).outType((Nil)new Nil<Pair<ByteType, ByteType>>(){}).apply();
        Pair minMax2 = (Pair)ops.op("stats.minMax").input((Object)out).outType((Nil)new Nil<Pair<ByteType, ByteType>>(){}).apply();
        Assertions.assertEquals((byte)((ByteType)minMax2.getA()).get(), (byte)-128);
        Assertions.assertEquals((byte)((ByteType)minMax2.getB()).get(), (byte)127);
        ByteType min = new ByteType((byte)((ByteType)in.firstElement()).getMinValue());
        ByteType max = new ByteType((byte)((ByteType)in.firstElement()).getMaxValue());
        RandomAccessibleInterval lazyOut = (RandomAccessibleInterval)ops.op("image.normalize").input(in).outType((Nil)new Nil<RandomAccessibleInterval<ByteType>>(){}).apply();
        RandomAccessibleInterval notLazyOut = (RandomAccessibleInterval)ops.op("image.normalize").input(in, (Object)((ByteType)minMax.getA()), (Object)((ByteType)minMax.getB()), (Object)min, (Object)max).outType((Nil)new Nil<RandomAccessibleInterval<ByteType>>(){}).apply();
        Cursor outCursor = out.cursor();
        Cursor lazyCursor = Views.flatIterable((RandomAccessibleInterval)lazyOut).cursor();
        Cursor notLazyCursor = Views.flatIterable((RandomAccessibleInterval)notLazyOut).cursor();
        while (outCursor.hasNext()) {
            Assertions.assertEquals((byte)((ByteType)outCursor.next()).get(), (byte)((ByteType)lazyCursor.next()).get());
            Assertions.assertEquals((byte)((ByteType)outCursor.get()).get(), (byte)((ByteType)notLazyCursor.next()).get());
        }
    }
}

