/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.image.watershed;

import net.imglib2.Cursor;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.roi.labeling.ImgLabeling;
import net.imglib2.roi.labeling.LabelingType;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.ops.image.image.watershed.WatershedTest;
import org.scijava.types.Nil;

public class WatershedBinaryTest
extends AbstractOpTest {
    @Test
    public void test() {
        Img<FloatType> watershedTestImg = WatershedBinaryTest.openRelativeFloatImg(WatershedTest.class, "watershed_test_image.png");
        RandomAccessibleInterval thresholdedImg = (RandomAccessibleInterval)ops.op("create.img").input(watershedTestImg, (Object)new BitType()).outType((Nil)new Nil<RandomAccessibleInterval<BitType>>(){}).apply();
        ops.op("threshold.apply").input((Object)Views.flatIterable(watershedTestImg), (Object)new FloatType(1.0f)).output((Object)Views.flatIterable((RandomAccessibleInterval)thresholdedImg)).compute();
        RandomAccessibleInterval distMap = (RandomAccessibleInterval)ops.op("create.img").input((Object)thresholdedImg, (Object)new FloatType()).outType((Nil)new Nil<RandomAccessibleInterval<FloatType>>(){}).apply();
        ops.op("image.distanceTransform").input((Object)thresholdedImg).output((Object)distMap).compute();
        RandomAccessibleInterval invertedDistMap = (RandomAccessibleInterval)ops.op("create.img").input((Object)distMap, (Object)new FloatType()).outType((Nil)new Nil<RandomAccessibleInterval<FloatType>>(){}).apply();
        double[] sigma = new double[]{3.0, 3.0, 0.0};
        ops.op("image.invert").input((Object)distMap).output((Object)invertedDistMap).compute();
        RandomAccessibleInterval gauss = (RandomAccessibleInterval)ops.op("create.img").input((Object)invertedDistMap, (Object)new FloatType()).outType((Nil)new Nil<RandomAccessibleInterval<FloatType>>(){}).apply();
        ops.op("filter.gauss").input((Object)invertedDistMap, (Object)new double[]{sigma[0], sigma[1]}).output((Object)gauss).compute();
        ImgLabeling out1 = (ImgLabeling)ops.op("image.watershed").input((Object)thresholdedImg, (Object)true, (Object)false, (Object)sigma, (Object)thresholdedImg).outType((Nil)new Nil<ImgLabeling<Integer, IntType>>(){}).apply();
        ImgLabeling expOut1 = (ImgLabeling)ops.op("image.watershed").input((Object)gauss, (Object)true, (Object)false, (Object)thresholdedImg).outType((Nil)new Nil<ImgLabeling<Integer, IntType>>(){}).apply();
        this.assertResults((ImgLabeling<Integer, IntType>)expOut1, (ImgLabeling<Integer, IntType>)out1);
        ImgLabeling out2 = (ImgLabeling)ops.op("image.watershed").input((Object)thresholdedImg, (Object)true, (Object)false, (Object)sigma).outType((Nil)new Nil<ImgLabeling<Integer, IntType>>(){}).apply();
        ImgLabeling expOut2 = (ImgLabeling)ops.op("image.watershed").input((Object)gauss, (Object)true, (Object)false).outType((Nil)new Nil<ImgLabeling<Integer, IntType>>(){}).apply();
        this.assertResults((ImgLabeling<Integer, IntType>)expOut2, (ImgLabeling<Integer, IntType>)out2);
        ImgLabeling out3 = (ImgLabeling)ops.op("image.watershed").input((Object)thresholdedImg, (Object)true, (Object)true, (Object)sigma, (Object)thresholdedImg).outType((Nil)new Nil<ImgLabeling<Integer, IntType>>(){}).apply();
        ImgLabeling expOut3 = (ImgLabeling)ops.op("image.watershed").input((Object)gauss, (Object)true, (Object)true, (Object)thresholdedImg).outType((Nil)new Nil<ImgLabeling<Integer, IntType>>(){}).apply();
        this.assertResults((ImgLabeling<Integer, IntType>)expOut3, (ImgLabeling<Integer, IntType>)out3);
        ImgLabeling out4 = (ImgLabeling)ops.op("image.watershed").input((Object)thresholdedImg, (Object)true, (Object)true, (Object)sigma).outType((Nil)new Nil<ImgLabeling<Integer, IntType>>(){}).apply();
        ImgLabeling expOut4 = (ImgLabeling)ops.op("image.watershed").input((Object)gauss, (Object)true, (Object)true).outType((Nil)new Nil<ImgLabeling<Integer, IntType>>(){}).apply();
        this.assertResults((ImgLabeling<Integer, IntType>)expOut4, (ImgLabeling<Integer, IntType>)out4);
        ImgLabeling out5 = (ImgLabeling)ops.op("image.watershed").input((Object)thresholdedImg, (Object)false, (Object)true, (Object)sigma, (Object)thresholdedImg).outType((Nil)new Nil<ImgLabeling<Integer, IntType>>(){}).apply();
        ImgLabeling expOut5 = (ImgLabeling)ops.op("image.watershed").input((Object)gauss, (Object)false, (Object)true, (Object)thresholdedImg).outType((Nil)new Nil<ImgLabeling<Integer, IntType>>(){}).apply();
        this.assertResults((ImgLabeling<Integer, IntType>)expOut5, (ImgLabeling<Integer, IntType>)out5);
        ImgLabeling out6 = (ImgLabeling)ops.op("image.watershed").input((Object)thresholdedImg, (Object)false, (Object)true, (Object)sigma).outType((Nil)new Nil<ImgLabeling<Integer, IntType>>(){}).apply();
        ImgLabeling expOut6 = (ImgLabeling)ops.op("image.watershed").input((Object)gauss, (Object)false, (Object)true).outType((Nil)new Nil<ImgLabeling<Integer, IntType>>(){}).apply();
        this.assertResults((ImgLabeling<Integer, IntType>)expOut6, (ImgLabeling<Integer, IntType>)out6);
    }

    private void assertResults(ImgLabeling<Integer, IntType> expOut, ImgLabeling<Integer, IntType> out) {
        Cursor expOutCursor = expOut.cursor();
        RandomAccess raOut = out.randomAccess();
        while (expOutCursor.hasNext()) {
            expOutCursor.fwd();
            raOut.setPosition((Localizable)expOutCursor);
            Assertions.assertEquals((int)((LabelingType)expOutCursor.get()).size(), (int)((LabelingType)raOut.get()).size());
            if (((LabelingType)expOutCursor.get()).size() <= 0) continue;
            Assertions.assertEquals((Integer)((Integer)((LabelingType)expOutCursor.get()).iterator().next()), (Integer)((Integer)((LabelingType)raOut.get()).iterator().next()));
        }
    }
}

