/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.labeling;

import net.imglib2.FinalInterval;
import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.roi.labeling.ImgLabeling;
import net.imglib2.roi.labeling.LabelingType;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.integer.ByteType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;

public class MergeLabelingTest
extends AbstractOpTest {
    private ImgLabeling<Integer, ByteType> in1;
    private ImgLabeling<Integer, ByteType> in2;
    private ImgLabeling<Integer, ByteType> out;

    @BeforeEach
    public void setUp() {
        this.in1 = (ImgLabeling)ops.op("create.imgLabeling").input((Object)new FinalInterval(new long[]{2L, 2L}), (Object)new ByteType()).outType((Nil)new Nil<ImgLabeling<Integer, ByteType>>(){}).apply();
        RandomAccess randomAccess = this.in1.randomAccess();
        randomAccess.setPosition(new int[]{0, 0});
        ((LabelingType)randomAccess.get()).add((Object)0);
        randomAccess.setPosition(new int[]{0, 1});
        ((LabelingType)randomAccess.get()).add((Object)1);
        randomAccess.setPosition(new int[]{1, 0});
        ((LabelingType)randomAccess.get()).add((Object)2);
        randomAccess.setPosition(new int[]{1, 1});
        ((LabelingType)randomAccess.get()).add((Object)3);
        this.in2 = (ImgLabeling)ops.op("create.imgLabeling").input((Object)new FinalInterval(new long[]{2L, 2L}), (Object)new ByteType()).outType((Nil)new Nil<ImgLabeling<Integer, ByteType>>(){}).apply();
        randomAccess = this.in2.randomAccess();
        randomAccess.setPosition(new int[]{0, 0});
        ((LabelingType)randomAccess.get()).add((Object)10);
        randomAccess.setPosition(new int[]{0, 1});
        ((LabelingType)randomAccess.get()).add((Object)11);
        randomAccess.setPosition(new int[]{1, 0});
        ((LabelingType)randomAccess.get()).add((Object)12);
        randomAccess.setPosition(new int[]{1, 1});
        ((LabelingType)randomAccess.get()).add((Object)13);
        this.out = (ImgLabeling)ops.op("create.imgLabeling").input((Object)new FinalInterval(new long[]{2L, 2L}), (Object)new ByteType()).outType((Nil)new Nil<ImgLabeling<Integer, ByteType>>(){}).apply();
    }

    @Test
    public void testMerging() {
        ImgLabeling run = (ImgLabeling)ops.op("labeling.merge").input(this.in1, this.in2).outType((Nil)new Nil<ImgLabeling<Integer, ByteType>>(){}).apply();
        Assertions.assertTrue((boolean)run.firstElement().contains((Object)0));
        Assertions.assertTrue((boolean)run.firstElement().contains((Object)10));
        Assertions.assertTrue((!run.firstElement().contains((Object)3) ? 1 : 0) != 0);
    }

    @Test
    public void testMask() {
        Img mask = (Img)ops.op("create.img").input(this.in1, (Object)new BitType()).outType((Nil)new Nil<Img<BitType>>(){}).apply();
        RandomAccess maskRA = mask.randomAccess();
        maskRA.setPosition(new int[]{0, 0});
        ((BitType)maskRA.get()).set(true);
        maskRA.setPosition(new int[]{1, 1});
        ((BitType)maskRA.get()).set(true);
        this.out = (ImgLabeling)ops.op("labeling.merge").input(this.in1, this.in2, (Object)mask).outType((Nil)new Nil<ImgLabeling<Integer, ByteType>>(){}).apply();
        RandomAccess outRA = this.out.randomAccess();
        outRA.setPosition(new int[]{0, 0});
        Assertions.assertTrue((boolean)((LabelingType)outRA.get()).contains((Object)0));
        Assertions.assertTrue((boolean)((LabelingType)outRA.get()).contains((Object)10));
        outRA.setPosition(new int[]{0, 1});
        Assertions.assertTrue((boolean)((LabelingType)outRA.get()).isEmpty());
    }
}

