/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.map.neighborhood;

import java.util.Iterator;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.integer.ByteType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.scijava.function.Computers;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.ops.image.util.TestImgGeneration;

public class MapNeighborhoodTest
extends AbstractOpTest {
    private Img<ByteType> in;
    private Img<ByteType> out;

    @BeforeEach
    public void initImg() {
        this.in = TestImgGeneration.byteArray(true, 11L, 10L);
        this.out = TestImgGeneration.byteArray(false, 11L, 10L);
    }

    @Test
    public void testMapNeighborhoodsAccess() {
        ops.op("map.neighborhood").input(this.in, (Object)new RectangleShape(1, false), (Object)new CountNeighbors()).output(this.out).compute();
        for (ByteType t : this.out) {
            Assertions.assertEquals((int)9, (int)t.get());
        }
    }

    private static class Increment
    implements Computers.Arity1<ByteType, ByteType> {
        private Increment() {
        }

        public void compute(ByteType input, ByteType output) {
            output.set((byte)(input.get() + 1));
        }
    }

    private static class CountNeighborsWithCenter
    implements Computers.Arity2<Iterable<ByteType>, ByteType, ByteType> {
        private CountNeighborsWithCenter() {
        }

        public void compute(Iterable<ByteType> neighborhood, ByteType center, ByteType output) {
            ByteType a = center;
            a.set((byte)0);
            output.set((byte)0);
            Iterator<ByteType> iter = neighborhood.iterator();
            while (iter.hasNext()) {
                output.inc();
                a.inc();
                iter.next();
            }
        }
    }

    private static class CountNeighbors
    implements Computers.Arity1<Iterable<ByteType>, ByteType> {
        private CountNeighbors() {
        }

        public void compute(Iterable<ByteType> input, ByteType output) {
            Iterator<ByteType> iter = input.iterator();
            while (iter.hasNext()) {
                output.inc();
                iter.next();
            }
        }
    }
}

