/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.threshold.apply;

import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.util.Pair;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.scijava.function.Computers;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.ops.image.util.TestImgGeneration;
import org.scijava.types.Nil;

public class LocalThresholdTest
extends AbstractOpTest {
    Img<ByteType> in;
    Img<DoubleType> normalizedIn;
    Img<BitType> out;

    @BeforeEach
    public void before() throws Exception {
        this.in = TestImgGeneration.byteArray(true, 10L, 10L);
        Pair minMax = (Pair)ops.op("stats.minMax").input(this.in).outType((Nil)new Nil<Pair<ByteType, ByteType>>(){}).apply();
        this.normalizedIn = (Img)ops.op("create.img").input(this.in, (Object)new DoubleType()).outType((Nil)new Nil<Img<DoubleType>>(){}).apply();
        ops.op("image.normalize").input(this.in, (Object)((ByteType)minMax.getA()), (Object)((ByteType)minMax.getB()), (Object)new DoubleType(0.0), (Object)new DoubleType(1.0)).output(this.normalizedIn).compute();
        this.out = this.in.factory().imgFactory((Object)new BitType()).create(this.in, (Object)new BitType());
    }

    @Test
    public void testLocalBernsenThreshold() {
        Computers.Arity5 opToTest = OpBuilder.matchComputer((OpEnvironment)ops, (String)"threshold.localBernsen", (Nil)new Nil<RandomAccessibleInterval<ByteType>>(){}, (Nil)new Nil<Shape>(){}, (Nil)new Nil<Double>(){}, (Nil)new Nil<Double>(){}, (Nil)new Nil<OutOfBoundsFactory<ByteType, RandomAccessibleInterval<ByteType>>>(){}, (Nil)new Nil<RandomAccessibleInterval<BitType>>(){});
        opToTest.compute(this.in, (Object)new RectangleShape(3, false), (Object)1.0, (Object)8.988465674311579E307, (Object)new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE), this.out);
        Assertions.assertEquals((Object)true, (Object)((BitType)this.out.firstElement()).get());
    }

    @Test
    public void testLocalContrastThreshold() {
        Computers.Arity3 opToTest = OpBuilder.matchComputer((OpEnvironment)ops, (String)"threshold.localContrast", (Nil)new Nil<RandomAccessibleInterval<ByteType>>(){}, (Nil)new Nil<Shape>(){}, (Nil)new Nil<OutOfBoundsFactory<ByteType, RandomAccessibleInterval<ByteType>>>(){}, (Nil)new Nil<RandomAccessibleInterval<BitType>>(){});
        opToTest.compute(this.in, (Object)new RectangleShape(3, false), (Object)new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE), this.out);
        Assertions.assertEquals((Object)false, (Object)((BitType)this.out.firstElement()).get());
    }

    @Test
    public void testLocalHuangThreshold() {
        Computers.Arity3 opToTest = OpBuilder.matchComputer((OpEnvironment)ops, (String)"threshold.huang", (Nil)new Nil<RandomAccessibleInterval<ByteType>>(){}, (Nil)new Nil<Shape>(){}, (Nil)new Nil<OutOfBoundsFactory<ByteType, RandomAccessibleInterval<ByteType>>>(){}, (Nil)new Nil<RandomAccessibleInterval<BitType>>(){});
        opToTest.compute(this.in, (Object)new RectangleShape(1, false), (Object)new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE), this.out);
        Assertions.assertEquals((Object)true, (Object)((BitType)this.out.firstElement()).get());
    }

    @Test
    public void testLocalIJ1Threshold() {
        Computers.Arity3 opToTest = OpBuilder.matchComputer((OpEnvironment)ops, (String)"threshold.ij1", (Nil)new Nil<RandomAccessibleInterval<ByteType>>(){}, (Nil)new Nil<Shape>(){}, (Nil)new Nil<OutOfBoundsFactory<ByteType, RandomAccessibleInterval<ByteType>>>(){}, (Nil)new Nil<RandomAccessibleInterval<BitType>>(){});
        opToTest.compute(this.in, (Object)new RectangleShape(1, false), (Object)new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE), this.out);
        Assertions.assertEquals((Object)true, (Object)((BitType)this.out.firstElement()).get());
    }

    @Test
    public void testLocalIntermodesThreshold() {
        Computers.Arity3 opToTest = OpBuilder.matchComputer((OpEnvironment)ops, (String)"threshold.intermodes", (Nil)new Nil<RandomAccessibleInterval<ByteType>>(){}, (Nil)new Nil<Shape>(){}, (Nil)new Nil<OutOfBoundsFactory<ByteType, RandomAccessibleInterval<ByteType>>>(){}, (Nil)new Nil<RandomAccessibleInterval<BitType>>(){});
        opToTest.compute(this.in, (Object)new RectangleShape(1, false), (Object)new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE), this.out);
        Assertions.assertEquals((Object)true, (Object)((BitType)this.out.firstElement()).get());
    }

    @Test
    public void testLocalIsoDataThreshold() {
        Computers.Arity3 opToTest = OpBuilder.matchComputer((OpEnvironment)ops, (String)"threshold.isoData", (Nil)new Nil<RandomAccessibleInterval<ByteType>>(){}, (Nil)new Nil<Shape>(){}, (Nil)new Nil<OutOfBoundsFactory<ByteType, RandomAccessibleInterval<ByteType>>>(){}, (Nil)new Nil<RandomAccessibleInterval<BitType>>(){});
        opToTest.compute(this.in, (Object)new RectangleShape(2, false), (Object)new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE), this.out);
        Assertions.assertEquals((Object)true, (Object)((BitType)this.out.firstElement()).get());
    }

    @Test
    public void testLocalLiThreshold() {
        Computers.Arity3 opToTest = OpBuilder.matchComputer((OpEnvironment)ops, (String)"threshold.li", (Nil)new Nil<RandomAccessibleInterval<ByteType>>(){}, (Nil)new Nil<Shape>(){}, (Nil)new Nil<OutOfBoundsFactory<ByteType, RandomAccessibleInterval<ByteType>>>(){}, (Nil)new Nil<RandomAccessibleInterval<BitType>>(){});
        opToTest.compute(this.in, (Object)new RectangleShape(1, false), (Object)new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE), this.out);
        Assertions.assertEquals((Object)true, (Object)((BitType)this.out.firstElement()).get());
    }

    @Test
    public void testLocalMaxEntropyThreshold() {
        Computers.Arity3 opToTest = OpBuilder.matchComputer((OpEnvironment)ops, (String)"threshold.maxEntropy", (Nil)new Nil<RandomAccessibleInterval<ByteType>>(){}, (Nil)new Nil<Shape>(){}, (Nil)new Nil<OutOfBoundsFactory<ByteType, RandomAccessibleInterval<ByteType>>>(){}, (Nil)new Nil<RandomAccessibleInterval<BitType>>(){});
        opToTest.compute(this.in, (Object)new RectangleShape(1, false), (Object)new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE), this.out);
        Assertions.assertEquals((Object)true, (Object)((BitType)this.out.firstElement()).get());
    }

    @Test
    public void testLocalMaxLikelihoodThreshold() {
        Computers.Arity3 opToTest = OpBuilder.matchComputer((OpEnvironment)ops, (String)"threshold.maxLikelihood", (Nil)new Nil<RandomAccessibleInterval<ByteType>>(){}, (Nil)new Nil<Shape>(){}, (Nil)new Nil<OutOfBoundsFactory<ByteType, RandomAccessibleInterval<ByteType>>>(){}, (Nil)new Nil<RandomAccessibleInterval<BitType>>(){});
        opToTest.compute(this.in, (Object)new RectangleShape(3, false), (Object)new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE), this.out);
        Assertions.assertEquals((Object)true, (Object)((BitType)this.out.firstElement()).get());
    }

    @Test
    public void testLocalThresholdMean() {
        Computers.Arity4 opToTest = OpBuilder.matchComputer((OpEnvironment)ops, (String)"threshold.localMean", (Nil)new Nil<RandomAccessibleInterval<ByteType>>(){}, (Nil)new Nil<Shape>(){}, (Nil)new Nil<Double>(){}, (Nil)new Nil<OutOfBoundsFactory<ByteType, RandomAccessibleInterval<ByteType>>>(){}, (Nil)new Nil<RandomAccessibleInterval<BitType>>(){});
        opToTest.compute(this.in, (Object)new RectangleShape(1, false), (Object)0.0, (Object)new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE), this.out);
        Assertions.assertEquals((Object)true, (Object)((BitType)this.out.firstElement()).get());
    }

    @Test
    public void testLocalMedianThreshold() {
        Computers.Arity4 opToTest = OpBuilder.matchComputer((OpEnvironment)ops, (String)"threshold.localMedian", (Nil)new Nil<RandomAccessibleInterval<ByteType>>(){}, (Nil)new Nil<Shape>(){}, (Nil)new Nil<Double>(){}, (Nil)new Nil<OutOfBoundsFactory<ByteType, RandomAccessibleInterval<ByteType>>>(){}, (Nil)new Nil<RandomAccessibleInterval<BitType>>(){});
        opToTest.compute(this.in, (Object)new RectangleShape(3, false), (Object)0.0, (Object)new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE), this.out);
        Assertions.assertEquals((Object)true, (Object)((BitType)this.out.firstElement()).get());
    }

    @Test
    public void testLocalMidGreyThreshold() {
        Computers.Arity4 opToTest = OpBuilder.matchComputer((OpEnvironment)ops, (String)"threshold.localMidGrey", (Nil)new Nil<RandomAccessibleInterval<ByteType>>(){}, (Nil)new Nil<Shape>(){}, (Nil)new Nil<Double>(){}, (Nil)new Nil<OutOfBoundsFactory<ByteType, RandomAccessibleInterval<ByteType>>>(){}, (Nil)new Nil<RandomAccessibleInterval<BitType>>(){});
        opToTest.compute(this.in, (Object)new RectangleShape(3, false), (Object)0.0, (Object)new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE), this.out);
        Assertions.assertEquals((Object)true, (Object)((BitType)this.out.firstElement()).get());
    }

    @Test
    public void testLocalMinErrorThreshold() {
        Computers.Arity3 opToTest = OpBuilder.matchComputer((OpEnvironment)ops, (String)"threshold.minError", (Nil)new Nil<RandomAccessibleInterval<ByteType>>(){}, (Nil)new Nil<Shape>(){}, (Nil)new Nil<OutOfBoundsFactory<ByteType, RandomAccessibleInterval<ByteType>>>(){}, (Nil)new Nil<RandomAccessibleInterval<BitType>>(){});
        opToTest.compute(this.in, (Object)new RectangleShape(1, false), (Object)new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE), this.out);
        Assertions.assertEquals((Object)true, (Object)((BitType)this.out.firstElement()).get());
    }

    @Test
    public void testLocalMinimumThreshold() {
        Computers.Arity3 opToTest = OpBuilder.matchComputer((OpEnvironment)ops, (String)"threshold.minimum", (Nil)new Nil<RandomAccessibleInterval<ByteType>>(){}, (Nil)new Nil<Shape>(){}, (Nil)new Nil<OutOfBoundsFactory<ByteType, RandomAccessibleInterval<ByteType>>>(){}, (Nil)new Nil<RandomAccessibleInterval<BitType>>(){});
        opToTest.compute(this.in, (Object)new RectangleShape(1, false), (Object)new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE), this.out);
        Assertions.assertEquals((Object)true, (Object)((BitType)this.out.firstElement()).get());
    }

    @Test
    public void testLocalMomentsThreshold() {
        Computers.Arity3 opToTest = OpBuilder.matchComputer((OpEnvironment)ops, (String)"threshold.moments", (Nil)new Nil<RandomAccessibleInterval<ByteType>>(){}, (Nil)new Nil<Shape>(){}, (Nil)new Nil<OutOfBoundsFactory<ByteType, RandomAccessibleInterval<ByteType>>>(){}, (Nil)new Nil<RandomAccessibleInterval<BitType>>(){});
        opToTest.compute(this.in, (Object)new RectangleShape(1, false), (Object)new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE), this.out);
        Assertions.assertEquals((Object)true, (Object)((BitType)this.out.firstElement()).get());
    }

    @Test
    public void testLocalNiblackThreshold() {
        Computers.Arity5 opToTest = OpBuilder.matchComputer((OpEnvironment)ops, (String)"threshold.localNiblack", (Nil)new Nil<RandomAccessibleInterval<ByteType>>(){}, (Nil)new Nil<Shape>(){}, (Nil)new Nil<Double>(){}, (Nil)new Nil<Double>(){}, (Nil)new Nil<OutOfBoundsFactory<ByteType, RandomAccessibleInterval<ByteType>>>(){}, (Nil)new Nil<RandomAccessibleInterval<BitType>>(){});
        opToTest.compute(this.in, (Object)new RectangleShape(1, false), (Object)0.2, (Object)0.0, (Object)new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE), this.out);
        Assertions.assertEquals((Object)true, (Object)((BitType)this.out.firstElement()).get());
    }

    @Test
    public void testLocalOtsuThreshold() {
        Computers.Arity3 opToTest = OpBuilder.matchComputer((OpEnvironment)ops, (String)"threshold.otsu", (Nil)new Nil<RandomAccessibleInterval<ByteType>>(){}, (Nil)new Nil<Shape>(){}, (Nil)new Nil<OutOfBoundsFactory<ByteType, RandomAccessibleInterval<ByteType>>>(){}, (Nil)new Nil<RandomAccessibleInterval<BitType>>(){});
        opToTest.compute(this.in, (Object)new RectangleShape(1, false), (Object)new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE), this.out);
        Assertions.assertEquals((Object)true, (Object)((BitType)this.out.firstElement()).get());
    }

    @Test
    public void testLocalPercentileThreshold() {
        Computers.Arity3 opToTest = OpBuilder.matchComputer((OpEnvironment)ops, (String)"threshold.percentile", (Nil)new Nil<RandomAccessibleInterval<ByteType>>(){}, (Nil)new Nil<Shape>(){}, (Nil)new Nil<OutOfBoundsFactory<ByteType, RandomAccessibleInterval<ByteType>>>(){}, (Nil)new Nil<RandomAccessibleInterval<BitType>>(){});
        opToTest.compute(this.in, (Object)new RectangleShape(1, false), (Object)new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE), this.out);
        Assertions.assertEquals((Object)true, (Object)((BitType)this.out.firstElement()).get());
    }

    @Test
    public void testLocalPhansalkar() {
        Computers.Arity5 opToTest = OpBuilder.matchComputer((OpEnvironment)ops, (String)"threshold.localPhansalkar", (Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){}, (Nil)new Nil<Shape>(){}, (Nil)new Nil<Double>(){}, (Nil)new Nil<Double>(){}, (Nil)new Nil<OutOfBoundsFactory<DoubleType, RandomAccessibleInterval<DoubleType>>>(){}, (Nil)new Nil<RandomAccessibleInterval<BitType>>(){});
        opToTest.compute(this.normalizedIn, (Object)new RectangleShape(2, false), (Object)0.25, (Object)0.5, (Object)new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE), this.out);
        Assertions.assertEquals((Object)true, (Object)((BitType)this.out.firstElement()).get());
    }

    @Test
    public void testLocalRenyiEntropyThreshold() {
        Computers.Arity3 opToTest = OpBuilder.matchComputer((OpEnvironment)ops, (String)"threshold.renyiEntropy", (Nil)new Nil<RandomAccessibleInterval<ByteType>>(){}, (Nil)new Nil<Shape>(){}, (Nil)new Nil<OutOfBoundsFactory<ByteType, RandomAccessibleInterval<ByteType>>>(){}, (Nil)new Nil<RandomAccessibleInterval<BitType>>(){});
        opToTest.compute(this.in, (Object)new RectangleShape(1, false), (Object)new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE), this.out);
        Assertions.assertEquals((Object)true, (Object)((BitType)this.out.firstElement()).get());
    }

    @Test
    public void testLocalSauvola() {
        Computers.Arity2 opToTest = OpBuilder.matchComputer((OpEnvironment)ops, (String)"threshold.localSauvola", (Nil)new Nil<RandomAccessibleInterval<ByteType>>(){}, (Nil)new Nil<Shape>(){}, (Nil)new Nil<RandomAccessibleInterval<BitType>>(){});
        opToTest.compute(this.in, (Object)new RectangleShape(2, false), this.out);
        Assertions.assertEquals((Object)true, (Object)((BitType)this.out.firstElement()).get());
    }

    @Test
    public void testLocalShanbhagThreshold() {
        Computers.Arity3 opToTest = OpBuilder.matchComputer((OpEnvironment)ops, (String)"threshold.shanbhag", (Nil)new Nil<RandomAccessibleInterval<ByteType>>(){}, (Nil)new Nil<Shape>(){}, (Nil)new Nil<OutOfBoundsFactory<ByteType, RandomAccessibleInterval<ByteType>>>(){}, (Nil)new Nil<RandomAccessibleInterval<BitType>>(){});
        opToTest.compute(this.in, (Object)new RectangleShape(1, false), (Object)new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE), this.out);
        Assertions.assertEquals((Object)true, (Object)((BitType)this.out.firstElement()).get());
    }

    @Test
    public void testLocalTriangleThreshold() {
        Computers.Arity3 opToTest = OpBuilder.matchComputer((OpEnvironment)ops, (String)"threshold.triangle", (Nil)new Nil<RandomAccessibleInterval<ByteType>>(){}, (Nil)new Nil<Shape>(){}, (Nil)new Nil<OutOfBoundsFactory<ByteType, RandomAccessibleInterval<ByteType>>>(){}, (Nil)new Nil<RandomAccessibleInterval<BitType>>(){});
        opToTest.compute(this.in, (Object)new RectangleShape(1, false), (Object)new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE), this.out);
        Assertions.assertEquals((Object)true, (Object)((BitType)this.out.firstElement()).get());
    }

    @Test
    public void testLocalYenThreshold() {
        Computers.Arity3 opToTest = OpBuilder.matchComputer((OpEnvironment)ops, (String)"threshold.yen", (Nil)new Nil<RandomAccessibleInterval<ByteType>>(){}, (Nil)new Nil<Shape>(){}, (Nil)new Nil<OutOfBoundsFactory<ByteType, RandomAccessibleInterval<ByteType>>>(){}, (Nil)new Nil<RandomAccessibleInterval<BitType>>(){});
        opToTest.compute(this.in, (Object)new RectangleShape(1, false), (Object)new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE), this.out);
        Assertions.assertEquals((Object)true, (Object)((BitType)this.out.firstElement()).get());
    }

    @Test
    public void testLocalRosinThreshold() {
        Computers.Arity3 opToTest = OpBuilder.matchComputer((OpEnvironment)ops, (String)"threshold.rosin", (Nil)new Nil<RandomAccessibleInterval<ByteType>>(){}, (Nil)new Nil<Shape>(){}, (Nil)new Nil<OutOfBoundsFactory<ByteType, RandomAccessibleInterval<ByteType>>>(){}, (Nil)new Nil<RandomAccessibleInterval<BitType>>(){});
        opToTest.compute(this.in, (Object)new RectangleShape(1, false), (Object)new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE), this.out);
        Assertions.assertEquals((Object)true, (Object)((BitType)this.out.firstElement()).get());
    }

    public ArrayImg<ByteType, ByteArray> generateKnownByteArrayTestImgSmall() {
        long[] dims = new long[]{2L, 2L};
        byte[] array = new byte[]{10, 20, 30, 40};
        return ArrayImgs.bytes((byte[])array, (long[])dims);
    }

    public ArrayImg<ByteType, ByteArray> generateKnownByteArrayTestImgLarge() {
        long[] dims = new long[]{3L, 3L};
        byte[] array = new byte[]{40, 40, 20, 40, 40, 20, 20, 20, 100};
        return ArrayImgs.bytes((byte[])array, (long[])dims);
    }

    public static <T extends RealType<T>, S extends RealType<S>> void testRandomAccessibleInterval(RandomAccessibleInterval<T> ii1, RandomAccessibleInterval<S> ii2) {
        Cursor cursor1 = Views.flatIterable(ii1).localizingCursor();
        Cursor cursor2 = Views.flatIterable(ii2).cursor();
        while (cursor1.hasNext() && cursor2.hasNext()) {
            RealType value1 = (RealType)cursor1.next();
            RealType value2 = (RealType)cursor2.next();
            Assertions.assertEquals((double)value1.getRealDouble(), (double)value2.getRealDouble(), (double)1.0E-5);
        }
    }
}

