/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.transform.realTransform;

import net.imglib2.Cursor;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.realtransform.AffineTransform2D;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;

public class RealTransformTest
extends AbstractOpTest {
    @Test
    public void testRealTransform() {
        Img<UnsignedByteType> image = RealTransformTest.openRelativeUnsignedByteImg(this.getClass(), "lowresbridge.tif");
        Img<UnsignedByteType> expectedOutput = RealTransformTest.openRelativeUnsignedByteImg(this.getClass(), "rotatedscaledcenter.tif");
        AffineTransform2D transform = new AffineTransform2D();
        double translation = (double)image.dimension(0) / 2.0;
        transform.translate(new double[]{-translation, -translation});
        transform.rotate(1.0);
        transform.scale(0.5);
        transform.translate(new double[]{translation, translation});
        Nil<RandomAccessibleInterval<UnsignedByteType>> outType = new Nil<RandomAccessibleInterval<UnsignedByteType>>(){};
        RandomAccessibleInterval actualOutput = (RandomAccessibleInterval)ops.op("transform.realTransform").input(image, (Object)transform).outType((Nil)outType).apply();
        Cursor cursor = Views.iterable((RandomAccessibleInterval)actualOutput).localizingCursor();
        RandomAccess actualRA = actualOutput.randomAccess();
        RandomAccess expectedRA = expectedOutput.randomAccess();
        while (cursor.hasNext()) {
            cursor.fwd();
            actualRA.setPosition((Localizable)cursor);
            expectedRA.setPosition((Localizable)cursor);
            Assertions.assertEquals((float)((UnsignedByteType)expectedRA.get()).get(), (float)((UnsignedByteType)actualRA.get()).get(), (float)0.0f);
        }
    }
}

