/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.transform.shearView;

import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.TransformView;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.function.Functions;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;

public class ShearViewTest
extends AbstractOpTest {
    @Test
    public void testDefaultShear() {
        Functions.Arity3 shearFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.shearView", (Nil)new Nil<RandomAccessible<DoubleType>>(){}, (Nil)new Nil<Integer>(){}, (Nil)new Nil<Integer>(){}, (Nil)new Nil<TransformView<DoubleType>>(){});
        ArrayImg img = new ArrayImgFactory((NativeType)new DoubleType()).create(new int[]{2, 2});
        Cursor imgC = img.cursor();
        while (imgC.hasNext()) {
            ((DoubleType)imgC.next()).set(1.0);
        }
        TransformView il2 = Views.shear((RandomAccessible)Views.extendZero((RandomAccessibleInterval)img), (int)0, (int)1);
        TransformView opr = (TransformView)shearFunc.apply((Object)Views.extendZero((RandomAccessibleInterval)img), (Object)0, (Object)1);
        Cursor il2C = Views.interval((RandomAccessible)il2, (Interval)new FinalInterval(new long[]{0L, 0L}, new long[]{3L, 3L})).cursor();
        RandomAccess oprRA = Views.interval((RandomAccessible)opr, (Interval)new FinalInterval(new long[]{0L, 0L}, new long[]{3L, 3L})).randomAccess();
        while (il2C.hasNext()) {
            il2C.next();
            oprRA.setPosition((Localizable)il2C);
            Assertions.assertEquals((double)((DoubleType)il2C.get()).get(), (double)((DoubleType)oprRA.get()).get(), (double)1.0E-10);
        }
    }

    @Test
    public void testShearInterval() {
        Functions.Arity4 shearFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.shearView", (Nil)new Nil<RandomAccessible<DoubleType>>(){}, (Nil)new Nil<Interval>(){}, (Nil)new Nil<Integer>(){}, (Nil)new Nil<Integer>(){}, (Nil)new Nil<IntervalView<DoubleType>>(){});
        ArrayImg img = new ArrayImgFactory((NativeType)new DoubleType()).create(new int[]{2, 2});
        Cursor imgC = img.cursor();
        while (imgC.hasNext()) {
            ((DoubleType)imgC.next()).set(1.0);
        }
        Cursor il2 = Views.shear((RandomAccessible)Views.extendZero((RandomAccessibleInterval)img), (Interval)new FinalInterval(new long[]{0L, 0L}, new long[]{3L, 3L}), (int)0, (int)1).cursor();
        RandomAccess opr = ((IntervalView)shearFunc.apply((Object)Views.extendZero((RandomAccessibleInterval)img), (Object)new FinalInterval(new long[]{0L, 0L}, new long[]{3L, 3L}), (Object)0, (Object)1)).randomAccess();
        while (il2.hasNext()) {
            il2.next();
            opr.setPosition((Localizable)il2);
            Assertions.assertEquals((double)((DoubleType)il2.get()).get(), (double)((DoubleType)opr.get()).get(), (double)1.0E-10);
        }
    }
}

