/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.transform.subsampleView;

import java.util.function.BiFunction;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.util.Intervals;
import net.imglib2.view.SubsampleIntervalView;
import net.imglib2.view.SubsampleView;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;
import org.scijava.util.MersenneTwisterFast;

public class SubsampleViewTest
extends AbstractOpTest {
    private static final long SEED = 305419896L;

    @Test
    public void testDefaultSubsample() {
        BiFunction subsampleFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.subsampleView", (Nil)new Nil<Img<DoubleType>>(){}, (Nil)new Nil<Long>(){}, (Nil)new Nil<SubsampleView<DoubleType>>(){});
        ArrayImg img = new ArrayImgFactory((NativeType)new DoubleType()).create(new int[]{10, 10});
        MersenneTwisterFast r = new MersenneTwisterFast(305419896L);
        for (DoubleType d : img) {
            d.set(r.nextDouble());
        }
        SubsampleView il2 = Views.subsample((RandomAccessible)img, (long)2L);
        SubsampleView opr = (SubsampleView)subsampleFunc.apply(img, 2L);
        Cursor il2C = Views.interval((RandomAccessible)il2, (long[])new long[]{0L, 0L}, (long[])new long[]{4L, 4L}).localizingCursor();
        RandomAccess oprRA = opr.randomAccess();
        while (il2C.hasNext()) {
            il2C.next();
            oprRA.setPosition((Localizable)il2C);
            Assertions.assertEquals((double)((DoubleType)il2C.get()).get(), (double)((DoubleType)oprRA.get()).get(), (double)1.0E-10);
        }
    }

    @Test
    public void testDefaultSubsampleSteps() {
        BiFunction subsampleFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.subsampleView", (Nil)new Nil<Img<DoubleType>>(){}, (Nil)new Nil<long[]>(){}, (Nil)new Nil<SubsampleView<DoubleType>>(){});
        ArrayImg img = new ArrayImgFactory((NativeType)new DoubleType()).create(new int[]{10, 10});
        MersenneTwisterFast r = new MersenneTwisterFast(305419896L);
        for (DoubleType d : img) {
            d.set(r.nextDouble());
        }
        SubsampleView il2 = Views.subsample((RandomAccessible)img, (long[])new long[]{2L, 1L});
        SubsampleView opr = (SubsampleView)subsampleFunc.apply(img, new long[]{2L, 1L});
        Cursor il2C = Views.interval((RandomAccessible)il2, (long[])new long[]{0L, 0L}, (long[])new long[]{4L, 9L}).localizingCursor();
        RandomAccess oprRA = opr.randomAccess();
        while (il2C.hasNext()) {
            il2C.next();
            oprRA.setPosition((Localizable)il2C);
            Assertions.assertEquals((double)((DoubleType)il2C.get()).get(), (double)((DoubleType)oprRA.get()).get(), (double)1.0E-10);
        }
    }

    @Test
    public void testIntervalSubsample() {
        BiFunction subsampleFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.subsampleView", (Nil)new Nil<Img<DoubleType>>(){}, (Nil)new Nil<Long>(){}, (Nil)new Nil<SubsampleIntervalView<DoubleType>>(){});
        ArrayImg img = ArrayImgs.doubles((long[])new long[]{10L, 10L});
        MersenneTwisterFast r = new MersenneTwisterFast(305419896L);
        for (DoubleType d : img) {
            d.set(r.nextDouble());
        }
        SubsampleIntervalView expected = Views.subsample((RandomAccessibleInterval)img, (long)2L);
        SubsampleIntervalView actual = (SubsampleIntervalView)subsampleFunc.apply(img, 2L);
        Cursor il2C = Views.interval((RandomAccessible)expected, (long[])new long[]{0L, 0L}, (long[])new long[]{4L, 4L}).localizingCursor();
        RandomAccess oprRA = actual.randomAccess();
        while (il2C.hasNext()) {
            il2C.next();
            oprRA.setPosition((Localizable)il2C);
            Assertions.assertEquals((double)((DoubleType)il2C.get()).get(), (double)((DoubleType)oprRA.get()).get(), (double)1.0E-10);
        }
        Assertions.assertTrue((boolean)Intervals.equals((Interval)expected, (Interval)actual));
    }

    @Test
    public void testIntervalSubsampleSteps() {
        BiFunction subsampleFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.subsampleView", (Nil)new Nil<Img<DoubleType>>(){}, (Nil)new Nil<long[]>(){}, (Nil)new Nil<SubsampleIntervalView<DoubleType>>(){});
        ArrayImg img = ArrayImgs.doubles((long[])new long[]{10L, 10L});
        MersenneTwisterFast r = new MersenneTwisterFast(305419896L);
        for (DoubleType d : img) {
            d.set(r.nextDouble());
        }
        SubsampleIntervalView expected = Views.subsample((RandomAccessibleInterval)img, (long[])new long[]{2L, 1L});
        SubsampleIntervalView actual = (SubsampleIntervalView)subsampleFunc.apply(img, new long[]{2L, 1L});
        Cursor il2C = Views.interval((RandomAccessible)expected, (long[])new long[]{0L, 0L}, (long[])new long[]{4L, 9L}).localizingCursor();
        RandomAccess oprRA = actual.randomAccess();
        while (il2C.hasNext()) {
            il2C.next();
            oprRA.setPosition((Localizable)il2C);
            Assertions.assertEquals((double)((DoubleType)il2C.get()).get(), (double)((DoubleType)oprRA.get()).get(), (double)1.0E-10);
        }
        Assertions.assertTrue((boolean)Intervals.equals((Interval)expected, (Interval)actual));
    }
}

