/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.types.maxValue;

import net.imglib2.type.logic.BitType;
import net.imglib2.type.logic.BoolType;
import net.imglib2.type.logic.NativeBoolType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.Unsigned128BitType;
import net.imglib2.type.numeric.integer.Unsigned12BitType;
import net.imglib2.type.numeric.integer.Unsigned2BitType;
import net.imglib2.type.numeric.integer.Unsigned4BitType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedLongType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.integer.UnsignedVariableBitLengthType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;

public class MaxValueRealTypesTest
extends AbstractOpTest {
    @Test
    public void testMaxValueBitType() {
        BitType maxValue = (BitType)ops.op("types.maxValue").input((Object)new BitType()).outType(BitType.class).apply();
        BitType expected = new BitType(true);
        Assertions.assertTrue((boolean)maxValue.equals((Object)expected));
    }

    @Test
    public void testMaxValueBoolType() {
        BoolType maxValue = (BoolType)ops.op("types.maxValue").input((Object)new BoolType()).outType(BoolType.class).apply();
        BoolType expected = new BoolType(true);
        Assertions.assertTrue((boolean)maxValue.equals((Object)expected));
    }

    @Test
    public void testMaxValueNativeBoolType() {
        NativeBoolType maxValue = (NativeBoolType)ops.op("types.maxValue").input((Object)new NativeBoolType()).outType(NativeBoolType.class).apply();
        NativeBoolType expected = new NativeBoolType(true);
        Assertions.assertTrue((boolean)maxValue.equals((Object)expected));
    }

    @Test
    public void testMaxValueByteType() {
        ByteType maxValue = (ByteType)ops.op("types.maxValue").input((Object)new ByteType()).outType(ByteType.class).apply();
        ByteType expected = new ByteType(127);
        Assertions.assertTrue((boolean)maxValue.equals((Object)expected));
    }

    @Test
    public void testMaxValueUnsignedByteType() {
        UnsignedByteType maxValue = (UnsignedByteType)ops.op("types.maxValue").input((Object)new UnsignedByteType()).outType(UnsignedByteType.class).apply();
        UnsignedByteType expected = new UnsignedByteType(255);
        Assertions.assertTrue((boolean)maxValue.equals((Object)expected));
    }

    @Test
    public void testMaxValueIntType() {
        IntType maxValue = (IntType)ops.op("types.maxValue").input((Object)new IntType()).outType(IntType.class).apply();
        IntType expected = new IntType(Integer.MAX_VALUE);
        Assertions.assertTrue((boolean)maxValue.equals((Object)expected));
    }

    @Test
    public void testMaxValueUnsignedIntType() {
        UnsignedIntType maxValue = (UnsignedIntType)ops.op("types.maxValue").input((Object)new UnsignedIntType()).outType(UnsignedIntType.class).apply();
        UnsignedIntType expected = new UnsignedIntType(0xFFFFFFFFL);
        Assertions.assertTrue((boolean)maxValue.equals((Object)expected));
    }

    @Test
    public void testMaxValueLongType() {
        LongType maxValue = (LongType)ops.op("types.maxValue").input((Object)new LongType()).outType(LongType.class).apply();
        LongType expected = new LongType(Long.MAX_VALUE);
        Assertions.assertTrue((boolean)maxValue.equals((Object)expected));
    }

    @Test
    public void testMaxValueUnsignedLongType() {
        UnsignedLongType maxValue = (UnsignedLongType)ops.op("types.maxValue").input((Object)new UnsignedLongType()).outType(UnsignedLongType.class).apply();
        UnsignedLongType expected = new UnsignedLongType(new UnsignedLongType().getMaxBigIntegerValue());
        Assertions.assertTrue((boolean)maxValue.equals((Object)expected));
    }

    @Test
    public void testMaxValueShortType() {
        ShortType maxValue = (ShortType)ops.op("types.maxValue").input((Object)new ShortType()).outType(ShortType.class).apply();
        ShortType expected = new ShortType(Short.MAX_VALUE);
        Assertions.assertTrue((boolean)maxValue.equals((Object)expected));
    }

    @Test
    public void testMaxValueUnsignedShortType() {
        UnsignedShortType maxValue = (UnsignedShortType)ops.op("types.maxValue").input((Object)new UnsignedShortType()).outType(UnsignedShortType.class).apply();
        UnsignedShortType expected = new UnsignedShortType(65535);
        Assertions.assertTrue((boolean)maxValue.equals((Object)expected));
    }

    @Test
    public void testMaxValueUnsigned2BitType() {
        Unsigned2BitType maxValue = (Unsigned2BitType)ops.op("types.maxValue").input((Object)new Unsigned2BitType()).outType(Unsigned2BitType.class).apply();
        Unsigned2BitType expected = new Unsigned2BitType(3L);
        Assertions.assertTrue((boolean)maxValue.equals((Object)expected));
    }

    @Test
    public void testMaxValueUnsigned4BitType() {
        Unsigned4BitType maxValue = (Unsigned4BitType)ops.op("types.maxValue").input((Object)new Unsigned4BitType()).outType(Unsigned4BitType.class).apply();
        Unsigned4BitType expected = new Unsigned4BitType(15L);
        Assertions.assertTrue((boolean)maxValue.equals((Object)expected));
    }

    @Test
    public void testMaxValueUnsigned12BitType() {
        Unsigned12BitType maxValue = (Unsigned12BitType)ops.op("types.maxValue").input((Object)new Unsigned12BitType()).outType(Unsigned12BitType.class).apply();
        Unsigned12BitType expected = new Unsigned12BitType(4095L);
        Assertions.assertTrue((boolean)maxValue.equals((Object)expected));
    }

    @Test
    public void testMaxValueUnsigned128BitType() {
        Unsigned128BitType maxValue = (Unsigned128BitType)ops.op("types.maxValue").input((Object)new Unsigned128BitType()).outType(Unsigned128BitType.class).apply();
        Unsigned128BitType expected = new Unsigned128BitType(new Unsigned128BitType().getMaxBigIntegerValue());
        Assertions.assertTrue((boolean)maxValue.equals((Object)expected));
    }

    @Test
    public void testMaxValueFloatType() {
        FloatType maxValue = (FloatType)ops.op("types.maxValue").input((Object)new FloatType()).outType(FloatType.class).apply();
        FloatType expected = new FloatType(Float.MAX_VALUE);
        Assertions.assertTrue((boolean)maxValue.equals((Object)expected));
    }

    @Test
    public void testMaxValueDoubleType() {
        DoubleType maxValue = (DoubleType)ops.op("types.maxValue").input((Object)new DoubleType()).outType(DoubleType.class).apply();
        DoubleType expected = new DoubleType(Double.MAX_VALUE);
        Assertions.assertTrue((boolean)maxValue.equals((Object)expected));
    }

    @Test
    public void testMaxValueUnsignedVariableBitLengthType() {
        UnsignedVariableBitLengthType maxValue5 = (UnsignedVariableBitLengthType)ops.op("types.maxValue").input((Object)new UnsignedVariableBitLengthType(5)).outType(UnsignedVariableBitLengthType.class).apply();
        UnsignedVariableBitLengthType expected5 = new UnsignedVariableBitLengthType(31L, 5);
        Assertions.assertTrue((boolean)maxValue5.equals((Object)expected5));
        UnsignedVariableBitLengthType maxValue17 = (UnsignedVariableBitLengthType)ops.op("types.maxValue").input((Object)new UnsignedVariableBitLengthType(17)).outType(UnsignedVariableBitLengthType.class).apply();
        UnsignedVariableBitLengthType expected17 = new UnsignedVariableBitLengthType(131071L, 17);
        Assertions.assertTrue((boolean)maxValue17.equals((Object)expected17));
    }
}

