/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.coloc;

import org.scijava.ops.image.coloc.IntComparator;

public class MergeSort {
    private int[] data;
    private final IntComparator comparator;

    public MergeSort(int[] data, IntComparator comparator) {
        this.data = data;
        this.comparator = comparator;
    }

    public int[] getSortedData() {
        return this.data;
    }

    public long sort() {
        long swaps = 0L;
        int n = this.data.length;
        int[] data2 = new int[n];
        for (int step = 1; step < n; step <<= 1) {
            int begin = 0;
            int k = 0;
            while (true) {
                int begin2;
                int end;
                if ((end = (begin2 = begin + step) + step) >= n) {
                    if (begin2 >= n) break;
                    end = n;
                }
                int i = begin;
                int j = begin2;
                while (i < begin2 && j < end) {
                    int compare = this.comparator.compare(this.data[i], this.data[j]);
                    if (compare > 0) {
                        swaps += (long)(begin2 - i);
                        data2[k++] = this.data[j++];
                        continue;
                    }
                    data2[k++] = this.data[i++];
                }
                if (i < begin2) {
                    do {
                        data2[k++] = this.data[i++];
                    } while (i < begin2);
                } else {
                    while (j < end) {
                        data2[k++] = this.data[j++];
                    }
                }
                begin = end;
            }
            if (k < n) {
                System.arraycopy(this.data, k, data2, k, n - k);
            }
            int[] swapIndex = data2;
            data2 = this.data;
            this.data = swapIndex;
        }
        return swaps;
    }
}

