/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.create;

import java.util.function.BiFunction;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.util.Util;
import net.imglib2.view.Views;

public final class DefaultCreateKernelGauss {
    private DefaultCreateKernelGauss() {
    }

    public static <T extends Type<T>, C extends ComplexType<C>> RandomAccessibleInterval<C> createKernel(double[] input, C type, BiFunction<Dimensions, T, Img<T>> imgFromDimsAndType) {
        double[] sigmaPixels = new double[input.length];
        long[] dims = new long[input.length];
        double[][] kernelArrays = new double[input.length][];
        for (int d = 0; d < input.length; ++d) {
            sigmaPixels[d] = input[d];
            dims[d] = Math.max(3, 2 * (int)(3.0 * sigmaPixels[d] + 0.5) + 1);
            kernelArrays[d] = Util.createGaussianKernel1DDouble((double)sigmaPixels[d], (boolean)true);
        }
        RandomAccessibleInterval out = (RandomAccessibleInterval)imgFromDimsAndType.apply((Dimensions)new FinalInterval(dims), (Dimensions)type);
        Cursor cursor = Views.iterable((RandomAccessibleInterval)out).cursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            double result = 1.0;
            for (int d = 0; d < input.length; ++d) {
                result *= kernelArrays[d][cursor.getIntPosition(d)];
            }
            ((ComplexType)cursor.get()).setReal(result);
        }
        return out;
    }
}

