/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.features.haralick;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.ops.image.features.haralick.AbstractHaralickFeature;
import org.scijava.ops.image.image.cooccurrenceMatrix.MatrixOrientation;

public class DefaultEntropy<T extends RealType<T>>
extends AbstractHaralickFeature<T> {
    private static final double EPSILON = Double.MIN_NORMAL;

    public DoubleType apply(RandomAccessibleInterval<T> input, Integer numGreyLevels, Integer distance, MatrixOrientation orientation) {
        double[][] matrix = this.getCooccurrenceMatrix(input, numGreyLevels, distance, orientation);
        double res = 0.0;
        int nrGrayLevels = matrix.length;
        for (int i = 0; i < nrGrayLevels; ++i) {
            for (int j = 0; j < nrGrayLevels; ++j) {
                res += matrix[i][j] * Math.log(matrix[i][j] + Double.MIN_NORMAL);
            }
        }
        DoubleType output = new DoubleType();
        output.set(-res);
        return output;
    }
}

