/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.features.haralick;

import java.util.function.Function;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.function.Functions;
import org.scijava.ops.image.features.haralick.AbstractHaralickFeature;
import org.scijava.ops.image.image.cooccurrenceMatrix.MatrixOrientation;
import org.scijava.ops.spi.OpDependency;

public class DefaultSumVariance<T extends RealType<T>>
extends AbstractHaralickFeature<T> {
    @OpDependency(name="features.haralick.coocPXPlusY")
    private Function<double[][], double[]> coocPXPlusYFunc;
    @OpDependency(name="features.haralick.sumEntropy")
    private Functions.Arity4<RandomAccessibleInterval<T>, Integer, Integer, MatrixOrientation, RealType> sumEntropyFunc;

    public DoubleType apply(RandomAccessibleInterval<T> input, Integer numGreyLevels, Integer distance, MatrixOrientation orientation) {
        double[][] matrix = this.getCooccurrenceMatrix(input, numGreyLevels, distance, orientation);
        double[] pxplusy = this.coocPXPlusYFunc.apply(matrix);
        int nrGrayLevels = matrix.length;
        double sumEntropy = ((RealType)this.sumEntropyFunc.apply(input, (Object)numGreyLevels, (Object)distance, (Object)orientation)).getRealDouble();
        double res = 0.0;
        for (int i = 2; i <= 2 * nrGrayLevels; ++i) {
            res += ((double)i - sumEntropy) * ((double)i - sumEntropy) * pxplusy[i];
        }
        DoubleType output = new DoubleType();
        output.set(res);
        return output;
    }
}

