/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.features.lbp2d;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.BiFunction;
import net.imglib2.Cursor;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.outofbounds.OutOfBounds;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.view.Views;
import org.scijava.function.Functions;
import org.scijava.ops.spi.OpDependency;

public class DefaultLBP2D<I extends RealType<I>>
implements Functions.Arity3<RandomAccessibleInterval<I>, Integer, Integer, ArrayList<LongType>> {
    @OpDependency(name="image.histogram")
    private BiFunction<ArrayList<LongType>, Integer, Histogram1d<LongType>> histOp;

    public ArrayList<LongType> apply(RandomAccessibleInterval<I> input, Integer distance, Integer histogramSize) {
        ArrayList<LongType> output = new ArrayList<LongType>();
        if (input.numDimensions() != 2) {
            throw new IllegalArgumentException("Only 2 dimensional images allowed!");
        }
        ArrayList<LongType> numberList = new ArrayList<LongType>();
        OutOfBounds raInput = Views.extendZero(input).randomAccess();
        Cursor cInput = Views.flatIterable(input).cursor();
        ClockwiseDistanceNeighborhoodIterator cNeigh = new ClockwiseDistanceNeighborhoodIterator(raInput, distance);
        while (cInput.hasNext()) {
            cInput.next();
            double centerValue = ((RealType)cInput.get()).getRealDouble();
            int resultBinaryValue = 0;
            cNeigh.reset();
            while (cNeigh.hasNext()) {
                double nValue = ((RealType)cNeigh.next()).getRealDouble();
                int pos = cNeigh.getIndex();
                if (!(nValue >= centerValue)) continue;
                resultBinaryValue |= 1 << pos;
            }
            numberList.add(new LongType((long)resultBinaryValue));
        }
        Histogram1d<LongType> hist = this.histOp.apply(numberList, histogramSize);
        Iterator c = hist.iterator();
        while (c.hasNext()) {
            output.add(new LongType(((LongType)c.next()).get()));
        }
        return output;
    }

    final class ClockwiseDistanceNeighborhoodIterator<T extends Type<T>>
    implements Iterator<T> {
        private final RandomAccess<T> m_ra;
        private final int m_distance;
        private final int[][] CLOCKWISE_OFFSETS = new int[][]{{0, -1}, {1, 0}, {1, 0}, {0, 1}, {0, 1}, {-1, 0}, {-1, 0}, {0, -1}};
        private int m_curOffset = 0;
        private int m_startIndex = 8;

        public ClockwiseDistanceNeighborhoodIterator(RandomAccess<T> ra, int distance) {
            this.m_ra = ra;
            this.m_distance = distance;
        }

        @Override
        public final boolean hasNext() {
            return this.m_curOffset != this.m_startIndex;
        }

        @Override
        public final T next() {
            this.m_ra.move(this.CLOCKWISE_OFFSETS[this.m_curOffset][0] * this.m_distance, 0);
            this.m_ra.move(this.CLOCKWISE_OFFSETS[this.m_curOffset][1] * this.m_distance, 1);
            ++this.m_curOffset;
            return (T)((Type)this.m_ra.get());
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        public final int getIndex() {
            return this.m_curOffset;
        }

        public final void reset() {
            this.m_curOffset = 0;
            this.m_startIndex = 8;
        }
    }
}

