/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.image.distancetransform;

import net.imglib2.type.numeric.RealType;
import net.imglib2.util.IntervalIndexer;

class NextPhase<T extends RealType<T>>
implements Runnable {
    private final int[] actualValues;
    private final int[] dimensSizes;
    private final int[] positions;
    private final int[] positions2;
    private final int actualDimension;

    public NextPhase(int[] actualValues, int[] dimensSizes, int[] positions, int actualDimension) {
        this.actualValues = actualValues;
        this.dimensSizes = dimensSizes;
        this.positions = positions;
        this.positions2 = (int[])positions.clone();
        this.actualDimension = actualDimension;
    }

    private int distancefunc(int x, int i, int raOutValue) {
        return (x - i) * (x - i) + raOutValue;
    }

    private int sep(int i, int u, int w, int v) {
        return (u * u - i * i + w - v) / (2 * (u - i));
    }

    @Override
    public void run() {
        int u;
        int[] s = new int[this.dimensSizes[this.actualDimension]];
        int[] t = new int[this.dimensSizes[this.actualDimension]];
        int q = 0;
        s[0] = 0;
        t[0] = 0;
        for (int u2 = 1; u2 < this.dimensSizes[this.actualDimension]; ++u2) {
            this.positions[this.actualDimension] = s[q];
            this.positions2[this.actualDimension] = u2;
            while (q >= 0 && this.distancefunc(t[q], s[q], this.actualValues[IntervalIndexer.positionToIndex((int[])this.positions, (int[])this.dimensSizes)]) > this.distancefunc(t[q], u2, this.actualValues[IntervalIndexer.positionToIndex((int[])this.positions2, (int[])this.dimensSizes)])) {
                if (--q < 0) continue;
                this.positions[this.actualDimension] = s[q];
            }
            if (q < 0) {
                q = 0;
                s[0] = u2;
                continue;
            }
            this.positions[this.actualDimension] = s[q];
            this.positions2[this.actualDimension] = u2;
            double w = 1 + this.sep(s[q], u2, this.actualValues[IntervalIndexer.positionToIndex((int[])this.positions2, (int[])this.dimensSizes)], this.actualValues[IntervalIndexer.positionToIndex((int[])this.positions, (int[])this.dimensSizes)]);
            if (!(w < (double)this.dimensSizes[this.actualDimension])) continue;
            s[++q] = u2;
            t[q] = (int)w;
        }
        int[] newValues = new int[this.dimensSizes[this.actualDimension]];
        for (u = this.dimensSizes[this.actualDimension] - 1; u >= 0; --u) {
            this.positions[this.actualDimension] = s[q];
            newValues[u] = this.distancefunc(u, s[q], this.actualValues[IntervalIndexer.positionToIndex((int[])this.positions, (int[])this.dimensSizes)]);
            if (u != t[q]) continue;
            --q;
        }
        for (u = this.dimensSizes[this.actualDimension] - 1; u >= 0; --u) {
            this.positions[this.actualDimension] = u;
            this.actualValues[IntervalIndexer.positionToIndex((int[])this.positions, (int[])this.dimensSizes)] = newValues[u];
        }
    }
}

