/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.image.histogram;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.imglib2.histogram.BinMapper1d;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.histogram.Real1dBinMapper;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Pair;
import org.scijava.ops.spi.Nullable;
import org.scijava.ops.spi.OpDependency;

public class HistogramCreate<T extends RealType<T>>
implements BiFunction<Iterable<T>, Integer, Histogram1d<T>> {
    public static final int DEFAULT_NUM_BINS = 256;
    @OpDependency(name="stats.minMax")
    private Function<Iterable<T>, Pair<T, T>> minMaxFunc;

    @Override
    public Histogram1d<T> apply(Iterable<T> input, @Nullable Integer numBins) {
        if (numBins == null) {
            numBins = 256;
        }
        Pair<T, T> res = this.minMaxFunc.apply(input);
        Histogram1d histogram1d = new Histogram1d((BinMapper1d)new Real1dBinMapper(((RealType)res.getA()).getRealDouble(), ((RealType)res.getB()).getRealDouble(), (long)numBins.intValue(), false));
        histogram1d.countData(input);
        return histogram1d;
    }
}

