/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.stats;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import org.scijava.function.Computers;
import org.scijava.ops.spi.OpDependency;

public class DefaultGeometricMean<I extends RealType<I>, O extends RealType<O>>
implements Computers.Arity1<RandomAccessibleInterval<I>, O> {
    @OpDependency(name="stats.size")
    private Computers.Arity1<RandomAccessibleInterval<I>, O> sizeComputer;
    @OpDependency(name="stats.sumOfLogs")
    private Computers.Arity1<RandomAccessibleInterval<I>, O> sumOfLogsComputer;

    public void compute(RandomAccessibleInterval<I> input, O geometricMean) {
        RealType size = (RealType)geometricMean.createVariable();
        this.sizeComputer.compute(input, (Object)size);
        RealType sumOfLogs = (RealType)geometricMean.createVariable();
        this.sumOfLogsComputer.compute(input, (Object)sumOfLogs);
        if (size.getRealDouble() != 0.0) {
            geometricMean.setReal(Math.exp(sumOfLogs.getRealDouble() / size.getRealDouble()));
        } else {
            geometricMean.setReal(0.0f);
        }
    }
}

