/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.stats;

import net.imglib2.algorithm.neighborhood.RectangleNeighborhood;
import net.imglib2.converter.RealDoubleConverter;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.AbstractRealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.function.Computers;
import org.scijava.ops.image.image.integral.IntegralCursor;
import org.scijava.ops.image.stats.IntegralMean;

public class IntegralSum<I extends RealType<I>>
implements Computers.Arity1<RectangleNeighborhood<I>, DoubleType> {
    public void compute(RectangleNeighborhood<I> input, DoubleType integralSum) {
        IntegralCursor<I> cursor = new IntegralCursor<I>(input);
        int dimensions = input.numDimensions();
        DoubleType sum = new DoubleType();
        sum.setZero();
        RealDoubleConverter conv = new RealDoubleConverter();
        DoubleType valueAsDoubleType = new DoubleType();
        while (cursor.hasNext()) {
            RealType value = (RealType)((RealType)cursor.next()).copy();
            conv.convert((Object)value, (Object)valueAsDoubleType);
            int cornerInteger = cursor.getCornerRepresentation();
            DoubleType factor = new DoubleType(Math.pow(-1.0, dimensions - IntegralMean.norm(cornerInteger)));
            valueAsDoubleType.mul((AbstractRealType)factor);
            sum.add((AbstractRealType)valueAsDoubleType);
        }
        integralSum.set((AbstractRealType)sum);
    }
}

