/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.threshold;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhood;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.outofbounds.OutOfBoundsBorderFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import net.imglib2.view.composite.Composite;
import net.imglib2.view.composite.CompositeIntervalView;
import org.scijava.function.Computers;
import org.scijava.ops.spi.OpDependency;
import org.scijava.ops.spi.OpExecutionException;

public abstract class ApplyLocalThresholdIntegral<T extends RealType<T>, U extends RealType<U>> {
    private final OutOfBoundsFactory<T, RandomAccessibleInterval<T>> DEFAULT_OUT_OF_BOUNDS_FACTORY = new OutOfBoundsBorderFactory();
    @OpDependency(name="image.integral")
    private Function<RandomAccessibleInterval<T>, RandomAccessibleInterval<U>> integralImgOp;
    @OpDependency(name="image.squareIntegral")
    private Function<RandomAccessibleInterval<T>, RandomAccessibleInterval<U>> squareIntegralImgOp;

    public OutOfBoundsFactory<T, RandomAccessibleInterval<T>> defaultOutOfBoundsFactory() {
        return this.DEFAULT_OUT_OF_BOUNDS_FACTORY;
    }

    protected Function<RandomAccessibleInterval<T>, RandomAccessibleInterval<U>> getIntegralImageOp(int integralImageOrder) {
        if (integralImageOrder == 1) {
            return this.integralImgOp;
        }
        if (integralImageOrder == 2) {
            return this.squareIntegralImgOp;
        }
        throw new OpExecutionException("Threshold op requires to compute an integral image of order " + integralImageOrder + ". There is no op available to do that (available orders are: 1, 2).");
    }

    protected void compute(RandomAccessibleInterval<T> input, RectangleShape inputNeighborhoodShape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBoundsFactory, List<Function<RandomAccessibleInterval<T>, RandomAccessibleInterval<U>>> integralImageOps, Computers.Arity2<RectangleNeighborhood<? extends Composite<U>>, T, BitType> thresholdOp, RandomAccessibleInterval<BitType> output) {
        if (outOfBoundsFactory == null) {
            outOfBoundsFactory = this.defaultOutOfBoundsFactory();
        }
        inputNeighborhoodShape = new RectangleShape(inputNeighborhoodShape.getSpan() + 1, false);
        ArrayList<RandomAccessibleInterval<U>> listOfIntegralImages = new ArrayList<RandomAccessibleInterval<U>>(integralImageOps.size());
        for (Function<RandomAccessibleInterval<T>, RandomAccessibleInterval<U>> integralImageOp : integralImageOps) {
            RandomAccessibleInterval<U> requiredIntegralImg = this.getIntegralImage(input, inputNeighborhoodShape, outOfBoundsFactory, integralImageOp);
            listOfIntegralImages.add(requiredIntegralImg);
        }
        RandomAccessibleInterval stacked = Views.stack(listOfIntegralImages);
        CompositeIntervalView compositeRAI = Views.collapse((RandomAccessibleInterval)stacked);
        RandomAccessibleInterval<T> extendedCompositeRAI = ApplyLocalThresholdIntegral.removeLeadingZeros(compositeRAI, inputNeighborhoodShape);
        RandomAccessibleInterval<RectangleNeighborhood<T>> neighborhoodsRAI = this.asRectangularNeighborhoodInterval(inputNeighborhoodShape, extendedCompositeRAI);
        LoopBuilder.setImages(neighborhoodsRAI, input, output).multiThreaded().forEachPixel((arg_0, arg_1, arg_2) -> thresholdOp.compute(arg_0, arg_1, arg_2));
    }

    private <A> RandomAccessibleInterval<RectangleNeighborhood<A>> asRectangularNeighborhoodInterval(RectangleShape inputNeighborhoodShape, RandomAccessibleInterval<A> extendedCompositeRAI) {
        RectangleShape.NeighborhoodsAccessible neighborhoods = inputNeighborhoodShape.neighborhoodsRandomAccessibleSafe(extendedCompositeRAI);
        IntervalView interval = Views.interval((RandomAccessible)neighborhoods, extendedCompositeRAI);
        if (!(Util.getTypeFromInterval((Interval)interval) instanceof RectangleNeighborhood)) {
            throw new IllegalStateException("RectangleShape did not produce a RandomAccess<RectangleNeighborhood>!");
        }
        IntervalView result = interval;
        return result;
    }

    private RandomAccessibleInterval<U> getIntegralImage(RandomAccessibleInterval<T> input, RectangleShape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBoundsFactory, Function<RandomAccessibleInterval<T>, RandomAccessibleInterval<U>> integralOp) {
        ExtendedRandomAccessibleInterval extendedInput = Views.extend(input, outOfBoundsFactory);
        FinalInterval expandedInterval = Intervals.expand(input, (long)((long)shape.getSpan() - 1L));
        IntervalView offsetInterval2 = Views.offsetInterval((RandomAccessible)extendedInput, (Interval)expandedInterval);
        RandomAccessibleInterval<U> img = integralOp.apply((RandomAccessibleInterval<IntervalView>)offsetInterval2);
        return ApplyLocalThresholdIntegral.addLeadingZeros(img);
    }

    private static <T extends RealType<T>> RandomAccessibleInterval<T> addLeadingZeros(RandomAccessibleInterval<T> input) {
        long[] min = Intervals.minAsLongArray(input);
        long[] max = Intervals.maxAsLongArray(input);
        int i = 0;
        while (i < max.length) {
            int n = i++;
            min[n] = min[n] - 1L;
        }
        RealType realZero = (RealType)((RealType)Util.getTypeFromInterval(input)).copy();
        realZero.setZero();
        ExtendedRandomAccessibleInterval extendedImg = Views.extendValue(input, (float)realZero.getRealFloat());
        IntervalView offsetInterval = Views.interval((RandomAccessible)extendedImg, (long[])min, (long[])max);
        return Views.zeroMin((RandomAccessibleInterval)offsetInterval);
    }

    private static <T> RandomAccessibleInterval<T> removeLeadingZeros(RandomAccessibleInterval<T> input, RectangleShape shape) {
        long[] min = Intervals.minAsLongArray(input);
        long[] max = Intervals.maxAsLongArray(input);
        int d = 0;
        while (d < input.numDimensions()) {
            int correctedSpan = shape.getSpan() - 1;
            int n = d;
            min[n] = min[n] + (long)(1 + correctedSpan);
            int n2 = d++;
            max[n2] = max[n2] - (long)correctedSpan;
        }
        FinalInterval interval = new FinalInterval(min, max);
        return Views.offsetInterval((RandomAccessible)Views.extendBorder(input), (Interval)interval);
    }
}

