/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.threshold.localMidGrey;

import java.util.function.Function;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Pair;
import org.scijava.function.Computers;
import org.scijava.ops.spi.OpDependency;

public class ComputeLocalMidGreyThreshold<T extends RealType<T>>
implements Computers.Arity3<Iterable<T>, T, Double, BitType> {
    @OpDependency(name="stats.minMax")
    private Function<Iterable<T>, Pair<T, T>> minMaxOp;

    public void compute(Iterable<T> inputNeighborhood, T inputCenterPixel, Double c, BitType output) {
        ComputeLocalMidGreyThreshold.compute(inputNeighborhood, inputCenterPixel, c, this.minMaxOp, output);
    }

    public static <T extends RealType<T>> void compute(Iterable<T> inputNeighborhood, T inputCenterPixel, Double c, Function<Iterable<T>, Pair<T, T>> minMaxOp, BitType output) {
        Pair<T, T> outputs = minMaxOp.apply(inputNeighborhood);
        double minValue = ((RealType)outputs.getA()).getRealDouble();
        double maxValue = ((RealType)outputs.getB()).getRealDouble();
        output.set(inputCenterPixel.getRealDouble() > (maxValue + minValue) / 2.0 - c);
    }
}

