/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.threshold.localNiblack;

import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.function.Computers;
import org.scijava.ops.spi.OpDependency;

public class ComputeLocalNiblackThreshold<T extends RealType<T>>
implements Computers.Arity4<Iterable<T>, T, Double, Double, BitType> {
    @OpDependency(name="stats.mean")
    private Computers.Arity1<Iterable<T>, DoubleType> meanOp;
    @OpDependency(name="stats.stdDev")
    private Computers.Arity1<Iterable<T>, DoubleType> stdDeviationOp;

    public void compute(Iterable<T> inputNeighborhood, T inputCenterPixel, Double c, Double k, BitType output) {
        ComputeLocalNiblackThreshold.compute(inputNeighborhood, inputCenterPixel, c, k, this.meanOp, this.stdDeviationOp, output);
    }

    public static <T extends RealType<T>> void compute(Iterable<T> inputNeighborhood, T inputCenterPixel, Double c, Double k, Computers.Arity1<Iterable<T>, DoubleType> meanOp, Computers.Arity1<Iterable<T>, DoubleType> stdDeviationOp, BitType output) {
        DoubleType m = new DoubleType();
        meanOp.compute(inputNeighborhood, (Object)m);
        DoubleType stdDev = new DoubleType();
        stdDeviationOp.compute(inputNeighborhood, (Object)stdDev);
        output.set(inputCenterPixel.getRealDouble() > m.getRealDouble() + k * stdDev.getRealDouble() - c);
    }
}

