/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.threshold.percentile;

import net.imglib2.histogram.Histogram1d;
import net.imglib2.type.numeric.RealType;
import org.scijava.ops.image.threshold.AbstractComputeThresholdHistogram;

public class ComputePercentileThreshold<T extends RealType<T>>
extends AbstractComputeThresholdHistogram<T> {
    @Override
    public long computeBin(Histogram1d<T> hist) {
        long[] histogram = hist.toLongArray();
        return ComputePercentileThreshold.computeBin(histogram);
    }

    public static long computeBin(long[] histogram) {
        int threshold = -1;
        double ptile = 0.5;
        double[] avec = new double[histogram.length];
        for (int i = 0; i < histogram.length; ++i) {
            avec[i] = 0.0;
        }
        double total = ComputePercentileThreshold.partialSum(histogram, histogram.length - 1);
        double temp = 1.0;
        for (int i = 0; i < histogram.length; ++i) {
            avec[i] = Math.abs(ComputePercentileThreshold.partialSum(histogram, i) / total - 0.5);
            if (!(avec[i] < temp)) continue;
            temp = avec[i];
            threshold = i;
        }
        return threshold;
    }

    private static double partialSum(long[] y, int j) {
        double x = 0.0;
        for (int i = 0; i <= j; ++i) {
            x += (double)y[i];
        }
        return x;
    }
}

