/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.tutorial;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import org.scijava.ops.api.OpEnvironment;

public class OpPriorities {
    public final Function<Iterable<Integer>, String> iterableFunc = n -> {
        int max = Integer.MIN_VALUE;
        for (Integer object : n) {
            if (object <= max) continue;
            max = object;
        }
        return "This maximum (Iterable Op): " + max;
    };
    public final Function<SortedSet<Integer>, String> listFunc = n -> "This maximum (SortedSet Op): " + n.last();

    public static void main(String ... args) {
        OpEnvironment ops = OpEnvironment.build();
        List<Integer> ourNumbers = Arrays.asList(4, 8, 2, 3);
        ArrayList<Integer> list = new ArrayList<Integer>(ourNumbers);
        String resultForAllIterables = (String)ops.op("tutorial.priority").input(list).outType(String.class).apply();
        System.out.println(resultForAllIterables);
        TreeSet<Integer> set = new TreeSet<Integer>(ourNumbers);
        String resultForATreeSet = (String)ops.op("tutorial.priority").input(set).outType(String.class).apply();
        System.out.println(resultForATreeSet);
    }
}

