/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.progress;

import java.util.function.Function;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.progress.Progress;

public class ImproperReportingTest {
    private final Function<Integer, Integer> subtask = in -> in;

    @Test
    public void testDefineTooFewStages() {
        this.assertISEFromTask(() -> {
            Progress.defineTotal((long)2L);
            for (int i = 0; i < 3; ++i) {
                Progress.update();
            }
            return "All done";
        });
    }

    @Test
    public void testDefineTooManyStages() {
        this.assertISEFromTask(() -> {
            Progress.defineTotal((long)3L);
            for (int i = 0; i < 2; ++i) {
                Progress.update();
            }
            return "All done!";
        });
    }

    @Test
    public void testDefineTooFewSubTasks() {
        this.assertISEFromTask(() -> {
            Progress.defineTotal((long)0L, (long)2L);
            for (int i = 0; i < 3; ++i) {
                Progress.register(this.subtask);
                this.subtask.apply(4);
                Progress.complete();
            }
            return "All done!";
        });
    }

    @Test
    public void testDefineTooManySubTasks() {
        this.assertISEFromTask(() -> {
            Progress.defineTotal((long)0L, (long)3L);
            for (int i = 0; i < 2; ++i) {
                Progress.register(this.subtask);
                this.subtask.apply(4);
                Progress.complete();
            }
            return "All done!";
        });
    }

    private void assertISEFromTask(Supplier<?> task) {
        Assertions.assertThrows(IllegalStateException.class, () -> {
            Progress.register((Object)task);
            task.get();
            Progress.complete();
        });
    }
}

