/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.progress;

import java.util.function.Consumer;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.progress.Progress;
import org.scijava.progress.Task;

public class StatusBasedProgressTest {
    public final Function<Integer, Integer> statusSpinningTask = in -> {
        for (int i = 0; i < in; ++i) {
            Progress.setStatus((String)("Setting status: " + (i + 1)));
        }
        return in;
    };

    @Test
    public void testStatusUpdate() {
        Function<Integer, Integer> progressible = this.statusSpinningTask;
        final int numIterations = 10;
        Progress.addListener(progressible, (Consumer)new Consumer<Task>(){
            boolean registered = false;
            int numUpdates = 0;

            @Override
            public void accept(Task task) {
                if (!this.registered) {
                    this.registered = true;
                    return;
                }
                if (this.numUpdates++ < numIterations) {
                    Assertions.assertEquals((Object)task.status(), (Object)("Setting status: " + this.numUpdates));
                } else {
                    Assertions.assertEquals((double)1.0, (double)task.progress(), (double)1.0E-6);
                }
            }
        });
        Progress.register(progressible);
        progressible.apply(numIterations);
        Progress.complete();
    }
}

