/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.progress;

import java.util.function.Consumer;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.progress.DependentComplexProgressReportingTask;
import org.scijava.progress.DependentProgressReportingTask;
import org.scijava.progress.Progress;
import org.scijava.progress.Task;

public class SubtaskProgressTest {
    public final Function<Integer, Integer> iterator = iterations -> {
        Progress.defineTotal((long)iterations.intValue());
        for (int i = 0; i < iterations; ++i) {
            Progress.update();
        }
        return iterations;
    };

    @Test
    public void testComplexDependentReporter() {
        DependentComplexProgressReportingTask progressible = new DependentComplexProgressReportingTask(this.iterator);
        int numIterations = 2;
        String id = "Running a complex Task with subtasks";
        Progress.addListener((Object)progressible, (Consumer)new Consumer<Task>(){
            int itr = 0;
            final double[] expProgress = new double[]{0.0, 0.0, 0.16666666666666666, 0.3333333333333333, 0.3333333333333333, 0.5, 0.6666666666666666, 0.6666666666666666, 0.8333333333333334, 1.0, 1.0, 1.0};

            @Override
            public void accept(Task task) {
                Assertions.assertEquals((double)this.expProgress[this.itr++], (double)task.progress(), (double)1.0E-6);
                Assertions.assertEquals((Object)(this.itr == this.expProgress.length ? 1 : 0), (Object)task.isComplete());
            }
        });
        Progress.register((Object)progressible, (String)id);
        progressible.apply(numIterations);
        Progress.complete();
    }

    @Test
    public void testDependentReporter() {
        DependentProgressReportingTask progressible = new DependentProgressReportingTask(this.iterator);
        int numIterations = 2;
        String id = "Running a task with subtasks";
        Progress.addListener((Object)progressible, (Consumer)new Consumer<Task>(){
            int itr = 0;
            final double[] expProgress = new double[]{0.0, 0.0, 0.16666666666666666, 0.3333333333333333, 0.3333333333333333, 0.3333333333333333, 0.5, 0.6666666666666666, 0.6666666666666666, 0.6666666666666666, 0.8333333333333334, 1.0, 1.0, 1.0};

            @Override
            public void accept(Task task) {
                Assertions.assertEquals((double)this.expProgress[this.itr++], (double)task.progress(), (double)1.0E-6);
                Assertions.assertEquals((Object)(this.itr == this.expProgress.length ? 1 : 0), (Object)task.isComplete());
            }
        });
        Progress.register((Object)progressible, (String)id);
        progressible.apply(numIterations);
        Progress.complete();
    }
}

