/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.progress;

import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.scijava.progress.Task;

public class TestSuiteTaskConsumer
implements Consumer<Task> {
    private final String id;
    private final long expectedIterations;
    private double currentIterations = 0.0;
    private boolean registered = false;
    private boolean completed = false;

    public TestSuiteTaskConsumer(long expectedIterations) {
        this(expectedIterations, null);
    }

    public TestSuiteTaskConsumer(long expectedIterations, String id) {
        this.id = id;
        this.expectedIterations = expectedIterations;
    }

    @Override
    public void accept(Task task) {
        if (this.id != null && !task.description().equals(this.id)) {
            return;
        }
        if (!this.registered) {
            this.registered = true;
            return;
        }
        if (!task.isComplete()) {
            Assertions.assertEquals((double)((this.currentIterations += 1.0) / (double)this.expectedIterations), (double)task.progress(), (double)1.0E-6);
        } else {
            Assertions.assertFalse((boolean)this.completed);
            Assertions.assertEquals((double)1.0, (double)task.progress(), (double)1.0E-6);
            this.completed = true;
        }
    }

    public boolean isComplete() {
        return this.completed;
    }

    public void reset() {
        this.currentIterations = 0.0;
        this.registered = false;
        this.completed = false;
    }

    public double progress() {
        return this.currentIterations / (double)this.expectedIterations;
    }
}

