/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.struct;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.scijava.struct.ItemIO;
import org.scijava.struct.ItemVisibility;
import org.scijava.struct.Parameter;
import org.scijava.struct.ParameterMember;

public abstract class AnnotatedParameterMember<T>
implements ParameterMember<T> {
    private final Type itemType;
    private final Parameter annotation;

    public AnnotatedParameterMember(Type itemType, Parameter annotation) {
        this.itemType = itemType;
        this.annotation = annotation;
    }

    public Parameter getAnnotation() {
        return this.annotation;
    }

    @Override
    public ItemVisibility getVisibility() {
        return this.getAnnotation().visibility();
    }

    @Override
    public boolean isAutoFill() {
        return this.getAnnotation().autoFill();
    }

    @Override
    public boolean isRequired() {
        return this.getAnnotation().required();
    }

    @Override
    public boolean isPersisted() {
        return this.getAnnotation().persist();
    }

    @Override
    public String getPersistKey() {
        return this.getAnnotation().persistKey();
    }

    @Override
    public String getInitializer() {
        return this.getAnnotation().initializer();
    }

    @Override
    public String getValidater() {
        return this.getAnnotation().validater();
    }

    @Override
    public String getCallback() {
        return this.getAnnotation().callback();
    }

    @Override
    public String getWidgetStyle() {
        return this.getAnnotation().style();
    }

    @Override
    public Object getMinimumValue() {
        return this.getAnnotation().min();
    }

    @Override
    public Object getMaximumValue() {
        return this.getAnnotation().max();
    }

    @Override
    public Object getStepSize() {
        return this.getAnnotation().stepSize();
    }

    @Override
    public List<Object> getChoices() {
        String[] choices = this.getAnnotation().choices();
        if (choices.length == 0) {
            return ParameterMember.super.getChoices();
        }
        return Arrays.asList((Object[])choices);
    }

    public String key() {
        return this.getAnnotation().key();
    }

    public Type type() {
        return this.itemType;
    }

    public ItemIO getIOType() {
        return this.getAnnotation().type();
    }

    public boolean isStruct() {
        return this.getAnnotation().struct();
    }
}

