/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import org.scijava.java3d.Appearance;
import org.scijava.java3d.BranchGroup;
import org.scijava.java3d.Geometry;
import org.scijava.java3d.GeometryArray;
import org.scijava.java3d.Group;
import org.scijava.java3d.ImageComponent;
import org.scijava.java3d.ImageComponent2D;
import org.scijava.java3d.Node;
import org.scijava.java3d.Shape3D;
import org.scijava.java3d.Texture;
import org.scijava.java3d.Texture2D;
import org.scijava.java3d.TextureAttributes;
import visad.BadMappingException;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.DisplayTupleType;
import visad.GraphicsModeControl;
import visad.MathType;
import visad.RealTupleType;
import visad.ScalarMap;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.ShadowFunctionOrSetType;
import visad.ShadowRealTupleType;
import visad.ShadowRealType;
import visad.ShadowType;
import visad.Unit;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADTriangleStripArray;
import visad.bom.ImageRendererJ3D;
import visad.bom.TextureFillRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.ShadowSetTypeJ3D;

public class ShadowTextureFillSetTypeJ3D
extends ShadowSetTypeJ3D {
    private static final int MISSING1 = -128;
    private DisplayImplJ3D display = null;

    public ShadowTextureFillSetTypeJ3D(MathType t, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        super(t, link, parent);
        this.display = (DisplayImplJ3D)link.getDisplay();
    }

    @Override
    public boolean doTransform(Object group, Data data, float[] value_array, float[] default_values, DataRenderer renderer) throws VisADException, RemoteException {
        int i;
        RealTupleType ref;
        int domain_length;
        DataDisplayLink link = renderer.getLink();
        if (data.isMissing()) {
            ((ImageRendererJ3D)renderer).markMissingVisADBranch();
            return false;
        }
        if (this.getLevelOfDifficulty() == 6) {
            return false;
        }
        ShadowFunctionOrSetType adaptedShadowType = (ShadowFunctionOrSetType)this.getAdaptedShadowType();
        DisplayImpl display = this.getDisplay();
        GraphicsModeControl mode = (GraphicsModeControl)display.getGraphicsModeControl().clone();
        boolean anyContour = adaptedShadowType.getAnyContour();
        boolean anyFlow = adaptedShadowType.getAnyFlow();
        boolean anyShape = adaptedShadowType.getAnyShape();
        boolean anyText = adaptedShadowType.getAnyText();
        if (anyContour || anyFlow || anyShape || anyText) {
            throw new BadMappingException("no contour, flow, shape or text allowed");
        }
        int valueArrayLength = display.getValueArrayLength();
        int[] valueToScalar = display.getValueToScalar();
        int[] valueToMap = display.getValueToMap();
        Vector MapVector = display.getMapVector();
        float[][] display_values = new float[valueArrayLength][];
        int[] inherited_values = adaptedShadowType.getInheritedValues();
        for (int i2 = 0; i2 < valueArrayLength; ++i2) {
            if (inherited_values[i2] <= 0) continue;
            display_values[i2] = new float[1];
            display_values[i2][0] = value_array[i2];
        }
        Set domain_set = (Set)data;
        Unit[] dataUnits = domain_set.getSetUnits();
        CoordinateSystem dataCoordinateSystem = domain_set.getCoordinateSystem();
        float[][] domain_values = null;
        double[][] domain_doubles = null;
        ShadowRealTupleType Domain2 = adaptedShadowType.getDomain();
        Unit[] domain_units = ((RealTupleType)Domain2.getType()).getDefaultUnits();
        try {
            domain_length = domain_set.getLength();
            int domain_dimension = domain_set.getDimension();
        }
        catch (SetException e) {
            return false;
        }
        ShadowRealType[] DomainComponents = adaptedShadowType.getDomainComponents();
        if (!adaptedShadowType.getIsTerminal()) {
            throw new DisplayException("not Terminal");
        }
        if (!Domain2.getAllSpatial() || Domain2.getMultipleDisplayScalar()) {
            throw new BadMappingException("domain must be only spatial");
        }
        float[][] spline_domain = domain_set.getSamples();
        spline_domain = Unit.convertTuple(spline_domain, dataUnits, domain_units, false);
        ShadowRealTupleType domain_reference = Domain2.getReference();
        ShadowRealType[] DC = DomainComponents;
        if (domain_reference != null && domain_reference.getMappedDisplayScalar()) {
            ref = (RealTupleType)domain_reference.getType();
            renderer.setEarthSpatialData(Domain2, domain_reference, ref, ref.getDefaultUnits(), (RealTupleType)Domain2.getType(), new CoordinateSystem[]{dataCoordinateSystem}, domain_units);
            spline_domain = CoordinateSystem.transformCoordinates(ref, null, ref.getDefaultUnits(), null, (RealTupleType)Domain2.getType(), dataCoordinateSystem, domain_units, null, spline_domain);
            DC = adaptedShadowType.getDomainReferenceComponents();
        } else {
            ref = domain_reference == null ? null : (RealTupleType)domain_reference.getType();
            Unit[] ref_units = ref == null ? null : ref.getDefaultUnits();
            renderer.setEarthSpatialData(Domain2, domain_reference, ref, ref_units, (RealTupleType)Domain2.getType(), new CoordinateSystem[]{dataCoordinateSystem}, domain_units);
        }
        int[] tuple_index = new int[3];
        int[] spatial_value_indices = new int[]{-1, -1, -1};
        ScalarMap[] spatial_maps = new ScalarMap[3];
        DisplayTupleType spatial_tuple = null;
        for (int i3 = 0; i3 < DC.length; ++i3) {
            Enumeration maps = DC[i3].getSelectedMapVector().elements();
            ScalarMap map = (ScalarMap)maps.nextElement();
            DisplayRealType real = map.getDisplayScalar();
            spatial_tuple = real.getTuple();
            if (spatial_tuple == null) {
                throw new DisplayException("texture with bad tuple: ShadowTextureFillSetTypeJ3D.doTransform");
            }
            tuple_index[i3] = real.getTupleIndex();
            spatial_value_indices[tuple_index[i3]] = map.getValueIndex();
            spatial_maps[tuple_index[i3]] = map;
            if (!maps.hasMoreElements()) continue;
            throw new DisplayException("texture with multiple spatial: ShadowTextureFillSetTypeJ3D.doTransform");
        }
        tuple_index[2] = 3 - (tuple_index[0] + tuple_index[1]);
        DisplayRealType real = (DisplayRealType)spatial_tuple.getComponent(tuple_index[2]);
        int value2_index = display.getDisplayScalarIndex(real);
        float value2 = default_values[value2_index];
        for (int i4 = 0; i4 < valueArrayLength; ++i4) {
            if (inherited_values[i4] <= 0 || !real.equals(display.getDisplayScalar(valueToScalar[i4]))) continue;
            value2 = value_array[i4];
            break;
        }
        Object spatial_values = new float[3][];
        spatial_values[tuple_index[0]] = spline_domain[0];
        spatial_values[tuple_index[1]] = spline_domain[1];
        spatial_values[tuple_index[2]] = new float[domain_length];
        for (i = 0; i < domain_length; ++i) {
            spatial_values[tuple_index[2]][i] = value2;
        }
        for (i = 0; i < 3; ++i) {
            if (spatial_maps[i] == null) continue;
            spatial_values[i] = spatial_maps[i].scaleValues(spatial_values[i]);
        }
        float scale = ((TextureFillRendererJ3D)renderer).getScale();
        float[][] tex_values = new float[3][domain_length];
        for (int i5 = 0; i5 < domain_length; ++i5) {
            tex_values[0][i5] = scale * spatial_values[tuple_index[0]][i5];
            tex_values[1][i5] = scale * spatial_values[tuple_index[1]][i5];
            tex_values[2][i5] = scale * spatial_values[tuple_index[2]][i5];
        }
        if (spatial_tuple.equals(Display.DisplaySpatialCartesianTuple)) {
            renderer.setEarthSpatialDisplay(null, spatial_tuple, display, spatial_value_indices, default_values, null);
        } else {
            CoordinateSystem coord = spatial_tuple.getCoordinateSystem();
            spatial_values = coord.toReference((float[][])spatial_values);
            renderer.setEarthSpatialDisplay(coord, spatial_tuple, display, spatial_value_indices, default_values, null);
        }
        SetType type = new SetType(Display.DisplaySpatialCartesianTuple);
        Set spatial_set = this.makeSpatialSet(domain_set, type, (float[][])spatial_values);
        Set tex_set = this.makeSpatialSet(domain_set, type, tex_values);
        boolean indexed = this.wantIndexed();
        byte[][] color_values = null;
        VisADGeometryArray array = spatial_set.make2DGeometry(color_values, indexed);
        VisADGeometryArray tex_array = tex_set.make2DGeometry(color_values, indexed);
        float[] coordinates = array.coordinates;
        float[] tex = tex_array.coordinates;
        int nn = coordinates.length / 3;
        float[] texCoords = new float[2 * nn];
        boolean spatial_all_select = true;
        for (int i6 = 0; i6 < 3 * nn; ++i6) {
            if (coordinates[i6] == coordinates[i6]) continue;
            spatial_all_select = false;
        }
        int j = 0;
        for (int i7 = 0; i7 < 3 * nn; i7 += 3) {
            texCoords[j] = tex[i7];
            texCoords[j + 1] = tex[i7 + 1];
            j += 2;
        }
        array.texCoords = texCoords;
        if (!spatial_all_select) {
            array = (VisADTriangleStripArray)array.removeMissing();
        }
        if (adaptedShadowType.getAdjustProjectionSeam()) {
            array = (VisADTriangleStripArray)array.adjustLongitude(renderer);
            array = (VisADTriangleStripArray)array.adjustSeam(renderer);
        }
        int texture_width = ((TextureFillRendererJ3D)renderer).getTextureWidth();
        int texture_height = ((TextureFillRendererJ3D)renderer).getTextureHeight();
        int[] color_ints = ((TextureFillRendererJ3D)renderer).getTexture();
        BufferedImage image = this.createImage(texture_width, texture_height, texture_width, texture_height, color_ints);
        this.textureToGroup(group, array, image, mode, texture_width, texture_height, renderer);
        this.ensureNotEmpty(group);
        return false;
    }

    public void textureToGroup(Object group, VisADGeometryArray array, BufferedImage image, GraphicsModeControl mode, int texture_width, int texture_height, DataRenderer renderer) throws VisADException {
        GeometryArray geometry = this.display.makeGeometry(array);
        Appearance appearance = this.makeAppearance(mode, null, null, geometry, false);
        TextureAttributes texture_attributes = new TextureAttributes();
        texture_attributes.setTextureMode(5);
        texture_attributes.setPerspectiveCorrectionMode(1);
        appearance.setTextureAttributes(texture_attributes);
        Texture2D texture = new Texture2D(1, 6, texture_width, texture_height);
        texture.setCapability(4);
        ImageComponent2D image2d = new ImageComponent2D(2, image);
        image2d.setCapability(2);
        texture.setImage(0, (ImageComponent)image2d);
        if (((TextureFillRendererJ3D)renderer).getSmooth()) {
            texture.setMinFilter(3);
            texture.setMagFilter(3);
        } else {
            texture.setMinFilter(2);
            texture.setMagFilter(2);
        }
        texture.setBoundaryModeS(3);
        texture.setBoundaryModeT(3);
        texture.setEnable(true);
        Shape3D shape = new Shape3D((Geometry)geometry, appearance);
        shape.setCapability(14);
        appearance.setTexture((Texture)texture);
        appearance.setCapability(2);
        BranchGroup branch = new BranchGroup();
        branch.setCapability(17);
        branch.setCapability(12);
        branch.addChild((Node)shape);
        if (((Group)group).numChildren() > 0) {
            ((Group)group).setChild((Node)branch, 0);
        } else {
            ((Group)group).addChild((Node)branch);
        }
    }

    public BufferedImage createImage(int data_width, int data_height, int texture_width, int texture_height, int[] color_ints) {
        int i;
        int j;
        BufferedImage image = null;
        ColorModel colorModel = ColorModel.getRGBdefault();
        WritableRaster raster = colorModel.createCompatibleWritableRaster(texture_width, texture_height);
        image = new BufferedImage(colorModel, raster, false, null);
        int[] intData = ((DataBufferInt)raster.getDataBuffer()).getData();
        int k = 0;
        int m = 0;
        for (j = 0; j < data_height; ++j) {
            for (i = 0; i < data_width; ++i) {
                intData[m++] = color_ints[k++];
            }
            for (i = data_width; i < texture_width; ++i) {
                intData[m++] = 0;
            }
        }
        for (j = data_height; j < texture_height; ++j) {
            for (i = 0; i < texture_width; ++i) {
                intData[m++] = 0;
            }
        }
        return image;
    }
}

