/*
 * Decompiled with CFR 0.152.
 */
package visad.data.fits;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Vector;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import nom.tam.fits.ImageHDU;
import nom.tam.fits.PrimaryHDU;
import visad.Data;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.Integer2DSet;
import visad.IntegerNDSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.VisADException;
import visad.data.fits.ExceptionStack;
import visad.data.fits.FitsTourGuide;
import visad.data.fits.TourInspector;
import visad.data.fits.TourWriter;

public class FitsAdapter {
    Fits fits = null;
    Data[] data = null;
    ExceptionStack stack = null;

    public FitsAdapter() throws VisADException {
    }

    public FitsAdapter(String filename) throws VisADException {
        this();
        try {
            this.fits = new Fits(filename);
        }
        catch (FitsException e) {
            throw new VisADException(((Object)((Object)e)).getClass().getName() + "(" + e.getMessage() + ")");
        }
    }

    public FitsAdapter(URL url) throws VisADException {
        this();
        try {
            this.fits = new Fits(url);
        }
        catch (FitsException e) {
            throw new VisADException(((Object)((Object)e)).getClass().getName() + "(" + e.getMessage() + ")");
        }
    }

    private int get1DLength(Object data) throws VisADException {
        if (!data.getClass().isArray()) {
            return 1;
        }
        int len = Array.getLength(data);
        int total = 0;
        for (int i = 0; i < len; ++i) {
            total += this.get1DLength(Array.get(data, i));
        }
        return total;
    }

    private int copyArray(Object data, double[] list, int offset) throws VisADException {
        if (data instanceof byte[]) {
            byte[] bl = (byte[])data;
            for (int i = 0; i < bl.length; ++i) {
                int val = bl[i] >= 0 ? bl[i] : 256 + bl[i];
                list[offset++] = val;
            }
        } else if (data instanceof short[]) {
            short[] sl = (short[])data;
            for (int i = 0; i < sl.length; ++i) {
                int val = sl[i] >= 0 ? sl[i] : 65536 - sl[i];
                list[offset++] = val;
            }
        } else if (data instanceof int[]) {
            int[] il = (int[])data;
            for (int i = 0; i < il.length; ++i) {
                list[offset++] = il[i];
            }
        } else if (data instanceof long[]) {
            long[] ll = (long[])data;
            for (int i = 0; i < ll.length; ++i) {
                list[offset++] = ll[i];
            }
        } else if (data instanceof float[]) {
            float[] fl = (float[])data;
            for (int i = 0; i < fl.length; ++i) {
                list[offset++] = fl[i];
            }
        } else if (data instanceof double[]) {
            double[] dl = (double[])data;
            for (int i = 0; i < dl.length; ++i) {
                list[offset++] = dl[i];
            }
        } else {
            throw new VisADException("type '" + data.getClass().getName() + "' not handled");
        }
        return offset;
    }

    private int decompose(Object data, double[] list, int offset) throws VisADException {
        Class<?> component = data.getClass().getComponentType();
        if (component == null) {
            return offset;
        }
        if (!component.isArray()) {
            return this.copyArray(data, list, offset);
        }
        int len = Array.getLength(data);
        for (int i = len - 1; i >= 0; --i) {
            offset = this.decompose(Array.get(data, i), list, offset);
        }
        return offset;
    }

    private double[][] buildRange(Object data) throws VisADException {
        int len = this.get1DLength(data);
        double[] values = new double[len];
        int offset = this.decompose(data, values, 0);
        while (offset < len) {
            values[offset++] = Double.NaN;
        }
        double[][] range = new double[][]{values};
        return range;
    }

    private Data addPrimary(PrimaryHDU hdu) throws FitsException, VisADException, RemoteException {
        int[] axes = hdu.getAxes();
        if (axes == null || axes.length == 0) {
            return null;
        }
        for (int i = 0; i < axes.length / 2; ++i) {
            int j = axes.length - (i + 1);
            int tmp = axes[j];
            axes[j] = axes[i];
            axes[i] = tmp;
        }
        Object fData = hdu.getData().getData();
        if (fData == null) {
            throw new VisADException("No HDU Data");
        }
        if (!fData.getClass().isArray()) {
            throw new VisADException("Unknown HDU Data type: " + fData.getClass().getName());
        }
        RealType[] axisType = new RealType[axes.length];
        for (int i = 0; i < axisType.length; ++i) {
            String name = "NAxis" + (i + 1);
            axisType[i] = RealType.getRealType(name, null, null);
        }
        RealTupleType type = new RealTupleType(axisType);
        RealType value = RealType.getRealType("value", null, null);
        FunctionType func = new FunctionType(type, value);
        IntegerNDSet iSet = new IntegerNDSet((MathType)type, axes);
        FlatField fld = new FlatField(func, iSet);
        fld.setSamples(this.buildRange(fData));
        return fld;
    }

    private Data addImage(ImageHDU hdu) throws VisADException, RemoteException {
        int[] axes;
        try {
            axes = hdu.getAxes();
        }
        catch (FitsException e) {
            axes = null;
        }
        if (axes == null) {
            throw new VisADException("Couldn't get image axes");
        }
        if (axes.length != 2) {
            throw new VisADException("Expected two-dimensional image, not " + axes.length + " dimensions");
        }
        Object fData = hdu.getData().getData();
        if (fData == null) {
            throw new VisADException("No HDU Data");
        }
        if (!fData.getClass().isArray()) {
            throw new VisADException("Unknown HDU Data type: " + fData.getClass().getName());
        }
        RealTupleType type = RealTupleType.SpatialCartesian2DTuple;
        RealType pixel = RealType.getRealType("pixel", null, null);
        FunctionType func = new FunctionType(type, pixel);
        Integer2DSet iSet = new Integer2DSet((MathType)type, axes[0], axes[1]);
        FlatField fld = new FlatField(func, iSet);
        fld.setSamples(this.buildRange(fData));
        return fld;
    }

    private int copyColumn(Object data, double[] list, int offset) throws VisADException {
        Object[] top = (Object[])data;
        if (top.length != 1 && !(top[0] instanceof byte[])) {
            System.err.println("FitsAdapter.copyColumn: Punting on wide column (" + top[0].getClass().getName() + ")");
            return offset;
        }
        if (top[0] instanceof byte[]) {
            if (top.length != 1) {
                System.err.println("Ignoring assumed " + top.length + "-char String column");
                return offset;
            }
            byte[] bl = (byte[])top[0];
            int i = 0;
            while (i < bl.length) {
                list[offset++] = bl[i++];
            }
        } else if (top[0] instanceof short[]) {
            short[] sl = (short[])top[0];
            int i = 0;
            while (i < sl.length) {
                list[offset++] = sl[i++];
            }
        } else if (top[0] instanceof int[]) {
            int[] il = (int[])top[0];
            int i = 0;
            while (i < il.length) {
                list[offset++] = il[i++];
            }
        } else if (top[0] instanceof long[]) {
            long[] ll = (long[])top[0];
            int i = 0;
            while (i < ll.length) {
                list[offset++] = ll[i++];
            }
        } else if (top[0] instanceof float[]) {
            float[] fl = (float[])top[0];
            int i = 0;
            while (i < fl.length) {
                list[offset++] = fl[i++];
            }
        } else if (top[0] instanceof double[]) {
            double[] dl = (double[])top[0];
            int i = 0;
            while (i < dl.length) {
                list[offset++] = dl[i++];
            }
        } else {
            throw new VisADException("type '" + top[0].getClass().getName() + "' not handled");
        }
        return offset;
    }

    private double[][] buildBTRange(BinaryTableHDU hdu) throws VisADException {
        int rows = hdu.getNumRows();
        int cols = hdu.getNumColumns();
        double[][] d = new double[cols][rows];
        for (int i = 0; i < cols; ++i) {
            int len;
            Object[] list;
            try {
                list = hdu.getColumn(i).getData();
            }
            catch (FitsException e) {
                throw new VisADException("Failed to get column " + i + " type: " + e.getMessage());
            }
            if (list instanceof byte[][]) {
                len = this.copyColumn((byte[][])list, d[i], 0);
            } else if (list instanceof short[][]) {
                len = this.copyColumn((short[][])list, d[i], 0);
            } else if (list instanceof int[][]) {
                len = this.copyColumn((int[][])list, d[i], 0);
            } else if (list instanceof long[][]) {
                len = this.copyColumn((long[][])list, d[i], 0);
            } else if (list instanceof float[][]) {
                len = this.copyColumn((float[][])list, d[i], 0);
            } else if (list instanceof double[][]) {
                len = this.copyColumn((double[][])list, d[i], 0);
            } else {
                String type;
                try {
                    type = hdu.getColumnFITSType(i);
                }
                catch (FitsException e) {
                    type = "?Unknown FITS type?";
                }
                System.err.println("FitsAdapter.buildBTRange: Faking values for column #" + i + " (" + type + "=>" + list.getClass().getName() + ")");
                int c = i;
                for (len = 0; len < rows; ++len) {
                    d[c][len] = Double.NaN;
                }
            }
            if (len >= rows) continue;
            int c = i;
            System.err.println("FitsAdapter.buildBTRange: Column " + i + " was short " + (rows - len) + " of " + rows + " rows");
            while (len < rows) {
                d[c][len++] = Double.NaN;
            }
        }
        return d;
    }

    private Data addBinaryTable(BinaryTableHDU hdu) throws FitsException, VisADException, RemoteException {
        int[] axes = hdu.getAxes();
        if (axes == null) {
            throw new FitsException("Couldn't get binary table axes");
        }
        if (axes.length != 2) {
            throw new FitsException("Not a two-dimensional binary table");
        }
        int numColumns = hdu.getNumColumns();
        RealType index = RealType.getRealType("index", null, null);
        boolean hasTextColumn = false;
        RealType[] rowType = new RealType[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            String colType;
            String name = hdu.getColumnName(i);
            if (name == null) {
                name = "Column" + i;
            }
            if ((colType = hdu.getColumnFITSType(i)).startsWith("A") || colType.endsWith("A")) {
                hasTextColumn = true;
            }
            rowType[i] = RealType.getRealType(name, null, null);
        }
        RealTupleType row = new RealTupleType(rowType);
        FunctionType func = new FunctionType(index, row);
        Integer1DSet iSet = new Integer1DSet(hdu.getNumRows());
        FlatField fld = new FlatField(func, iSet);
        fld.setSamples(this.buildBTRange(hdu));
        return fld;
    }

    private Data convertHDU(BasicHDU hdu) throws FitsException, VisADException, RemoteException {
        if (hdu instanceof ImageHDU) {
            return this.addImage((ImageHDU)hdu);
        }
        if (hdu instanceof PrimaryHDU) {
            return this.addPrimary((PrimaryHDU)hdu);
        }
        if (hdu instanceof BinaryTableHDU) {
            return this.addBinaryTable((BinaryTableHDU)hdu);
        }
        return null;
    }

    public void buildData() {
        Vector<Data> vec = new Vector<Data>();
        int startDepth = this.stack == null ? 0 : this.stack.depth();
        int n = 0;
        while (true) {
            try {
                BasicHDU hdu = this.fits.getHDU(n);
                if (hdu == null) break;
                Data d = this.convertHDU(hdu);
                if (d != null) {
                    vec.addElement(d);
                }
            }
            catch (Exception e) {
                if (this.stack == null) {
                    this.stack = new ExceptionStack(e);
                }
                this.stack.addException(e);
                if (this.stack.depth() > startDepth + 10) break;
            }
            ++n;
        }
        if (vec.size() == 0) {
            this.data = null;
        } else {
            this.data = new Data[vec.size()];
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = (Data)vec.elementAt(i);
            }
        }
    }

    public void clearExceptionStack() {
        this.stack = null;
    }

    Data[] getData() throws ExceptionStack, RemoteException, VisADException {
        if (this.data == null) {
            this.buildData();
            if (this.data == null) {
                throw new VisADException("No data");
            }
        }
        if (this.stack != null) {
            throw this.stack;
        }
        return this.data;
    }

    public void save(String name, Data data, boolean replace) throws IOException, RemoteException, VisADException {
        File file = new File(name);
        if (file.exists()) {
            throw new IllegalArgumentException("File \"" + name + "\" exists");
        }
        TourInspector count = new TourInspector(replace);
        FitsTourGuide guide = new FitsTourGuide(data, count);
        count = null;
        Fits f = new Fits();
        TourWriter tw = new TourWriter(replace, f);
        guide = new FitsTourGuide(data, tw);
        tw = null;
        guide = null;
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(name));
        try {
            f.write((OutputStream)bos);
        }
        catch (FitsException e) {
            throw new VisADException(((Object)((Object)e)).getClass().getName() + "(" + e.getMessage() + ")");
        }
        bos.close();
    }
}

