/*
 * Decompiled with CFR 0.152.
 */
package visad.rabin;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.AccessException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import visad.CellImpl;
import visad.ColorControl;
import visad.Control;
import visad.ControlEvent;
import visad.ControlListener;
import visad.Data;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded1DSet;
import visad.Integer1DSet;
import visad.MathType;
import visad.ProjectionControl;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.RemoteCellImpl;
import visad.RemoteDataReference;
import visad.RemoteDataReferenceImpl;
import visad.RemoteDisplayImpl;
import visad.RemoteServer;
import visad.RemoteServerImpl;
import visad.SampledSet;
import visad.ScalarMap;
import visad.ShapeControl;
import visad.Text;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADLineArray;
import visad.data.Form;
import visad.data.netcdf.Plain;
import visad.data.vis5d.Vis5DForm;
import visad.formula.FormulaException;
import visad.formula.FormulaManager;
import visad.formula.FormulaUtil;
import visad.java2d.DirectManipulationRendererJ2D;
import visad.java2d.DisplayImplJ2D;
import visad.java3d.DirectManipulationRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.util.Delay;
import visad.util.LabeledColorWidget;
import visad.util.VisADSlider;

public class Rain
implements ActionListener,
ControlListener {
    RemoteServerImpl server_server = null;
    RemoteServer client_server = null;
    boolean twod = false;
    static final int N_COLUMNS = 3;
    static final int N_ROWS = 4;
    final JPanel[] column_panels = new JPanel[3];
    final JPanel[][] cell_panels = new JPanel[4][3];
    final DataReference[][] cell_refs = new DataReferenceImpl[4][3];
    final CellImpl[][] cells = new CellImpl[4][3];
    final DisplayImpl[][] displays = new DisplayImpl[4][3];
    final RemoteDisplayImpl[][] remote_displays = new RemoteDisplayImpl[4][3];
    final CellImpl[][] formula_update = new CellImpl[4][3];
    final boolean[][] display_done = new boolean[4][3];
    static final String[][] cell_names = new String[][]{{"A1", "B1", "C1"}, {"A2", "B2", "C2"}, {"A3", "B3", "C3"}, {"A4", "B4", "C4"}};
    static final String[][] cell_formulas = new String[][]{{"", "A1[0]", "(10^(extract(B1, 0)/10)/num300) ^ (1/num1_4)"}, {"(10^(extract(B1, 1)/10)/num300) ^ (1/num1_4)", "(10^(extract(B1, 2)/10)/num300) ^ (1/num1_4)", "(10^(extract(B1, 3)/10)/num300) ^ (1/num1_4)"}, {"(10^(extract(B1, 4)/10)/num300) ^ (1/num1_4)", "(10^(extract(B1, 5)/10)/num300) ^ (1/num1_4)", "(10*C1 + 10*A2 + 10*B2 + 10*C2 + 10*A3 + 3*B3)/53"}, {"extract(B1, 6)", "extract(B1, 7)", "extract(B1, 8)"}};
    JLabel[][] cell_fields = new JLabel[4][3];
    static final int WIDTH = 1100;
    static final int HEIGHT = 900;
    static final double MIN = 0.0;
    static final double MAX = 300.0;
    static final double MAXH2 = 10.0;
    DataReference ref300 = null;
    DataReference ref1_4 = null;
    DataReference refMAX = null;
    DataReference ref_cursor = null;
    DataReference ref_vis5d = null;
    DataReference ref_projection = null;
    DataReference ref_colorH1 = null;
    DataReference ref_colorH2 = null;
    DataReference[][] cell_text = new DataReference[4][3];
    VisADSlider slider300;
    LabeledColorWidget color_widgetH1 = null;
    LabeledColorWidget color_widgetH2 = null;
    ColorControl color_controlH1 = null;
    ColorControl color_controlH2 = null;
    ColorControl[][] color_controls = new ColorControl[4][3];
    ProjectionControl[][] projection_controls = new ProjectionControl[4][3];
    ScalarMap[][] color_maps = new ScalarMap[4][3];
    ScalarMap color_mapH1 = null;
    ScalarMap color_mapH2 = null;
    RealType band7 = null;
    RealTupleType cursor_type = null;
    FormulaManager f_manager = null;
    JTextField[][] jtfield = new JTextField[4][3];
    boolean in_proj = false;

    public static void main(String[] args) throws VisADException, RemoteException, IOException {
        if (args == null || args.length < 1) {
            System.out.println("run 'java visad.rabin.Rain file.v5d'\n or");
            System.out.println("    'java visad.rabin.Rain file.nc'\n or");
            System.out.println("    'java visad.rabin.Rain server.ip.name'");
            System.exit(1);
        }
        Rain rain = new Rain(args);
        rain.makeRain();
    }

    private Rain(String[] args) throws VisADException, RemoteException {
        if (args[0].endsWith(".v5d") || args[0].endsWith(".nc")) {
            this.server_server = new RemoteServerImpl();
            try {
                Naming.rebind("///Rain", this.server_server);
            }
            catch (MalformedURLException e) {
                System.out.println("Cannot set up server - running as stand-alone");
                this.server_server = null;
            }
            catch (AccessException e) {
                System.out.println("Cannot set up server - running as stand-alone");
                this.server_server = null;
            }
            catch (RemoteException e) {
                System.out.println("Cannot set up server - running as stand-alone");
                this.server_server = null;
            }
            Form form = null;
            if (args[0].endsWith(".v5d")) {
                try {
                    form = new Vis5DForm();
                }
                catch (UnsatisfiedLinkError e) {
                    System.out.println("Cannot find vis5d library: " + e.getMessage());
                    System.exit(1);
                }
            } else {
                form = new Plain();
            }
            FieldImpl vis5d = null;
            try {
                vis5d = (FieldImpl)form.open(args[0]);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                System.exit(0);
            }
            if (vis5d == null) {
                System.out.println("bad Vis5D file read");
                System.exit(0);
            }
            this.ref300 = new DataReferenceImpl("num300");
            this.ref1_4 = new DataReferenceImpl("num1_4");
            this.refMAX = new DataReferenceImpl("colorMAX");
            this.ref_cursor = new DataReferenceImpl("cursor");
            this.ref_vis5d = new DataReferenceImpl("vis5d");
            this.ref_projection = new DataReferenceImpl("projection");
            this.ref_colorH1 = new DataReferenceImpl("colorH1");
            this.ref_colorH2 = new DataReferenceImpl("colorH2");
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 3; ++j) {
                    this.cell_text[i][j] = new DataReferenceImpl("text_" + i + "_" + j);
                }
            }
            this.ref_vis5d.setData(vis5d);
            if (this.server_server != null) {
                RemoteDataReferenceImpl[] refs = new RemoteDataReferenceImpl[20];
                refs[0] = new RemoteDataReferenceImpl((DataReferenceImpl)this.ref300);
                refs[1] = new RemoteDataReferenceImpl((DataReferenceImpl)this.ref1_4);
                refs[2] = new RemoteDataReferenceImpl((DataReferenceImpl)this.refMAX);
                refs[3] = new RemoteDataReferenceImpl((DataReferenceImpl)this.ref_cursor);
                refs[4] = new RemoteDataReferenceImpl((DataReferenceImpl)this.ref_vis5d);
                refs[5] = new RemoteDataReferenceImpl((DataReferenceImpl)this.ref_projection);
                refs[6] = new RemoteDataReferenceImpl((DataReferenceImpl)this.ref_colorH1);
                refs[7] = new RemoteDataReferenceImpl((DataReferenceImpl)this.ref_colorH2);
                for (int i = 0; i < 4; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        refs[8 + 3 * i + j] = new RemoteDataReferenceImpl((DataReferenceImpl)this.cell_text[i][j]);
                    }
                }
                this.server_server.setDataReferences(refs);
            }
        } else {
            String domain = "//" + args[0] + "/Rain";
            try {
                this.client_server = (RemoteServer)Naming.lookup(domain);
            }
            catch (MalformedURLException e) {
                System.out.println("Cannot connect to server");
                System.exit(0);
            }
            catch (NotBoundException e) {
                System.out.println("Cannot connect to server");
                System.exit(0);
            }
            catch (AccessException e) {
                System.out.println("Cannot connect to server");
                System.exit(0);
            }
            catch (RemoteException e) {
                System.out.println("Cannot connect to server");
                System.exit(0);
            }
            RemoteDataReference[] refs = this.client_server.getDataReferences();
            if (refs == null) {
                System.out.println("Cannot connect to server");
                System.exit(0);
            }
            this.ref300 = refs[0];
            this.ref1_4 = refs[1];
            this.refMAX = refs[2];
            this.ref_cursor = refs[3];
            this.ref_vis5d = new DataReferenceImpl("vis5d");
            this.ref_vis5d.setData(refs[4].getData().local());
            this.ref_projection = refs[5];
            this.ref_colorH1 = refs[6];
            this.ref_colorH2 = refs[7];
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 3; ++j) {
                    this.cell_text[i][j] = refs[8 + 3 * i + j];
                }
            }
        }
    }

    private void makeRain() throws VisADException, RemoteException, IOException {
        FieldImpl vis5d = (FieldImpl)this.ref_vis5d.getData();
        FunctionType vis5d_type = (FunctionType)vis5d.getType();
        RealType time = (RealType)vis5d_type.getDomain().getComponent(0);
        FunctionType grid_type = (FunctionType)vis5d_type.getRange();
        RealTupleType domain = grid_type.getDomain();
        RealType x_domain = (RealType)domain.getComponent(0);
        RealType y_domain = (RealType)domain.getComponent(1);
        RealTupleType range = (RealTupleType)grid_type.getRange();
        RealType rangeH1 = (RealType)range.getComponent(0);
        RealType rangeH2 = (RealType)range.getComponent(8);
        int dim = range.getDimension();
        RealType[] range_types = new RealType[dim];
        for (int i = 0; i < dim; ++i) {
            range_types[i] = (RealType)range.getComponent(i);
        }
        final RealType shape = RealType.getRealType("shape");
        RealTupleType cursor_type = new RealTupleType(x_domain, y_domain, shape);
        SampledSet grid_set = (SampledSet)((FlatField)vis5d.getSample(0)).getDomainSet();
        float[] lows = grid_set.getLow();
        float[] his = grid_set.getHi();
        double cursorx = 0.5 * (double)(lows[0] + his[0]);
        double cursory = 0.5 * (double)(lows[1] + his[1]);
        RealTuple cursor = new RealTuple(cursor_type, new double[]{cursorx, cursory, 0.0});
        this.ref_cursor.setData(cursor);
        final Gridded1DSet shape_count_set = new Gridded1DSet((MathType)shape, (float[][])new float[][]{{0.0f}}, 1);
        VisADLineArray cross = new VisADLineArray();
        cross.coordinates = new float[]{0.1f, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.1f, 0.0f};
        cross.colors = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        cross.vertexCount = cross.coordinates.length / 3;
        final VisADGeometryArray[] shapes = new VisADGeometryArray[]{cross};
        this.f_manager = FormulaUtil.createStandardManager();
        this.f_manager.createVar("num300", this.ref300);
        this.f_manager.createVar("num1_4", this.ref1_4);
        JFrame frame = new JFrame("Vis5D");
        WindowAdapter l = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        };
        frame.addWindowListener(l);
        frame.setSize(1100, 900);
        frame.setCursor(Cursor.getPredefinedCursor(0));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(screenSize.width / 2 - 550, screenSize.height / 2 - 450);
        JPanel big_panel = new JPanel();
        big_panel.setLayout(new BoxLayout(big_panel, 0));
        big_panel.setAlignmentY(0.0f);
        big_panel.setAlignmentX(0.0f);
        frame.getContentPane().add(big_panel);
        JPanel left_panel = new JPanel();
        left_panel.setLayout(new BoxLayout(left_panel, 1));
        left_panel.setAlignmentY(0.0f);
        left_panel.setAlignmentX(0.0f);
        big_panel.add(left_panel);
        JPanel display_panel = new JPanel();
        display_panel.setLayout(new BoxLayout(display_panel, 0));
        display_panel.setAlignmentY(0.0f);
        display_panel.setAlignmentX(0.0f);
        big_panel.add(display_panel);
        for (int j = 0; j < 3; ++j) {
            this.column_panels[j] = new JPanel();
            this.column_panels[j].setLayout(new BoxLayout(this.column_panels[j], 1));
            this.column_panels[j].setAlignmentY(0.0f);
            this.column_panels[j].setAlignmentX(0.0f);
            display_panel.add(this.column_panels[j]);
        }
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.cell_panels[i][j] = new JPanel();
                this.cell_panels[i][j].setLayout(new BoxLayout(this.cell_panels[i][j], 1));
                this.cell_panels[i][j].setAlignmentY(0.0f);
                this.cell_panels[i][j].setAlignmentX(0.0f);
                this.column_panels[j].add(this.cell_panels[i][j]);
                this.cell_refs[i][j] = i == 0 && j == 0 ? this.ref_vis5d : new DataReferenceImpl("cell_" + i + "_" + j);
                this.displays[i][j] = this.newDisplay("display_" + i + "_" + j);
                if (this.client_server != null) {
                    this.remote_displays[i][j] = new RemoteDisplayImpl(this.displays[i][j]);
                }
                this.displays[i][j].addMap(new ScalarMap(y_domain, Display.XAxis));
                this.displays[i][j].addMap(new ScalarMap(x_domain, Display.YAxis));
                ScalarMap shape_map = new ScalarMap(shape, Display.Shape);
                this.displays[i][j].addMap(shape_map);
                ShapeControl shape_control = (ShapeControl)shape_map.getControl();
                shape_control.setShapeSet(shape_count_set);
                shape_control.setShapes(shapes);
                this.projection_controls[i][j] = this.displays[i][j].getProjectionControl();
                this.projection_controls[i][j].addControlListener(this);
                this.display_done[i][j] = false;
                this.f_manager.createVar(cell_names[i][j], this.cell_refs[i][j]);
                this.f_manager.setTextRef(cell_names[i][j], this.cell_text[i][j]);
                JPanel fpanel = new JPanel();
                fpanel.setLayout(new BoxLayout(fpanel, 0));
                this.jtfield[i][j] = new JTextField(cell_formulas[i][j]);
                Dimension psize = this.jtfield[i][j].getPreferredSize();
                Dimension msize = this.jtfield[i][j].getMaximumSize();
                msize.height = psize.height;
                this.jtfield[i][j].setMaximumSize(msize);
                this.jtfield[i][j].addActionListener(this);
                this.jtfield[i][j].setActionCommand("fc_" + cell_names[i][j]);
                fpanel.add(new JLabel(cell_names[i][j] + ": "));
                fpanel.add(this.jtfield[i][j]);
                this.cell_panels[i][j].add(fpanel);
                final int fi = i;
                final int fj = j;
                Rain rain = this;
                this.formula_update[i][j] = new CellImpl(){

                    @Override
                    public void doAction() {
                        ScalarMap[] maps = null;
                        Vector v = Rain.this.displays[fi][fj].getMapVector();
                        maps = new ScalarMap[v.size()];
                        for (int k = 0; k < maps.length; ++k) {
                            maps[k] = (ScalarMap)v.elementAt(k);
                        }
                        boolean change = false;
                        for (int k = 0; k < maps.length && !change; ++k) {
                            RealType ort = (RealType)maps[k].getScalar();
                            DisplayRealType drt = maps[k].getDisplayScalar();
                            if (!drt.equals(Display.RGB)) continue;
                            try {
                                FunctionType f;
                                RealType rt;
                                Data d = Rain.this.cell_refs[fi][fj].getData();
                                if (d == null || (rt = (RealType)(f = (FunctionType)d.getType()).getRange()).equals(ort)) continue;
                                change = true;
                                continue;
                            }
                            catch (ClassCastException d) {
                                continue;
                            }
                            catch (VisADException d) {
                                continue;
                            }
                            catch (RemoteException d) {
                                // empty catch block
                            }
                        }
                        if (change) {
                            try {
                                Rain.this.displays[fi][fj].removeReference(Rain.this.cell_refs[fi][fj]);
                                if (Rain.this.color_controls[fi][fj] != null || fi == 0 && fj == 2) {
                                    Rain.this.removeCursor(fi, fj);
                                }
                                Rain.this.displays[fi][fj].clearMaps();
                            }
                            catch (VisADException k) {
                            }
                            catch (RemoteException k) {
                                // empty catch block
                            }
                            for (int k = 0; k < maps.length; ++k) {
                                boolean done = false;
                                RealType ort = (RealType)maps[k].getScalar();
                                DisplayRealType drt = maps[k].getDisplayScalar();
                                if (drt.equals(Display.RGB)) {
                                    try {
                                        Data d = Rain.this.cell_refs[fi][fj].getData();
                                        FunctionType f = (FunctionType)d.getType();
                                        RealType rt = (RealType)f.getRange();
                                        if (!rt.equals(ort)) {
                                            double max;
                                            ScalarMap sm;
                                            maps[k] = sm = new ScalarMap(rt, Display.RGB);
                                            ColorControl cc = null;
                                            if (fi == 3 && fj == 2) {
                                                cc = Rain.this.color_controlH2;
                                                max = 10.0;
                                            } else {
                                                cc = Rain.this.color_controlH1;
                                                max = ((Real)Rain.this.refMAX.getData()).getValue();
                                            }
                                            if (cc != null) {
                                                float[][] table = cc.getTable();
                                                Rain.this.color_maps[fi][fj] = sm;
                                                Rain.this.color_maps[fi][fj].setRange(0.0, max);
                                                Rain.this.displays[fi][fj].addMap(sm);
                                                done = true;
                                                Rain.this.color_controls[fi][fj] = (ColorControl)Rain.this.color_maps[fi][fj].getControl();
                                                if (table != null) {
                                                    Rain.this.color_controls[fi][fj].setTable(table);
                                                }
                                            }
                                            boolean isBand7 = rt.equals(Rain.this.band7);
                                            GraphicsModeControl mode = Rain.this.displays[fi][fj].getGraphicsModeControl();
                                            mode.setTextureEnable(!isBand7);
                                            mode.setPointMode(isBand7);
                                            mode.setPointSize(5.0f);
                                        }
                                    }
                                    catch (ClassCastException d) {
                                    }
                                    catch (VisADException d) {
                                    }
                                    catch (RemoteException d) {}
                                } else if (drt.equals(Display.Shape)) {
                                    try {
                                        ScalarMap shape_mapx = new ScalarMap(shape, Display.Shape);
                                        Rain.this.displays[fi][fj].addMap(shape_mapx);
                                        ShapeControl shape_controlx = (ShapeControl)shape_mapx.getControl();
                                        shape_controlx.setShapeSet(shape_count_set);
                                        shape_controlx.setShapes(shapes);
                                        done = true;
                                    }
                                    catch (VisADException visADException) {
                                    }
                                    catch (RemoteException remoteException) {
                                        // empty catch block
                                    }
                                }
                                if (done) continue;
                                try {
                                    Rain.this.displays[fi][fj].addMap(maps[k]);
                                    continue;
                                }
                                catch (VisADException visADException) {
                                    continue;
                                }
                                catch (RemoteException remoteException) {
                                    // empty catch block
                                }
                            }
                            try {
                                Rain.this.displays[fi][fj].addReference(Rain.this.cell_refs[fi][fj]);
                                if (Rain.this.color_controls[fi][fj] != null) {
                                    Rain.this.addCursor(fi, fj);
                                }
                            }
                            catch (VisADException visADException) {
                            }
                            catch (RemoteException remoteException) {
                                // empty catch block
                            }
                        }
                    }
                };
                JPanel d_panel = (JPanel)this.displays[i][j].getComponent();
                d_panel.setAlignmentX(0.5f);
                CompoundBorder etchedBorder5 = new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5));
                d_panel.setBorder(etchedBorder5);
                this.cell_panels[i][j].add(d_panel);
                this.cell_fields[i][j] = new JLabel("---");
                this.cell_fields[i][j].setAlignmentX(0.5f);
                this.cell_fields[i][j].setMinimumSize(this.jtfield[i][j].getMinimumSize());
                this.cell_fields[i][j].setPreferredSize(this.jtfield[i][j].getPreferredSize());
                this.cell_fields[i][j].setMaximumSize(this.jtfield[i][j].getMaximumSize());
                this.cell_panels[i][j].add(this.cell_fields[i][j]);
            }
        }
        this.slider300 = new VisADSlider("num300", 0, 600, 300, 1.0, this.ref300, RealType.Generic);
        VisADSlider slider1_4 = new VisADSlider("num1_4", 0, 280, 140, 0.01, this.ref1_4, RealType.Generic);
        VisADSlider sliderMAX = new VisADSlider("colorMAX", 0, 1000, 300, 1.0, this.refMAX, RealType.Generic);
        left_panel.add(this.slider300);
        left_panel.add(new JLabel("  "));
        left_panel.add(slider1_4);
        left_panel.add(new JLabel("  "));
        left_panel.add(sliderMAX);
        left_panel.add(new JLabel("  "));
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (i == 0 && j == 0) continue;
                this.f_manager.assignFormula(cell_names[i][j], cell_formulas[i][j]);
            }
        }
        this.color_mapH1 = new ScalarMap(rangeH1, Display.RGB);
        DisplayImpl displayH1 = this.newDisplay("display_hidden_1");
        displayH1.addMap(this.color_mapH1);
        this.color_widgetH1 = new LabeledColorWidget(this.color_mapH1);
        Dimension d = new Dimension(500, 170);
        this.color_widgetH1.setMaximumSize(d);
        this.color_mapH1.setRange(0.0, 300.0);
        left_panel.add(this.color_widgetH1);
        left_panel.add(new JLabel("  "));
        this.color_controlH1 = (ColorControl)this.color_mapH1.getControl();
        this.color_controlH1.addControlListener(this);
        if (this.server_server != null) {
            float[][] table = this.color_controlH1.getTable();
            Integer1DSet set = new Integer1DSet(table[0].length);
            FlatField color_fieldH1 = new FlatField(FunctionType.REAL_1TO3_FUNCTION, set);
            color_fieldH1.setSamples(table);
            this.ref_colorH1.setData(color_fieldH1);
        }
        if (this.server_server != null || this.client_server != null) {
            CellImpl color_cellH1 = new CellImpl(){

                @Override
                public void doAction() throws VisADException, RemoteException {
                    FlatField field = (FlatField)Rain.this.ref_colorH1.getData().local();
                    float[][] table = field.getFloats();
                    float[][] old_table = Rain.this.color_controlH1.getTable();
                    boolean identical = true;
                    block0: for (int i = 0; i < 3; ++i) {
                        if (!identical) continue;
                        for (int j = 0; j < table[i].length; ++j) {
                            if (!((double)Math.abs(table[i][j] - old_table[i][j]) > 1.0E-5)) continue;
                            identical = false;
                            continue block0;
                        }
                    }
                    if (!identical) {
                        Rain.this.color_controlH1.setTable(table);
                    }
                }
            };
            if (this.client_server != null) {
                RemoteCellImpl remote_cell = new RemoteCellImpl(color_cellH1);
                remote_cell.addReference(this.ref_colorH1);
            } else {
                color_cellH1.addReference(this.ref_colorH1);
            }
        }
        this.color_mapH2 = new ScalarMap(rangeH2, Display.RGB);
        DisplayImpl displayH2 = this.newDisplay("display_hidden_2");
        displayH2.addMap(this.color_mapH2);
        this.color_widgetH2 = new LabeledColorWidget(this.color_mapH2);
        Dimension dH2 = new Dimension(500, 170);
        this.color_widgetH2.setMaximumSize(dH2);
        this.color_mapH2.setRange(0.0, 10.0);
        this.color_controlH2 = (ColorControl)this.color_mapH2.getControl();
        this.color_controlH2.addControlListener(this);
        if (this.server_server != null) {
            float[][] table = this.color_controlH2.getTable();
            Integer1DSet set = new Integer1DSet(table[0].length);
            FlatField color_fieldH2 = new FlatField(FunctionType.REAL_1TO3_FUNCTION, set);
            color_fieldH2.setSamples(table);
            this.ref_colorH2.setData(color_fieldH2);
        }
        if (this.server_server != null || this.client_server != null) {
            CellImpl color_cellH2 = new CellImpl(){

                @Override
                public void doAction() throws VisADException, RemoteException {
                    FlatField field = (FlatField)Rain.this.ref_colorH2.getData().local();
                    float[][] table = field.getFloats();
                    float[][] old_table = Rain.this.color_controlH2.getTable();
                    boolean identical = true;
                    block0: for (int i = 0; i < 3; ++i) {
                        if (!identical) continue;
                        for (int j = 0; j < table[i].length; ++j) {
                            if (!((double)Math.abs(table[i][j] - old_table[i][j]) > 1.0E-5)) continue;
                            identical = false;
                            continue block0;
                        }
                    }
                    if (!identical) {
                        Rain.this.color_controlH2.setTable(table);
                    }
                }
            };
            if (this.client_server != null) {
                RemoteCellImpl remote_cell = new RemoteCellImpl(color_cellH2);
                remote_cell.addReference(this.ref_colorH2);
            } else {
                color_cellH2.addReference(this.ref_colorH2);
            }
        }
        left_panel.add(this.color_widgetH2);
        left_panel.add(new JLabel("  "));
        this.displays[0][0].addMap(new ScalarMap(range_types[0], Display.Red));
        this.displays[0][0].addMap(new ScalarMap(range_types[1], Display.Green));
        this.displays[0][0].addMap(new ScalarMap(range_types[2], Display.Blue));
        this.displays[0][0].addMap(new ScalarMap(time, Display.Animation));
        this.displays[0][0].addReference(this.cell_refs[0][0]);
        this.display_done[0][0] = true;
        if (this.server_server != null) {
            double[] matrix = this.projection_controls[0][0].getMatrix();
            if (matrix.length != 6) {
                matrix = ProjectionControl.matrix3DTo2D(matrix);
            }
            Integer1DSet set = new Integer1DSet(6);
            FlatField projection_field = new FlatField(FunctionType.REAL_1TO1_FUNCTION, set);
            projection_field.setSamples(new double[][]{matrix});
            this.ref_projection.setData(projection_field);
        }
        if (this.server_server != null || this.client_server != null) {
            CellImpl projection_cell = new CellImpl(){

                @Override
                public void doAction() throws VisADException, RemoteException {
                    FlatField field = (FlatField)Rain.this.ref_projection.getData().local();
                    double[] matrix = field.getValues()[0];
                    double[] old = Rain.this.projection_controls[0][0].getMatrix();
                    double[] old_matrix = null;
                    old_matrix = old.length == 6 ? old : ProjectionControl.matrix3DTo2D(old);
                    boolean identical = true;
                    for (int j = 0; j < matrix.length; ++j) {
                        if (!(Math.abs(matrix[j] - old_matrix[j]) > 1.0E-5)) continue;
                        identical = false;
                        break;
                    }
                    if (!identical) {
                        if (old.length == 6) {
                            Rain.this.projection_controls[0][0].setMatrix(matrix);
                        } else {
                            double[] mat = ProjectionControl.matrix2DTo3D(matrix);
                            Rain.this.projection_controls[0][0].setMatrix(mat);
                        }
                    }
                }
            };
            if (this.client_server != null) {
                RemoteCellImpl remote_cell = new RemoteCellImpl(projection_cell);
                remote_cell.addReference(this.ref_projection);
            } else {
                projection_cell.addReference(this.ref_projection);
            }
        }
        this.displays[0][1].addMap(new ScalarMap(range_types[0], Display.Red));
        this.displays[0][1].addMap(new ScalarMap(range_types[1], Display.Green));
        this.displays[0][1].addMap(new ScalarMap(range_types[2], Display.Blue));
        this.displays[0][1].addReference(this.cell_refs[0][1]);
        this.display_done[0][1] = true;
        this.finishDisplay(this.client_server, (RealType)range.getComponent(0), 0, 2);
        this.finishDisplay(this.client_server, (RealType)range.getComponent(1), 1, 0);
        this.finishDisplay(this.client_server, (RealType)range.getComponent(2), 1, 1);
        this.finishDisplay(this.client_server, (RealType)range.getComponent(3), 1, 2);
        this.finishDisplay(this.client_server, (RealType)range.getComponent(4), 2, 0);
        this.finishDisplay(this.client_server, (RealType)range.getComponent(5), 2, 1);
        this.finishDisplay(this.client_server, rangeH1, 2, 2);
        this.finishDisplay(this.client_server, (RealType)range.getComponent(6), 3, 0);
        this.band7 = (RealType)range.getComponent(7);
        this.finishDisplay(this.client_server, this.band7, 3, 1);
        GraphicsModeControl mode = this.displays[3][1].getGraphicsModeControl();
        mode.setTextureEnable(false);
        mode.setPointMode(true);
        mode.setPointSize(5.0f);
        this.finishDisplay(this.client_server, (RealType)range.getComponent(8), 3, 2);
        CellImpl cell_formulas = new CellImpl(){

            @Override
            public void doAction() {
                for (int i = 0; i < 4; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        try {
                            Text t = (Text)Rain.this.cell_text[i][j].getThing();
                            if (t == null) continue;
                            String s = t.getValue();
                            if (s == null) {
                                s = "";
                            }
                            if (s.equals(Rain.this.jtfield[i][j].getText())) continue;
                            final JTextField jtf = Rain.this.jtfield[i][j];
                            final String str = s;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    jtf.setText(str);
                                }
                            });
                            continue;
                        }
                        catch (VisADException visADException) {
                            continue;
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                }
            }
        };
        if (this.client_server != null) {
            RemoteCellImpl remote_cell = new RemoteCellImpl(cell_formulas);
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 3; ++j) {
                    remote_cell.addReference(this.cell_text[i][j]);
                }
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 3; ++j) {
                    cell_formulas.addReference(this.cell_text[i][j]);
                }
            }
        }
        CellImpl cellMAX = new CellImpl(){

            @Override
            public void doAction() throws VisADException, RemoteException {
                double max = ((Real)Rain.this.refMAX.getData()).getValue();
                Rain.this.color_mapH1.setRange(0.0, max);
                for (int i = 0; i < 4; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        if (Rain.this.color_maps[i][j] == null || i == 3 && j == 2) continue;
                        Rain.this.color_maps[i][j].setRange(0.0, max);
                    }
                }
            }
        };
        if (this.client_server != null) {
            RemoteCellImpl remote_cell = new RemoteCellImpl(cellMAX);
            remote_cell.addReference(this.refMAX);
        } else {
            cellMAX.addReference(this.refMAX);
        }
        CellImpl cell_cursor = new CellImpl(){

            @Override
            public void doAction() throws VisADException, RemoteException {
                RealTuple c = (RealTuple)Rain.this.ref_cursor.getData();
                RealTuple dom = new RealTuple(new Real[]{(Real)c.getComponent(0), (Real)c.getComponent(1)});
                for (int i = 0; i < 4; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        try {
                            FlatField field = (FlatField)Rain.this.cell_refs[i][j].getData();
                            double val = ((Real)field.evaluate(dom)).getValue();
                            Rain.this.cell_fields[i][j].setText("" + val);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        };
        if (this.client_server != null) {
            RemoteCellImpl remote_cell = new RemoteCellImpl(cell_cursor);
            remote_cell.addReference(this.ref_cursor);
        } else {
            cell_cursor.addReference(this.ref_cursor);
        }
        new Delay(1000);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.formula_update[i][j].addReference(this.cell_refs[i][j]);
            }
        }
        frame.setVisible(true);
    }

    public DisplayImpl newDisplay(String name) throws VisADException, RemoteException {
        DisplayImpl display = null;
        if (!this.twod) {
            try {
                display = new DisplayImplJ3D(name, (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
            }
            catch (UnsatisfiedLinkError e) {
                this.twod = true;
            }
        }
        if (this.twod) {
            display = new DisplayImplJ2D(name);
        }
        return display;
    }

    public void addCursor(int i, int j) throws VisADException, RemoteException {
        DataRenderer dr = null;
        dr = this.twod ? new DirectManipulationRendererJ2D() : new DirectManipulationRendererJ3D();
        if (this.client_server != null) {
            this.remote_displays[i][j].addReferences(dr, this.ref_cursor);
        } else {
            this.displays[i][j].addReferences(dr, this.ref_cursor);
        }
    }

    public void removeCursor(int i, int j) throws VisADException, RemoteException {
        if (this.client_server != null) {
            this.remote_displays[i][j].removeReference(this.ref_cursor);
        } else {
            this.displays[i][j].removeReference(this.ref_cursor);
        }
    }

    public void finishDisplay(RemoteServer cs, RealType rt, int i, int j) throws VisADException, RemoteException {
        float[][] table;
        this.color_maps[i][j] = new ScalarMap(rt, Display.RGB);
        this.displays[i][j].addMap(this.color_maps[i][j]);
        this.color_maps[i][j].setRange(0.0, 300.0);
        this.color_controls[i][j] = (ColorControl)this.color_maps[i][j].getControl();
        ColorControl cc = null;
        cc = i == 3 && j == 4 ? this.color_controlH2 : this.color_controlH1;
        if (cc != null && (table = cc.getTable()) != null) {
            this.color_controls[i][j].setTable(table);
        }
        this.displays[i][j].addReference(this.cell_refs[i][j]);
        this.addCursor(i, j);
        this.display_done[i][j] = true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.startsWith("fc_")) {
            this.slider300.requestFocus();
            JTextField f_field = (JTextField)e.getSource();
            String formula = f_field.getText();
            String cell_name = cmd.substring(3, cmd.length());
            try {
                this.f_manager.assignFormula(cell_name, formula);
            }
            catch (FormulaException formulaException) {
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    @Override
    public void controlChanged(ControlEvent e) throws VisADException, RemoteException {
        Control control = e.getControl();
        if (control.equals(this.color_controlH1)) {
            Field field;
            float[][] table = this.color_controlH1.getTable();
            if (table != null) {
                for (int i = 0; i < 4; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        if (this.color_controls[i][j] == null || i == 3 && j == 2) continue;
                        this.color_controls[i][j].setTable(table);
                    }
                }
            }
            if ((field = (Field)this.ref_colorH1.getData()) != null) {
                field.setSamples(table);
            }
        } else if (control.equals(this.color_controlH2)) {
            float[][] table = this.color_controlH2.getTable();
            if (table != null) {
                this.color_controls[3][2].setTable(table);
            }
        } else if (!this.in_proj && control != null && control instanceof ProjectionControl) {
            this.in_proj = true;
            double[] matrix = ((ProjectionControl)control).getMatrix();
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if (control == this.projection_controls[i][j] || this.projection_controls[i][j] == null) continue;
                    this.projection_controls[i][j].setMatrix(matrix);
                }
            }
            Field field = (Field)this.ref_projection.getData();
            if (matrix.length == 6) {
                if (field != null) {
                    field.setSamples(new double[][]{matrix});
                }
            } else {
                double[] mat = ProjectionControl.matrix3DTo2D(matrix);
                if (field != null) {
                    field.setSamples(new double[][]{mat});
                }
            }
            this.in_proj = false;
        }
    }
}

