/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Enumeration;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.scijava.java3d.Bounds;
import org.scijava.java3d.BranchGroup;
import org.scijava.java3d.Canvas3D;
import org.scijava.java3d.Geometry;
import org.scijava.java3d.GeometryArray;
import org.scijava.java3d.Group;
import org.scijava.java3d.Node;
import org.scijava.java3d.OrderedGroup;
import org.scijava.java3d.SceneGraphObject;
import org.scijava.java3d.Shape3D;
import org.scijava.java3d.Switch;
import org.scijava.java3d.Text3D;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.TransformGroup;
import org.scijava.java3d.View;
import visad.java3d.DisplayRendererJ3D;
import visad.util.Util;

public class SceneGraphInspector
extends JPanel
implements TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    private JTree tree;
    private JPanel cards = new JPanel();

    public static void show(DisplayRendererJ3D renderer) {
        JFrame frame = new JFrame("VisAD SceneGraph Inspector");
        frame.setDefaultCloseOperation(2);
        frame.add(new SceneGraphInspector(renderer));
        frame.setSize(800, 480);
        frame.setVisible(true);
    }

    private static String makeName(Object obj) {
        String name = obj.getClass().getSimpleName();
        if (obj instanceof Node) {
            Node node = (Node)obj;
            String nodeName = Util.getName((SceneGraphObject)node);
            if (nodeName != null && nodeName.length() > 0) {
                name = nodeName;
            }
        } else if (obj instanceof String) {
            return (String)obj;
        }
        return name + "@" + obj.hashCode();
    }

    public SceneGraphInspector(DisplayRendererJ3D renderer) {
        this.cards.setLayout(new CardLayout());
        MyNode<String> top = new MyNode<String>("ROOT");
        View view = renderer.getView();
        MyNode<View> viewNode = new MyNode<View>(view);
        this.createViewNodes(viewNode);
        top.add(viewNode);
        MyNode<BranchGroup> scene = new MyNode<BranchGroup>(renderer.getRoot());
        this.createSceneNodes(scene);
        top.add(scene);
        this.tree = new JTree(top);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        Dimension minimumSize = new Dimension(300, 200);
        JScrollPane treeView = new JScrollPane(this.tree);
        treeView.setMinimumSize(minimumSize);
        JSplitPane split = new JSplitPane(1, treeView, this.cards);
        this.setLayout(new BorderLayout());
        this.add((Component)split, "Center");
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
    }

    private void createViewNodes(MyNode<View> viewNode) {
        this.cards.add((Component)this.makeViewComponent(viewNode.getNode()), viewNode.getName());
        Enumeration canvases = viewNode.getNode().getAllCanvas3Ds();
        while (canvases.hasMoreElements()) {
            Canvas3D canvas = (Canvas3D)canvases.nextElement();
            MyNode<Canvas3D> canvasNode = new MyNode<Canvas3D>(canvas);
            viewNode.add(canvasNode);
            this.cards.add((Component)this.makeCanvasComponent(canvas), canvasNode.getName());
        }
    }

    private void createSceneNodes(MyNode<Node> scene) {
        Node node = scene.getNode();
        this.cards.add((Component)this.makeNodeComponent(node), scene.getName());
        if (node instanceof Group) {
            Group group = (Group)node;
            Enumeration children = group.getAllChildren();
            while (children.hasMoreElements()) {
                MyNode<Node> tnode = new MyNode<Node>((Node)children.nextElement());
                scene.add(tnode);
                this.createSceneNodes(tnode);
            }
        }
    }

    private JPanel makeViewComponent(final View view) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(new JLabel("Class: " + view.getClass().getName()));
        panel.add(new JLabel("AntiAliasing: " + view.getSceneAntialiasingEnable()));
        int x = view.getViewPolicy();
        panel.add(new JLabel("ViewPolicy: " + (x == 1 ? "HMD_VIEW" : "SCREEN_VIEW")));
        String visPolicy = "";
        switch (view.getVisibilityPolicy()) {
            case 2: {
                visPolicy = "VISIBILITY_DRAW_ALL";
                break;
            }
            case 1: {
                visPolicy = "VISIBILITY_DRAW_INVISIBLE";
                break;
            }
            case 0: {
                visPolicy = "VISIBILITY_DRAW_VISIBLE";
            }
        }
        panel.add(new JLabel("VisibilityPolicy: " + visPolicy));
        panel.add(new JLabel("FrameNumber: " + view.getFrameNumber()));
        panel.add(new JLabel("ViewRunning: " + view.isViewRunning()));
        panel.add(new JLabel("BehaviorSchedulerRunning: " + view.isBehaviorSchedulerRunning()));
        final JButton startView = new JButton("Start View");
        startView.setEnabled(!view.isViewRunning());
        final JButton stopView = new JButton("Stop View");
        startView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                view.startView();
                startView.setEnabled(!view.isViewRunning());
                stopView.setEnabled(view.isViewRunning());
            }
        });
        stopView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                view.stopView();
                startView.setEnabled(!view.isViewRunning());
                stopView.setEnabled(view.isViewRunning());
            }
        });
        JPanel subPanel = new JPanel();
        subPanel.add(startView);
        subPanel.add(stopView);
        panel.add(subPanel);
        final JButton startBehav = new JButton("Start BehaviorScheduler");
        startView.setEnabled(!view.isViewRunning());
        final JButton stopBehav = new JButton("Stop BehaviorScheduler");
        startView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                view.startBehaviorScheduler();
                stopBehav.setEnabled(!view.isViewRunning());
                startBehav.setEnabled(view.isViewRunning());
            }
        });
        stopView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                view.stopBehaviorScheduler();
                stopBehav.setEnabled(!view.isViewRunning());
                startBehav.setEnabled(view.isViewRunning());
            }
        });
        subPanel = new JPanel();
        subPanel.add(startView);
        subPanel.add(stopView);
        panel.add(subPanel);
        return panel;
    }

    private JPanel makeCanvasComponent(final Canvas3D canvas) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(new JLabel("Class: " + canvas.getClass().getName()));
        panel.add(new JLabel("Name: " + canvas.getName()));
        panel.add(new JLabel("DoubleBufferEnabled: " + canvas.getDoubleBufferEnable()));
        panel.add(new JLabel("Height: " + canvas.getHeight()));
        panel.add(new JLabel("Width: " + canvas.getWidth()));
        panel.add(new JLabel("IgnoreRepaint: " + canvas.getIgnoreRepaint()));
        panel.add(new JLabel("MousePosition: " + canvas.getMousePosition()));
        final JButton startRend = new JButton("Start Renderer");
        startRend.setEnabled(!canvas.isRendererRunning());
        final JButton stopRend = new JButton("Stop Renderer");
        startRend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                canvas.startRenderer();
                startRend.setEnabled(!canvas.isRendererRunning());
                stopRend.setEnabled(canvas.isRendererRunning());
            }
        });
        stopRend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                canvas.stopRenderer();
                startRend.setEnabled(!canvas.isRendererRunning());
                stopRend.setEnabled(canvas.isRendererRunning());
            }
        });
        JPanel subPanel = new JPanel();
        subPanel.add(startRend);
        subPanel.add(stopRend);
        panel.add(subPanel);
        return panel;
    }

    private JPanel makeNodeComponent(final Node node) {
        Shape3D shape;
        Geometry geo;
        final Group parent = (Group)node.getParent();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(new JLabel("Name: " + SceneGraphInspector.makeName(node)));
        panel.add(new JLabel("Class: " + node.getClass().getName()));
        panel.add(new JLabel("Live: " + node.isLive()));
        panel.add(new JLabel("Compiled: " + node.isCompiled()));
        panel.add(new JLabel("UserData: " + node.getUserData()));
        panel.add(new JLabel("Pickable: " + node.getPickable()));
        panel.add(new JLabel("BoundsAutoCompute: " + node.getBoundsAutoCompute()));
        Bounds bounds = node.getBounds();
        if (bounds != null) {
            panel.add(new JLabel("Bounds.isEmpty: " + bounds.isEmpty()));
        }
        if (node instanceof Group) {
            Group group = (Group)node;
            panel.add(new JLabel("NumChildren: " + group.numChildren()));
            if (node instanceof BranchGroup && parent != null && group.getCapability(17)) {
                final JToggleButton button = new JToggleButton("Detach");
                button.setSelected(true);
                button.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (e.getStateChange() == 1) {
                            parent.addChild(node);
                            button.setText("Detach");
                        } else if (e.getStateChange() == 2) {
                            ((BranchGroup)node).detach();
                            button.setText("Attach");
                        }
                    }
                });
                panel.add(button);
            } else if (node instanceof OrderedGroup) {
                OrderedGroup ogroup = (OrderedGroup)node;
                panel.add(new JLabel("Order: " + Arrays.toString(ogroup.getChildIndexOrder())));
            } else if (node instanceof TransformGroup) {
                TransformGroup tgroup = (TransformGroup)node;
                Transform3D trans = new Transform3D();
                tgroup.getTransform(trans);
                panel.add(new JLabel("TransformMatrix: " + trans.toString()));
            }
            if (node instanceof Switch) {
                final Switch swich = (Switch)node;
                String[] indexes = new String[swich.numChildren() + 1];
                indexes[0] = "None";
                for (int i = 1; i < indexes.length; ++i) {
                    indexes[i] = "" + (i - 1);
                }
                JComboBox<String> comboBox = new JComboBox<String>(indexes);
                int selected = swich.getWhichChild();
                if (selected == -1) {
                    selected = 0;
                }
                comboBox.setSelectedIndex(swich.getWhichChild() + 1);
                comboBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JComboBox cBox = (JComboBox)e.getSource();
                        int selected = cBox.getSelectedIndex();
                        selected = selected == 0 ? -1 : --selected;
                        swich.setWhichChild(selected);
                    }
                });
                panel.add(comboBox);
            }
        } else if (node instanceof Shape3D && (geo = (shape = (Shape3D)node).getGeometry()) != null) {
            panel.add(new JLabel("Geometry: " + geo.getClass().getSimpleName()));
            if (geo instanceof GeometryArray) {
                GeometryArray arr = (GeometryArray)geo;
                panel.add(new JLabel("VertexCount: " + arr.getVertexCount()));
            } else if (geo instanceof Text3D) {
                Text3D txt = (Text3D)geo;
                panel.add(new JLabel("String: \"" + txt.getString() + "\""));
            }
        }
        return panel;
    }

    @Override
    public void valueChanged(TreeSelectionEvent evt) {
        MyNode tnode = (MyNode)evt.getPath().getLastPathComponent();
        Object node = tnode.getNode();
        CardLayout cl = (CardLayout)this.cards.getLayout();
        cl.show(this.cards, tnode.getName());
    }

    class MyNode<T>
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;
        private T node;

        public MyNode(T node) {
            this.node = node;
        }

        public T getNode() {
            return this.node;
        }

        public String getName() {
            return SceneGraphInspector.makeName(this.node);
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }
}

