/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.spring;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.CallableStatementCallback;
import org.springframework.jdbc.core.CallableStatementCreator;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ParameterDisposer;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.lang.NonNull;
import org.sqlproc.engine.SqlControl;
import org.sqlproc.engine.SqlFeature;
import org.sqlproc.engine.SqlProcessorException;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlRuntimeContext;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.jdbc.type.JdbcSqlType;
import org.sqlproc.engine.plugin.SqlFromToPlugin;
import org.sqlproc.engine.type.IdentitySetter;
import org.sqlproc.engine.type.OutValueSetter;

public class SpringQuery
implements SqlQuery {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    JdbcTemplate jdbcTemplate;
    String queryString;
    List<String> scalars = new ArrayList<String>();
    Map<String, Object> scalarTypes = new HashMap<String, Object>();
    List<String> parameters = new ArrayList<String>();
    Map<String, Object> parameterValues = new HashMap<String, Object>();
    List<Map<String, Object>> batchParameterValues = new ArrayList<Map<String, Object>>();
    Map<String, Object> parameterTypes = new HashMap<String, Object>();
    Map<String, Object> parameterOutValueTypes = new HashMap<String, Object>();
    Map<String, OutValueSetter> parameterOutValueSetters = new HashMap<String, OutValueSetter>();
    Map<Integer, Integer> parameterOutValuesToPickup = new LinkedHashMap<Integer, Integer>();
    List<String> identities = new ArrayList<String>();
    Map<String, IdentitySetter> identitySetters = new HashMap<String, IdentitySetter>();
    Map<String, Object> identityTypes = new HashMap<String, Object>();
    SqlControl sqlControl;
    Integer timeout;
    Integer firstResult;
    Integer maxResults;
    Integer fetchSize;
    boolean ordered;
    boolean logError;
    private static final Map<String, Object> NO_MORE_DATA = new LinkedHashMap<String, Object>();
    static final Pattern CALL = Pattern.compile("\\s*\\{?\\s*(\\?)?\\s*=?\\s*call\\s*(.*?)\\s*}?\\s*");

    public SpringQuery(JdbcTemplate jdbcTemplate, String queryString) {
        this.jdbcTemplate = jdbcTemplate;
        this.queryString = queryString;
    }

    public Object getQuery() {
        return this.jdbcTemplate;
    }

    public SqlQuery setSqlControl(SqlControl sqlControl) {
        this.sqlControl = sqlControl;
        if (sqlControl != null) {
            this.timeout = sqlControl.getMaxTimeout();
            this.firstResult = sqlControl.getFirstResult();
            this.maxResults = sqlControl.getMaxResults();
            this.fetchSize = sqlControl.getFetchSize();
        } else {
            this.timeout = null;
            this.firstResult = null;
            this.maxResults = null;
            this.fetchSize = null;
        }
        return this;
    }

    public SqlQuery setOrdered(boolean ordered) {
        this.ordered = ordered;
        return this;
    }

    public Map<String, Object> getParameterValues() {
        return this.parameterValues;
    }

    public void addBatchParameterValues(Map<String, Object> parameterValues) {
        this.batchParameterValues.add(parameterValues);
    }

    public List<Map<String, Object>> list(SqlRuntimeContext runtimeCtx) throws SqlProcessorException {
        String sql;
        String _query;
        StringBuilder queryResult = this.maxResults != null ? new StringBuilder(this.queryString.length() + 100) : null;
        final SqlFromToPlugin.LimitType limitType = this.maxResults != null ? runtimeCtx.getPluginFactory().getSqlFromToPlugin().limitQuery(runtimeCtx, this.queryString, queryResult, this.firstResult, this.maxResults, this.ordered) : null;
        String string = _query = limitType != null && queryResult != null ? queryResult.toString() : this.queryString;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("list, query=" + _query);
        }
        if (this.sqlControl != null && this.sqlControl.getLowLevelSqlCallback() != null && (sql = this.sqlControl.getLowLevelSqlCallback().handleInputValues(_query, this.parameterValues)) != null) {
            _query = sql;
        }
        final String query = _query;
        PreparedStatementCreator psc = new PreparedStatementCreator(){
            final /* synthetic */ SpringQuery this$0;
            {
                SpringQuery springQuery = this$0;
                Objects.requireNonNull(springQuery);
                this.this$0 = springQuery;
            }

            @NonNull
            public PreparedStatement createPreparedStatement(@NonNull Connection con) throws SQLException {
                PreparedStatement ps = con.prepareStatement(query);
                if (this.this$0.sqlControl != null && this.this$0.sqlControl.getMaxTimeout() != null) {
                    ps.setQueryTimeout(this.this$0.timeout);
                }
                if (this.this$0.fetchSize != null) {
                    ps.setFetchSize(this.this$0.fetchSize);
                }
                return ps;
            }
        };
        PreparedStatementSetter pss = new PreparedStatementSetter(){
            final /* synthetic */ SpringQuery this$0;
            {
                SpringQuery springQuery = this$0;
                Objects.requireNonNull(springQuery);
                this.this$0 = springQuery;
            }

            public void setValues(@NonNull PreparedStatement ps) throws SQLException {
                this.this$0.setParameters(this.this$0.parameterValues, ps, limitType, 1);
            }
        };
        ResultSetExtractor<List<Map<String, Object>>> rse = new ResultSetExtractor<List<Map<String, Object>>>(this){
            final /* synthetic */ SpringQuery this$0;
            {
                SpringQuery springQuery = this$0;
                Objects.requireNonNull(springQuery);
                this.this$0 = springQuery;
            }

            public List<Map<String, Object>> extractData(@NonNull ResultSet rs) throws SQLException, DataAccessException {
                if (this.this$0.fetchSize != null) {
                    rs.setFetchSize(this.this$0.fetchSize);
                }
                return this.this$0.getResults(rs);
            }
        };
        try {
            List list = (List)this.jdbcTemplate.query(psc, pss, (ResultSetExtractor)rse);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("list, number of returned rows=" + String.valueOf(list != null ? Integer.valueOf(list.size()) : "null"));
            }
            return list;
        }
        catch (DataAccessException ex) {
            throw this.newSqlProcessorException(ex, query);
        }
    }

    public Map<String, Object> unique(SqlRuntimeContext runtimeCtx) throws SqlProcessorException {
        List<Map<String, Object>> list = this.list(runtimeCtx);
        int size = list.size();
        if (size == 0) {
            return null;
        }
        Map<String, Object> first = list.get(0);
        int i = 1;
        if (i < size) {
            throw new RuntimeException("TODO UNIQUE");
        }
        return first;
    }

    public int query(SqlRuntimeContext runtimeCtx, final SqlQuery.SqlQueryRowProcessor sqlQueryRowProcessor) throws SqlProcessorException {
        String sql;
        String _query;
        StringBuilder queryResult = this.maxResults != null ? new StringBuilder(this.queryString.length() + 100) : null;
        final SqlFromToPlugin.LimitType limitType = this.maxResults != null ? runtimeCtx.getPluginFactory().getSqlFromToPlugin().limitQuery(runtimeCtx, this.queryString, queryResult, this.firstResult, this.maxResults, this.ordered) : null;
        String string = _query = limitType != null && queryResult != null ? queryResult.toString() : this.queryString;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("list, query=" + _query);
        }
        if (this.sqlControl != null && this.sqlControl.getLowLevelSqlCallback() != null && (sql = this.sqlControl.getLowLevelSqlCallback().handleInputValues(_query, this.parameterValues)) != null) {
            _query = sql;
        }
        final String query = _query;
        PreparedStatementCreator psc = new PreparedStatementCreator(){
            final /* synthetic */ SpringQuery this$0;
            {
                SpringQuery springQuery = this$0;
                Objects.requireNonNull(springQuery);
                this.this$0 = springQuery;
            }

            @NonNull
            public PreparedStatement createPreparedStatement(@NonNull Connection con) throws SQLException {
                PreparedStatement ps = con.prepareStatement(query);
                if (this.this$0.sqlControl != null && this.this$0.sqlControl.getMaxTimeout() != null) {
                    ps.setQueryTimeout(this.this$0.timeout);
                }
                if (this.this$0.fetchSize != null) {
                    ps.setFetchSize(this.this$0.fetchSize);
                }
                return ps;
            }
        };
        PreparedStatementSetter pss = new PreparedStatementSetter(){
            final /* synthetic */ SpringQuery this$0;
            {
                SpringQuery springQuery = this$0;
                Objects.requireNonNull(springQuery);
                this.this$0 = springQuery;
            }

            public void setValues(@NonNull PreparedStatement ps) throws SQLException {
                this.this$0.setParameters(this.this$0.parameterValues, ps, limitType, 1);
            }
        };
        ResultSetExtractor<Integer> rse = new ResultSetExtractor<Integer>(){
            final /* synthetic */ SpringQuery this$0;
            {
                SpringQuery springQuery = this$0;
                Objects.requireNonNull(springQuery);
                this.this$0 = springQuery;
            }

            public Integer extractData(@NonNull ResultSet rs) throws SQLException, DataAccessException {
                if (this.this$0.fetchSize != null) {
                    rs.setFetchSize(this.this$0.fetchSize);
                }
                int rownum = 0;
                Map<String, Object> row = this.this$0.getOneResult(rs);
                while (row != NO_MORE_DATA && sqlQueryRowProcessor.processRow(row, ++rownum)) {
                    row = this.this$0.getOneResult(rs);
                }
                return rownum;
            }
        };
        try {
            Integer rownums = (Integer)this.jdbcTemplate.query(psc, pss, (ResultSetExtractor)rse);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("list, number of returned rows=" + rownums);
            }
            return rownums;
        }
        catch (DataAccessException ex) {
            throw this.newSqlProcessorException(ex, query);
        }
    }

    public int update(SqlRuntimeContext runtimeCtx) throws SqlProcessorException {
        String sql;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("update, query=" + this.queryString);
        }
        if (this.sqlControl != null && this.sqlControl.getLowLevelSqlCallback() != null && (sql = this.sqlControl.getLowLevelSqlCallback().handleInputValues(this.queryString, this.parameterValues)) != null) {
            this.queryString = sql;
        }
        PreparedStatementCreator psc = new PreparedStatementCreator(this){
            final /* synthetic */ SpringQuery this$0;
            {
                SpringQuery springQuery = this$0;
                Objects.requireNonNull(springQuery);
                this.this$0 = springQuery;
            }

            @NonNull
            public PreparedStatement createPreparedStatement(@NonNull Connection con) throws SQLException {
                PreparedStatement ps = this.this$0.isSetJDBCIdentity() ? con.prepareStatement(this.this$0.queryString, 1) : con.prepareStatement(this.this$0.queryString);
                if (this.this$0.sqlControl != null && this.this$0.sqlControl.getMaxTimeout() != null) {
                    ps.setQueryTimeout(this.this$0.timeout);
                }
                return ps;
            }
        };
        PreparedStatementSetter pss = new PreparedStatementSetter(this){
            final /* synthetic */ SpringQuery this$0;
            {
                SpringQuery springQuery = this$0;
                Objects.requireNonNull(springQuery);
                this.this$0 = springQuery;
            }

            public void setValues(@NonNull PreparedStatement ps) throws SQLException {
                this.this$0.setParameters(this.this$0.parameterValues, ps, null, 1);
            }
        };
        try {
            int updated = 0;
            if (!this.identities.isEmpty()) {
                String identityName = this.identities.get(0);
                if (this.isSetJDBCIdentity()) {
                    updated = this.updateWithGenKeys(psc, pss, identityName);
                } else {
                    updated = this.updateWithoutGenKeys(psc, pss);
                    this.doIdentitySelect(identityName);
                }
            } else {
                updated = this.updateWithoutGenKeys(psc, pss);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("update, number of updated rows=" + updated);
            }
            return updated;
        }
        catch (DataAccessException ex) {
            throw this.newSqlProcessorException(ex, this.queryString);
        }
    }

    public int[] batch(SqlRuntimeContext runtimeCtx) throws SqlProcessorException {
        String sql;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("batch, query=" + this.queryString);
        }
        if (this.sqlControl != null && this.sqlControl.getLowLevelSqlCallback() != null && (sql = this.sqlControl.getLowLevelSqlCallback().handleInputValues(this.queryString, this.parameterValues)) != null) {
            this.queryString = sql;
        }
        PreparedStatementCreator psc = new PreparedStatementCreator(this){
            final /* synthetic */ SpringQuery this$0;
            {
                SpringQuery springQuery = this$0;
                Objects.requireNonNull(springQuery);
                this.this$0 = springQuery;
            }

            @NonNull
            public PreparedStatement createPreparedStatement(@NonNull Connection con) throws SQLException {
                PreparedStatement ps = this.this$0.isSetJDBCIdentity() ? con.prepareStatement(this.this$0.queryString, 1) : con.prepareStatement(this.this$0.queryString);
                if (this.this$0.sqlControl != null && this.this$0.sqlControl.getMaxTimeout() != null) {
                    ps.setQueryTimeout(this.this$0.timeout);
                }
                return ps;
            }
        };
        ArrayList<PreparedStatementSetter> psss = new ArrayList<PreparedStatementSetter>();
        for (final Map<String, Object> paramValues : this.batchParameterValues) {
            PreparedStatementSetter pss = new PreparedStatementSetter(){
                final /* synthetic */ SpringQuery this$0;
                {
                    SpringQuery springQuery = this$0;
                    Objects.requireNonNull(springQuery);
                    this.this$0 = springQuery;
                }

                public void setValues(@NonNull PreparedStatement ps) throws SQLException {
                    this.this$0.setParameters(paramValues, ps, null, 1);
                }
            };
            psss.add(pss);
        }
        try {
            int[] updated = !this.identities.isEmpty() ? this.updateWithoutGenKeys(psc, psss) : this.updateWithoutGenKeys(psc, psss);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("batch, number of updated rows=" + String.valueOf(updated));
            }
            return updated;
        }
        catch (DataAccessException ex) {
            throw this.newSqlProcessorException(ex, this.queryString);
        }
    }

    private boolean isSetJDBCIdentity() {
        for (String identityName : this.identities) {
            IdentitySetter identitySetter = this.identitySetters.get(identityName);
            if (!identitySetter.getIdentitySelect().equals(SqlFeature.JDBC.name())) continue;
            return true;
        }
        return false;
    }

    private void doIdentitySelect(final String identityName) {
        final IdentitySetter identitySetter = this.identitySetters.get(identityName);
        final Object identityType = this.identityTypes.get(identityName);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("identity, name=" + identityName + ", select=" + identitySetter.getIdentitySelect() + ", identityType=" + String.valueOf(identityType));
        }
        PreparedStatementCreator psc = new PreparedStatementCreator(){
            {
                Objects.requireNonNull(this$0);
            }

            @NonNull
            public PreparedStatement createPreparedStatement(@NonNull Connection con) throws SQLException {
                PreparedStatement ps = con.prepareStatement(identitySetter.getIdentitySelect());
                return ps;
            }
        };
        ResultSetExtractor<Object> rse = new ResultSetExtractor<Object>(){
            {
                Objects.requireNonNull(this$0);
            }

            public Object extractData(@NonNull ResultSet rs) throws SQLException, DataAccessException {
                Object identityValue = null;
                while (rs.next()) {
                    identityValue = identityType != null && identityType instanceof JdbcSqlType ? ((JdbcSqlType)identityType).get(rs, identityName) : rs.getObject(1);
                    if (!rs.wasNull()) continue;
                    identityValue = null;
                }
                return identityValue;
            }
        };
        try {
            Object identityValue = this.jdbcTemplate.query(psc, null, (ResultSetExtractor)rse);
            identitySetter.setIdentity(identityValue);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("identity, result=" + String.valueOf(identityValue));
            }
        }
        catch (DataAccessException ex) {
            throw new SqlProcessorException("Identity select failed.", (Throwable)ex);
        }
    }

    private void getGeneratedKeys(String identityName, Statement statement) {
        IdentitySetter identitySetter = this.identitySetters.get(identityName);
        Object identityType = this.identityTypes.get(identityName);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("identity, name=" + identityName + ", getGeneratedKeys(), identityType=" + String.valueOf(identityType));
        }
        ResultSet rs = null;
        Object identityValue = null;
        try {
            rs = statement.getGeneratedKeys();
            while (rs.next()) {
                identityValue = identityType != null && identityType instanceof JdbcSqlType ? ((JdbcSqlType)identityType).get(rs, identityName) : rs.getObject(1);
                if (!rs.wasNull()) continue;
                identityValue = null;
            }
            identitySetter.setIdentity(identityValue);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("identity, result=" + String.valueOf(identityValue));
            }
        }
        catch (SQLException he) {
            throw new SqlProcessorException("Statement.getGeneratedKeys() failed.", (Throwable)he);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    protected int updateWithGenKeys(PreparedStatementCreator psc, final PreparedStatementSetter pss, final String identityName) throws DataAccessException {
        this.logger.debug("Executing prepared SQL update with generated keys retrieval");
        Integer rows = (Integer)this.jdbcTemplate.execute(psc, (PreparedStatementCallback)new PreparedStatementCallback<Integer>(){
            final /* synthetic */ SpringQuery this$0;
            {
                SpringQuery springQuery = this$0;
                Objects.requireNonNull(springQuery);
                this.this$0 = springQuery;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Integer doInPreparedStatement(@NonNull PreparedStatement ps) throws SQLException {
                try {
                    if (pss != null) {
                        pss.setValues(ps);
                    }
                    int rows = ps.executeUpdate();
                    if (this.this$0.logger.isDebugEnabled()) {
                        this.this$0.logger.debug("SQL update affected " + rows + " rows");
                    }
                    if (identityName != null) {
                        this.this$0.getGeneratedKeys(identityName, ps);
                    }
                    Integer n = rows;
                    return n;
                }
                finally {
                    if (pss instanceof ParameterDisposer) {
                        ((ParameterDisposer)pss).cleanupParameters();
                    }
                }
            }
        });
        return rows != null ? rows : 0;
    }

    protected int updateWithoutGenKeys(PreparedStatementCreator psc, final PreparedStatementSetter pss) throws DataAccessException {
        this.logger.debug("Executing prepared SQL update");
        Integer rows = (Integer)this.jdbcTemplate.execute(psc, (PreparedStatementCallback)new PreparedStatementCallback<Integer>(){
            final /* synthetic */ SpringQuery this$0;
            {
                SpringQuery springQuery = this$0;
                Objects.requireNonNull(springQuery);
                this.this$0 = springQuery;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Integer doInPreparedStatement(@NonNull PreparedStatement ps) throws SQLException {
                try {
                    if (pss != null) {
                        pss.setValues(ps);
                    }
                    int rows = ps.executeUpdate();
                    if (this.this$0.logger.isDebugEnabled()) {
                        this.this$0.logger.debug("SQL update affected " + rows + " rows");
                    }
                    Integer n = rows;
                    return n;
                }
                finally {
                    if (pss instanceof ParameterDisposer) {
                        ((ParameterDisposer)pss).cleanupParameters();
                    }
                }
            }
        });
        return rows != null ? rows : 0;
    }

    protected int[] updateWithoutGenKeys(PreparedStatementCreator psc, final List<PreparedStatementSetter> psss) throws DataAccessException {
        this.logger.debug("Executing prepared SQL batch");
        int[] rows = (int[])this.jdbcTemplate.execute(psc, (PreparedStatementCallback)new PreparedStatementCallback<int[]>(){
            final /* synthetic */ SpringQuery this$0;
            {
                SpringQuery springQuery = this$0;
                Objects.requireNonNull(springQuery);
                this.this$0 = springQuery;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int[] doInPreparedStatement(@NonNull PreparedStatement ps) throws SQLException {
                try {
                    for (PreparedStatementSetter pss : psss) {
                        if (pss != null) {
                            pss.setValues(ps);
                        }
                        ps.addBatch();
                    }
                    int[] rows = ps.executeBatch();
                    if (this.this$0.logger.isDebugEnabled()) {
                        this.this$0.logger.debug("SQL batch affected " + String.valueOf(rows) + " rows");
                    }
                    int[] nArray = rows;
                    return nArray;
                }
                finally {
                    for (PreparedStatementSetter pss : psss) {
                        if (!(pss instanceof ParameterDisposer)) continue;
                        ((ParameterDisposer)pss).cleanupParameters();
                    }
                }
            }
        });
        return rows;
    }

    public List<Map<String, Object>> callList(SqlRuntimeContext runtimeCtx) throws SqlProcessorException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("callList, query=" + this.queryString);
        }
        CallableStatementCreator psc = new CallableStatementCreator(this){
            final /* synthetic */ SpringQuery this$0;
            {
                SpringQuery springQuery = this$0;
                Objects.requireNonNull(springQuery);
                this.this$0 = springQuery;
            }

            @NonNull
            public CallableStatement createCallableStatement(@NonNull Connection con) throws SQLException {
                Matcher matcher = CALL.matcher(this.this$0.queryString);
                if (!matcher.matches()) {
                    throw new SqlProcessorException("'" + this.this$0.queryString + "' isn't the correct call statement");
                }
                String query = matcher.group(1) != null ? "{? = call " + matcher.group(2) + "}" : "{ call " + matcher.group(2) + "}";
                CallableStatement cs = con.prepareCall(query);
                if (this.this$0.sqlControl != null && this.this$0.sqlControl.getMaxTimeout() != null) {
                    cs.setQueryTimeout(this.this$0.timeout);
                }
                if (this.this$0.fetchSize != null) {
                    cs.setFetchSize(this.this$0.fetchSize);
                }
                return cs;
            }
        };
        CallableStatementCallback<List<Map<String, Object>>> csc = new CallableStatementCallback<List<Map<String, Object>>>(this){
            final /* synthetic */ SpringQuery this$0;
            {
                SpringQuery springQuery = this$0;
                Objects.requireNonNull(springQuery);
                this.this$0 = springQuery;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<Map<String, Object>> doInCallableStatement(@NonNull CallableStatement cs) throws SQLException {
                List<Map<String, Object>> list;
                ResultSet rs;
                block5: {
                    rs = null;
                    list = null;
                    try {
                        this.this$0.setParameters(this.this$0.parameterValues, cs, null, 1);
                        boolean hasResultSet = cs.execute();
                        if (hasResultSet || cs.getMoreResults()) {
                            ResultSet rsToUse = rs = cs.getResultSet();
                            if (this.this$0.fetchSize != null) {
                                rs.setFetchSize(this.this$0.fetchSize);
                            }
                            list = this.this$0.getResults(rsToUse);
                            this.this$0.getParameters(cs, false);
                            break block5;
                        }
                        ResultSet rsToUse = rs = (ResultSet)this.this$0.getParameters(cs, true).values().toArray()[0];
                        if (this.this$0.fetchSize != null) {
                            rs.setFetchSize(this.this$0.fetchSize);
                        }
                        list = this.this$0.getResults(rsToUse);
                    }
                    catch (Throwable throwable) {
                        JdbcUtils.closeResultSet(rs);
                        throw throwable;
                    }
                }
                JdbcUtils.closeResultSet((ResultSet)rs);
                return list;
            }
        };
        try {
            List list = (List)this.jdbcTemplate.execute(psc, (CallableStatementCallback)csc);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("callList, number of returned rows=" + String.valueOf(list != null ? Integer.valueOf(list.size()) : "null"));
            }
            return list;
        }
        catch (DataAccessException ex) {
            throw this.newSqlProcessorException(ex, this.queryString);
        }
    }

    public Map<String, Object> callUnique(SqlRuntimeContext runtimeCtx) throws SqlProcessorException {
        List<Map<String, Object>> list = this.callList(runtimeCtx);
        int size = list.size();
        if (size == 0) {
            return null;
        }
        Map<String, Object> first = list.get(0);
        int i = 1;
        if (i < size) {
            throw new RuntimeException("TODO UNIQUE");
        }
        return first;
    }

    public int callUpdate(SqlRuntimeContext runtimeCtx) throws SqlProcessorException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("callUpdate, query=" + this.queryString);
        }
        CallableStatementCreator psc = new CallableStatementCreator(this){
            final /* synthetic */ SpringQuery this$0;
            {
                SpringQuery springQuery = this$0;
                Objects.requireNonNull(springQuery);
                this.this$0 = springQuery;
            }

            @NonNull
            public CallableStatement createCallableStatement(@NonNull Connection con) throws SQLException {
                Matcher matcher = CALL.matcher(this.this$0.queryString);
                if (!matcher.matches()) {
                    throw new SqlProcessorException("'" + this.this$0.queryString + "' isn't the correct call statement");
                }
                String query = matcher.group(1) != null ? "{? = call " + matcher.group(2) + "}" : "{ call " + matcher.group(2) + "}";
                CallableStatement cs = con.prepareCall(query);
                if (this.this$0.sqlControl != null && this.this$0.sqlControl.getMaxTimeout() != null) {
                    cs.setQueryTimeout(this.this$0.timeout);
                }
                return cs;
            }
        };
        CallableStatementCallback<Integer> csc = new CallableStatementCallback<Integer>(this){
            final /* synthetic */ SpringQuery this$0;
            {
                SpringQuery springQuery = this$0;
                Objects.requireNonNull(springQuery);
                this.this$0 = springQuery;
            }

            public Integer doInCallableStatement(@NonNull CallableStatement cs) throws SQLException {
                this.this$0.setParameters(this.this$0.parameterValues, cs, null, 1);
                cs.execute();
                Integer updated = cs.getUpdateCount();
                this.this$0.getParameters(cs, false);
                return updated;
            }
        };
        try {
            Integer updated = (Integer)this.jdbcTemplate.execute(psc, (CallableStatementCallback)csc);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("callUpdate, number of updated rows=" + updated);
            }
            return updated;
        }
        catch (DataAccessException ex) {
            throw this.newSqlProcessorException(ex, this.queryString);
        }
    }

    public Map<String, Object> callFunction() throws SqlProcessorException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("callList, query=" + this.queryString);
        }
        CallableStatementCreator psc = new CallableStatementCreator(this){
            final /* synthetic */ SpringQuery this$0;
            {
                SpringQuery springQuery = this$0;
                Objects.requireNonNull(springQuery);
                this.this$0 = springQuery;
            }

            @NonNull
            public CallableStatement createCallableStatement(@NonNull Connection con) throws SQLException {
                Matcher matcher = CALL.matcher(this.this$0.queryString);
                if (!matcher.matches()) {
                    throw new SqlProcessorException("'" + this.this$0.queryString + "' isn't the correct call statement");
                }
                String query = matcher.group(1) != null ? "{? = call " + matcher.group(2) + "}" : "{ call " + matcher.group(2) + "}";
                CallableStatement cs = con.prepareCall(query);
                if (this.this$0.sqlControl != null && this.this$0.sqlControl.getMaxTimeout() != null) {
                    cs.setQueryTimeout(this.this$0.timeout);
                }
                return cs;
            }
        };
        CallableStatementCallback<Map<String, Object>> csc = new CallableStatementCallback<Map<String, Object>>(this){
            final /* synthetic */ SpringQuery this$0;
            {
                SpringQuery springQuery = this$0;
                Objects.requireNonNull(springQuery);
                this.this$0 = springQuery;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Map<String, Object> doInCallableStatement(@NonNull CallableStatement cs) throws SQLException {
                Map<String, Object> result;
                ResultSet rs;
                block5: {
                    rs = null;
                    List<Map<String, Object>> list = null;
                    result = null;
                    try {
                        this.this$0.setParameters(this.this$0.parameterValues, cs, null, 1);
                        boolean hasResultSet = cs.execute();
                        if (hasResultSet) {
                            ResultSet rsToUse = rs = cs.getResultSet();
                            if (this.this$0.fetchSize != null) {
                                rs.setFetchSize(this.this$0.fetchSize);
                            }
                            if ((list = this.this$0.getResults(rsToUse)) != null && !list.isEmpty()) {
                                result = list.get(0);
                            }
                            this.this$0.getParameters(cs, false);
                            break block5;
                        }
                        result = this.this$0.getParameters(cs, true);
                    }
                    catch (Throwable throwable) {
                        JdbcUtils.closeResultSet(rs);
                        throw throwable;
                    }
                }
                JdbcUtils.closeResultSet((ResultSet)rs);
                return result;
            }
        };
        try {
            Map result = (Map)this.jdbcTemplate.execute(psc, (CallableStatementCallback)csc);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("callFunction, result=" + String.valueOf(result));
            }
            return result;
        }
        catch (DataAccessException ex) {
            throw this.newSqlProcessorException(ex, this.queryString);
        }
    }

    public SqlQuery addScalar(String columnAlias) {
        this.scalars.add(columnAlias);
        return this;
    }

    public SqlQuery addScalar(String columnAlias, Object type, Class<?> ... moreTypes) {
        if (type != null && !(type instanceof JdbcSqlType) && !(type instanceof Integer)) {
            throw new IllegalArgumentException();
        }
        this.scalars.add(columnAlias);
        this.scalarTypes.put(columnAlias, type);
        return this;
    }

    public SqlQuery setParameter(String name, Object val) throws SqlProcessorException {
        this.parameters.add(name);
        this.parameterValues.put(name, val);
        return this;
    }

    public SqlQuery setParameter(String name, Object val, Object type, Class<?> ... moreTypes) throws SqlProcessorException {
        if (type != null && !(type instanceof JdbcSqlType) && !(type instanceof Integer)) {
            throw new IllegalArgumentException();
        }
        if (val != null && val instanceof IdentitySetter) {
            this.identities.add(name);
            this.identitySetters.put(name, (IdentitySetter)val);
            this.identityTypes.put(name, type);
        } else if (val != null && val instanceof OutValueSetter) {
            if (!this.parameterTypes.containsKey(name)) {
                this.parameters.add(name);
                this.parameterTypes.put(name, type);
            }
            this.parameterOutValueTypes.put(name, type);
            this.parameterOutValueSetters.put(name, (OutValueSetter)val);
        } else {
            this.parameters.add(name);
            this.parameterValues.put(name, val);
            this.parameterTypes.put(name, type);
        }
        return this;
    }

    public SqlQuery setParameterList(String name, Object[] vals) throws SqlProcessorException {
        throw new UnsupportedOperationException();
    }

    public SqlQuery setParameterList(String name, Object[] vals, Object type, Class<?> ... moreTypes) throws SqlProcessorException {
        throw new UnsupportedOperationException();
    }

    protected void setParameters(Map<String, Object> parameterValues, PreparedStatement ps, SqlFromToPlugin.LimitType limitType, int start) throws SQLException {
        int ix = start;
        ix = this.setLimits(ps, limitType, ix, false);
        int n = this.parameters.size();
        for (int i = 0; i < n; ++i) {
            String name = this.parameters.get(i);
            Object type = this.parameterTypes.get(name);
            if (parameterValues.containsKey(name)) {
                Object value = parameterValues.get(name);
                if (type != null) {
                    if (type instanceof JdbcSqlType) {
                        if (value == null) {
                            ps.setNull(ix + i, ((JdbcSqlType)type).getDatabaseSqlType());
                        } else {
                            ((JdbcSqlType)type).set(ps, ix + i, value);
                        }
                    } else if (value == null) {
                        ps.setNull(ix + i, (Integer)type);
                    } else {
                        ps.setObject(ix + i, value, (Integer)type);
                    }
                } else {
                    ps.setObject(ix + i, value);
                }
            }
            if (!this.parameterOutValueSetters.containsKey(name)) continue;
            CallableStatement cs = (CallableStatement)ps;
            if (type != null) {
                if (type instanceof JdbcSqlType) {
                    cs.registerOutParameter(ix + i, (int)((JdbcSqlType)type).getDatabaseSqlType());
                } else {
                    cs.registerOutParameter(ix + i, (int)((Integer)type));
                }
            } else {
                throw new SqlProcessorException("OUT parameter type for callable statement is null");
            }
            this.parameterOutValuesToPickup.put(i, ix + i);
        }
        ix = this.setLimits(ps, limitType, ix + this.parameters.size(), true);
    }

    protected int setLimits(PreparedStatement ps, SqlFromToPlugin.LimitType limitType, int ix, boolean afterSql) throws SQLException {
        if (limitType == null) {
            return ix;
        }
        if (afterSql && !limitType.afterSql) {
            return ix;
        }
        if (!afterSql && limitType.afterSql) {
            return ix;
        }
        if (limitType.maxBeforeFirst) {
            if (limitType.rowidBasedMax && limitType.alsoFirst) {
                ps.setInt(ix++, this.firstResult + this.maxResults);
            } else {
                ps.setInt(ix++, this.maxResults);
            }
        }
        if (limitType.alsoFirst) {
            if (limitType.zeroBasedFirst) {
                ps.setInt(ix++, this.firstResult);
            } else {
                ps.setInt(ix++, this.firstResult);
            }
        }
        if (!limitType.maxBeforeFirst) {
            if (limitType.rowidBasedMax && limitType.alsoFirst) {
                ps.setInt(ix++, this.firstResult + this.maxResults);
            } else {
                ps.setInt(ix++, this.maxResults);
            }
        }
        return ix;
    }

    protected Map<String, Object> getParameters(CallableStatement cs, boolean isFunction) throws SQLException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        boolean resultInited = false;
        for (int i : this.parameterOutValuesToPickup.keySet()) {
            int ix = this.parameterOutValuesToPickup.get(i);
            String name = this.parameters.get(i);
            Object type = this.parameterOutValueTypes.get(name);
            if (type == null) {
                type = this.parameterTypes.get(name);
            }
            OutValueSetter outValueSetter = this.parameterOutValueSetters.get(name);
            Object outValue = null;
            outValue = type != null && type instanceof JdbcSqlType ? ((JdbcSqlType)type).get(cs, ix) : cs.getObject(ix);
            outValueSetter.setOutValue(outValue);
            if (resultInited) continue;
            result.put(name, outValue);
            resultInited = true;
        }
        return result;
    }

    protected List<Map<String, Object>> getResults(ResultSet rs) throws SQLException {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (rs == null) {
            return result;
        }
        Map<String, Object> row = this.getOneResult(rs);
        while (row != NO_MORE_DATA) {
            if (this.sqlControl != null && this.sqlControl.getLowLevelSqlCallback() != null) {
                this.sqlControl.getLowLevelSqlCallback().handleOutputValues(row);
            }
            result.add(row);
            row = this.getOneResult(rs);
        }
        return result;
    }

    protected Map<String, Object> getOneResult(ResultSet rs) throws SQLException {
        if (rs == null) {
            return NO_MORE_DATA;
        }
        if (rs.next()) {
            LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
            int n = this.scalars.size();
            for (int i = 0; i < n; ++i) {
                String name = this.scalars.get(i);
                Object type = this.scalarTypes.get(name);
                Object value = null;
                value = type != null && type instanceof JdbcSqlType ? ((JdbcSqlType)type).get(rs, name) : rs.getObject(name);
                if (rs.wasNull()) {
                    value = null;
                }
                row.put(name, value);
            }
            return row;
        }
        return NO_MORE_DATA;
    }

    public int[] executeBatch(String[] statements) throws SqlProcessorException {
        try {
            int[] result = this.jdbcTemplate.batchUpdate(statements);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("executeBatch, result " + String.valueOf(SqlUtils.asList((int[])result)));
            }
            return result;
        }
        catch (DataAccessException ex) {
            throw new SqlProcessorException((Throwable)ex);
        }
    }

    protected SqlProcessorException newSqlProcessorException(DataAccessException ex, String query) {
        if (this.logError) {
            this.logger.error("Failed SQL command '" + query + "': " + ex.getMessage());
            return new SqlProcessorException((Throwable)ex);
        }
        return new SqlProcessorException((Throwable)ex, query);
    }

    public void setLogError(boolean logError) {
        this.logError = logError;
    }
}

