package org.sqlproc.engine.impl;

import java.util.List;

import org.sqlproc.engine.SqlMonitor;

/**
 * The empty implementation of {@link org.sqlproc.engine.SqlMonitor} interface.
 * 
 * @author <a href="mailto:Vladimir.Hudec@gmail.com">Vladimir Hudec</a>
 */
public class SqlEmptyMonitor implements SqlMonitor {

    /**
     * {@inheritDoc}
     */
    @Override
    public <E> List<E> runQuery(Runner runner, Class<E> resultClass) {

        return (List<E>) runner.run();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int runQueryCount(Runner runner) {
        return (Integer) runner.run();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String runGetSql(Runner runner) {
        return (String) runner.run();
    }
}
