/**
 * The package <code>org.sqlproc.engine</code> contains the public part of <b>SQL Processor</b> implementation.
 * The most important class is {@link org.sqlproc.engine.SqlEngine}. There are also some helper classes and basic 
 * interfaces.
 * 
 * <p>
 * <b>SQL Processor</b> is <i>Data Driven Query Engine</i>. It's able to dynamically generate ANSI SQL query based
 * on search data provided by the user or the application. This is done in the runtime, without any
 * plumbing code required.
 * 
 * <p>
 * In other words - SQL Processor has 3 basic inputs:
 * <ul>
 * <li>A <b>META SQL</b>, an ANSI SQL extension based on ANTLR grammar. For example it can be 
 * <code>select p.ID id, p.NAME name from PERSON p where 1=1 {& id=:id} {& UPPER(name)=:+name}<code>
 * <li>Input values provided by the user. These data are collected in a search form, a standard 
 * POJO object, which can by created in presentation layer of a web application.
 * <li>A result class definition, which is used to carry output data from a SQL query execution. This
 * class is a standard POJO object, instances of which are created in SQL Processor without any plumbing
 * code. It can work as a transport object from persistence to presentation layer of a web application. 
 * </ul>
 *
 * Next, SQL Processor has one output - the list of instances of result class.
 * 
 * <p>
 * For the META SQL described above the generated ANSI SQL can be
 * <ul>
 * <li><code>select p.ID id, p.NAME name from PERSON p where 1=1<code> in the case there are no values
 * in a search form
 * <li><code>select p.ID id, p.NAME name from PERSON p where 1=1 and id=?<code> in the case there's 
 * a not null <code>id</code> attribute in a search form
 * </ul>
 *
 * <p>
 * In the process of data collection from a search form it's used Reflection API. The same is used in the process
 * of seeding instances of result class with SQL query execution output. 
 *
 * <p>
 * The package <code>org.sqlproc.engine.impl</code> contains non public part of <b>SQL Processor</b> implementation,
 * without any Javadoc. This is because the implementation can be changed any time to improve SQL Processor
 * capabilities.
 * 
 * <p>
 * For more info please see the User's tutorial.
 * 
 * @author <a href="mailto:Vladimir.Hudec@gmail.com">Vladimir Hudec</a>
 */
package org.sqlproc.engine;