/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import org.antlr.runtime.CommonToken;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.impl.ErrorMsg;
import org.sqlproc.engine.impl.SqlInputValue;
import org.sqlproc.engine.impl.SqlMetaAndOrItem;
import org.sqlproc.engine.impl.SqlMetaConst;
import org.sqlproc.engine.impl.SqlMetaIdent;
import org.sqlproc.engine.impl.SqlMetaIfItem;
import org.sqlproc.engine.impl.SqlMetaLogExpr;
import org.sqlproc.engine.impl.SqlMetaOrd;
import org.sqlproc.engine.impl.SqlMetaStatement;
import org.sqlproc.engine.impl.SqlMetaText;

class ParserUtils {
    private static Logger logger = LoggerFactory.getLogger(ParserUtils.class);

    private ParserUtils() {
    }

    static void addText(Object target, StringBuilder text) {
        if (logger.isDebugEnabled()) {
            logger.debug("addText " + text);
        }
        if (text != null && text.length() > 0) {
            if (target instanceof SqlMetaStatement) {
                ((SqlMetaStatement)target).addElement(new SqlMetaText(text.toString()));
            } else if (target instanceof SqlMetaAndOrItem) {
                ((SqlMetaAndOrItem)target).addElement(new SqlMetaText(text.toString()));
            } else if (target instanceof SqlMetaOrd) {
                ((SqlMetaOrd)target).addElement(new SqlMetaText(text.toString()));
            } else if (target instanceof SqlMetaIfItem) {
                ((SqlMetaIfItem)target).addElement(new SqlMetaText(text.toString()));
            } else {
                throw new RuntimeException("Invalid target for addText :" + target);
            }
            text.delete(0, text.length());
        }
    }

    static void addIdent(Object target, SqlMetaIdent ident, StringBuilder text) {
        if (logger.isDebugEnabled()) {
            logger.debug("addIdent " + ident);
        }
        if (ident != null) {
            if (target instanceof SqlMetaStatement) {
                ParserUtils.addText(target, text);
                ((SqlMetaStatement)target).addElement(ident);
            } else if (target instanceof SqlMetaAndOrItem) {
                ParserUtils.addText(target, text);
                ((SqlMetaAndOrItem)target).addElement(ident);
            } else if (target instanceof SqlMetaOrd) {
                ParserUtils.addText(target, text);
                ((SqlMetaOrd)target).addElement(ident);
            } else if (target instanceof SqlMetaLogExpr) {
                ((SqlMetaLogExpr)target).addElement(ident);
            } else if (target instanceof SqlMetaIfItem) {
                ParserUtils.addText(target, text);
                ((SqlMetaIfItem)target).addElement(ident);
            } else {
                throw new RuntimeException("Invalid target for addIdent :" + target);
            }
        }
    }

    static void addConstant(Object target, SqlMetaConst cnst, StringBuilder text) {
        if (logger.isDebugEnabled()) {
            logger.debug("addConstant " + cnst);
        }
        if (cnst != null) {
            if (target instanceof SqlMetaStatement) {
                ParserUtils.addText(target, text);
                ((SqlMetaStatement)target).addElement(cnst);
            } else if (target instanceof SqlMetaAndOrItem) {
                ParserUtils.addText(target, text);
                ((SqlMetaAndOrItem)target).addElement(cnst);
            } else if (target instanceof SqlMetaOrd) {
                ParserUtils.addText(target, text);
                ((SqlMetaOrd)target).addElement(cnst);
            } else if (target instanceof SqlMetaLogExpr) {
                ((SqlMetaLogExpr)target).addElement(cnst);
            } else if (target instanceof SqlMetaIfItem) {
                ParserUtils.addText(target, text);
                ((SqlMetaIfItem)target).addElement(cnst);
            } else {
                throw new RuntimeException("Invalid target for addConstant :" + target);
            }
        }
    }

    static SqlMetaConst newConstant(String name, String caseConversion) {
        if (logger.isDebugEnabled()) {
            logger.debug("getSqlConst " + name);
        }
        SqlInputValue.Case caseConv = SqlInputValue.Case.NONE;
        if ("+".equals(caseConversion)) {
            caseConv = SqlInputValue.Case.UPPER;
        } else if ("-".equals(caseConversion)) {
            caseConv = SqlInputValue.Case.LOWER;
        }
        if (name.length() > 0) {
            String[] idents;
            SqlMetaConst constant = new SqlMetaConst(caseConv);
            for (String ident : idents = name.split("\\.")) {
                constant.addConst(ident);
            }
            return constant;
        }
        return null;
    }

    static SqlMetaIdent newIdent(String name, String caseConversion) {
        if (logger.isDebugEnabled()) {
            logger.debug("getSqlIdent " + name);
        }
        SqlInputValue.Case caseConv = SqlInputValue.Case.NONE;
        if ("+".equals(caseConversion)) {
            caseConv = SqlInputValue.Case.UPPER;
        } else if ("-".equals(caseConversion)) {
            caseConv = SqlInputValue.Case.LOWER;
        }
        if (name.length() > 0) {
            String[] idents;
            SqlMetaIdent identifier = new SqlMetaIdent(caseConv);
            for (String ident : idents = name.split("\\.")) {
                identifier.addIdent(ident);
            }
            return identifier;
        }
        return null;
    }

    public static ErrorMsg create(RecognitionException ex, String[] tokenNames) {
        String msg = "Parse error";
        try {
            if (ex instanceof MismatchedTokenException) {
                MismatchedTokenException mte = (MismatchedTokenException)ex;
                if (ex.token.getType() == -1) {
                    msg = "Unexpected end of file! Expecting " + tokenNames[mte.expecting];
                } else if (tokenNames != null && ex.token != null && ex.token.getText() != null) {
                    msg = "Unexpected token '" + ex.token.getText() + "' (type: " + tokenNames[ex.getUnexpectedType()] + ") - expecting : " + (mte.expecting == -1 ? "end of File" : tokenNames[mte.expecting]);
                }
            } else if (ex.token != null && ex.token.getText() != null) {
                msg = "Unexpected token '" + ex.token.getText() + "' (type: " + tokenNames[ex.getUnexpectedType()] + ")";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ParserUtils.create(msg, ex, tokenNames);
    }

    public static ErrorMsg create(String msg, RecognitionException ex, String[] tokenNames) {
        Token t;
        int length = 1;
        if (ex.token != null && ex.token.getText() != null) {
            length = ex.token.getText().length();
        }
        if (ex.token != null && (t = ex.token) instanceof CommonToken) {
            CommonToken ct = (CommonToken)t;
            return new ErrorMsg(msg, ct.getStartIndex(), ct.getStopIndex() - ct.getStartIndex(), ct.getLine());
        }
        return new ErrorMsg(msg, ex.index >= 0 ? ex.index : 0, length, ex.line);
    }
}

