/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.util.List;
import java.util.Map;
import org.sqlproc.engine.SqlFeature;
import org.sqlproc.engine.SqlOrder;

class SqlProcessContext
implements SqlFeature {
    Object dynamicInputValues;
    Object staticInputValues;
    List<SqlOrder> order;
    Map<String, Object> features;

    SqlProcessContext(Object dynamicInputValues, List<SqlOrder> order, Map<String, Object> features) {
        this(dynamicInputValues, null, order, features);
    }

    SqlProcessContext(Object dynamicInputValues, Object staticInputValues, List<SqlOrder> order, Map<String, Object> features) {
        this.dynamicInputValues = dynamicInputValues != null ? dynamicInputValues : new Object();
        this.staticInputValues = staticInputValues;
        this.order = order;
        this.features = features;
    }

    @Override
    public String getFeature(String name) {
        Object o = this.features.get(name);
        return o != null && o instanceof String ? (String)o : null;
    }

    @Override
    public boolean isFeature(String name) {
        Object o = this.features.get(name);
        return o != null && o instanceof Boolean && (Boolean)o != false;
    }

    @Override
    public Integer getFeatureAsInt(String name) {
        Object o = this.features.get(name);
        if (o == null || !(o instanceof String)) {
            return null;
        }
        try {
            return Integer.parseInt((String)o);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public int getOrderIndex(int orderId) {
        if (this.order == null || this.order.isEmpty()) {
            return -1;
        }
        for (int i = 0; i < this.order.size(); ++i) {
            SqlOrder sqlOrder = this.order.get(i);
            if (sqlOrder.getOrderId() != orderId) continue;
            return i;
        }
        return -1;
    }

    public SqlOrder.Order getOrder(int orderIndex) {
        if (orderIndex < 0 || orderIndex >= this.order.size()) {
            return SqlOrder.Order.NONE;
        }
        return this.order.get(orderIndex).getOrderDirrection();
    }
}

