package org.sqlproc.engine;

import java.util.Map;

/**
 * The factory definition, which can be used to construct {@link SqlMonitor}.
 * 
 * <p>
 * The factory can be based on Spring DI framework.
 * 
 * <p>
 * For more info please see the User's tutorial.
 * 
 * @author <a href="mailto:Vladimir.Hudec@gmail.com">Vladimir Hudec</a>
 */
public interface SqlMonitorFactory {

    /**
     * The main contract of this factory.
     * 
     * @param name
     *            the name of META SQL in queries.properties, which can be used to identify also the monitor instance
     *            itself
     * @param features
     *            the configuration of SQL Processor using Map of features
     * @return the instance of the SqlMonitor
     */
    SqlMonitor getSqlMonitor(String name, Map<String, Object> features);
}
